/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.IdentityGenerator;

public class EndPoint {
    LinkedList _listeners = new LinkedList();
    HashMap _contexts = new HashMap();
    static int _statsCntListeners = 0;
    static Object _statsLock = new Object();
    JID _jid;
    private static IdentityGenerator random = new IdentityGenerator();
    LinkedList _strangers = new LinkedList();

    public EndPoint() {
    }

    public EndPoint(JID jid) {
        this._jid = jid;
        Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] created");
    }

    public EndPoint(String jid) {
        this._jid = new JID(jid);
        Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] created");
    }

    void setContext(String key, Object o) {
        this._contexts.put(key, o);
    }

    Object getContext(String key) {
        return this._contexts.get(key);
    }

    public void notify(Packet packet) throws StreamException {
        this.notify(packet, null, this._jid, true);
    }

    public void notify(Packet packet, Object sender, JID from) throws StreamException {
        this.notify(packet, sender, from, true);
    }

    public synchronized void notify(Packet packet, Object sender, JID from, boolean echo) throws StreamException {
        boolean isIBBOpenPacket = false;
        boolean isIBBOtherPacket = false;
        boolean isSunAttachPacket = false;
        StreamElement element = null;
        String sid = null;
        ArrayList<EndPointListener> cleanupList = null;
        if (packet instanceof InfoQuery && (element = packet.getFirstElement("open", IBBHandler.NAMESPACE)) != null) {
            isIBBOpenPacket = true;
            sid = element.getAttributeValue("sid");
            cleanupList = new ArrayList<EndPointListener>();
        } else if (!(packet instanceof Presence) && (element = packet.getFirstElement(null, IBBHandler.NAMESPACE)) != null) {
            isIBBOtherPacket = true;
        } else if (packet instanceof Message && (element = packet.getFirstElement(IBBHandler.SUN_ATTACH_NAME)) != null) {
            isSunAttachPacket = true;
            String sid_list = element.normalizeTrimText();
            StringTokenizer st = new StringTokenizer(sid_list, ",");
            while (st.hasMoreTokens()) {
                sid = st.nextToken();
            }
        }
        Log.debug("EndPoint[" + this._jid + "] notify " + this._listeners.size() + " listener(s): " + packet);
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            Packet p;
            EndPointListener s = (EndPointListener)i.next();
            if (sender != null && s.equals(sender) && !echo) {
                Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] echo blocked for " + s.getJID());
                continue;
            }
            if (s instanceof StreamEndPoint && isIBBOtherPacket) {
                Log.debug("[EndPoint] process a IBB packet");
                ((StreamEndPoint)s).processIBBPacket(s.duplicate(packet), from, element);
                continue;
            }
            if (s instanceof StreamEndPoint && isSunAttachPacket) {
                Log.debug("[EndPoint] process a sun attachment packet");
                ((StreamEndPoint)s).processSunAttachPacket(s.duplicate(packet), from, sid);
                continue;
            }
            if (this._strangers.contains(s) && packet instanceof Presence && Presence.UNAVAILABLE.equals((Object)packet.getType()) || (p = s.duplicate(packet)) == null) continue;
            if (s instanceof StreamEndPoint && isIBBOpenPacket) {
                Log.debug("EndPoint[" + this._jid + "] IBB open " + s.getJID());
                ((StreamEndPoint)s).processIBBOpenPacket(from, sid);
                p.setID(sid);
                cleanupList.add(s);
            } else {
                p.setID(EndPoint.getUniqueID(p.getLocalName()));
            }
            p.setTo(s.getJID());
            Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] notifying " + s.getJID() + " instance of " + s.getClass());
            p.setFrom(from);
            s.send(p);
            Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] notified " + s.getJID());
        }
        if (isIBBOpenPacket) {
            Timer t = new Timer(true);
            class CleanupThread
            extends TimerTask {
                List list;
                String id;

                public CleanupThread(List l, String s) {
                    this.list = l;
                    this.id = s;
                }

                public void run() {
                    Log.debug("[EndPoint] Invoking the clean up of IBB streams.");
                    Iterator itr = this.list.iterator();
                    while (itr.hasNext()) {
                        ((StreamEndPoint)itr.next()).removeIBBStream(this.id);
                    }
                }
            }
            t.schedule((TimerTask)new CleanupThread(cleanupList, sid), 10000L);
        }
    }

    public synchronized void notify(Packet packet, Object sender) throws StreamException {
        this.notify(packet, sender, this._jid, true);
    }

    public JID getJID() {
        return this._jid;
    }

    public void setJID(JID jid) {
        this._jid = jid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addListener(EndPointListener l) {
        boolean reallyAdded = true;
        Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] addListener: " + l.getJID());
        int index = this._listeners.indexOf(l);
        if (index >= 0) {
            EndPointListener oldl = (EndPointListener)this._listeners.remove(index);
            if (oldl == l || oldl.isAvailable()) {
                Log.info("EndPoint[" + this._jid + "] Listener already present: " + l.getJID());
                reallyAdded = false;
            }
        } else {
            this._strangers.remove(l);
        }
        this._listeners.add(l);
        if (reallyAdded) {
            Object object = _statsLock;
            synchronized (object) {
            }
            Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] added listener: " + l.getJID() + " STAT:NumEndPointListener=" + ++_statsCntListeners);
        }
        return reallyAdded;
    }

    public boolean hasListener() {
        return this._listeners.size() > 0;
    }

    public List getListeners() {
        return (List)this._listeners.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeListener(EndPointListener l) {
        boolean b = this._listeners.remove(l);
        if (b) {
            Object object = _statsLock;
            synchronized (object) {
            }
            Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] removed listener: " + l.getJID() + " STAT:numEndPointListener=" + --_statsCntListeners);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAllListeners() {
        Object object = _statsLock;
        synchronized (object) {
        }
        Log.debug("EndPoint[" + this._jid + " [" + this.hashCode() + "]] removed all listeners. STAT:numEndPointListener=" + (_statsCntListeners -= this._listeners.size()));
        this._listeners.clear();
    }

    public String getName() {
        return this.getJID().getNode();
    }

    public String getFQName() {
        return this.getJID().toBareJID().toString();
    }

    public String getUID() {
        return this.getJID().toString();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof EndPoint && ((EndPoint)o).getJID().equals(this._jid);
    }

    public static String getUniqueID(String key) {
        return random.generate(key);
    }

    public Packet duplicate(Packet packet) {
        return (Packet)packet.copy();
    }

    synchronized boolean addStranger(EndPointListener epl) {
        if (!this._listeners.contains(epl) && !this._strangers.contains(epl)) {
            this._strangers.add(epl);
            return true;
        }
        return false;
    }

    synchronized void removeStranger(EndPointListener epl) {
        this._strangers.remove(epl);
    }

    synchronized void removeStrangers(Packet packet) {
        Iterator i = this._strangers.iterator();
        while (i.hasNext()) {
            EndPointListener epl = (EndPointListener)i.next();
            Packet p = epl.duplicate(packet);
            if (p == null) continue;
            p.setTo(epl.getJID());
            epl.send(p);
        }
        this._strangers.clear();
    }
}

