/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Discoverable;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MessageHandler;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.RealmException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;

public class DiscoHandler
extends AbstractHandler
implements Discoverable {
    protected static String NAMESPACE_BROWSE = "jabber:iq:browse";
    protected static String NAMESPACE_AGENTS = "jabber:iq:agents";
    protected static NSI NAME_BROWSE = new NSI("query", NAMESPACE_BROWSE);
    protected static NSI NAME_AGENTS = new NSI("query", NAMESPACE_AGENTS);
    private static NSI NAME_ITEMS = new NSI("query", "http://jabber.org/protocol/disco#items");
    private static NSI NAME_INFO = new NSI("query", "http://jabber.org/protocol/disco#info");
    private static NSI NSI_NS = new NSI("ns", null);
    private static NSI NSI_AGENT = new NSI("agent", null);
    private static NSI NSI_ITEM = new NSI("item", null);
    private static NSI NSI_NAME = new NSI("name", null);
    static MonitorTransactionFactory tranFactory = null;
    private static Hashtable _discoverables;

    public void processItemsQuery(StreamEndPoint session, Packet packet) {
        Discoverable d;
        String errorText = null;
        PacketError.Type errorType = null;
        DiscoItemsQuery responseQuery = null;
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (tranFactory != null) {
            transaction = tranFactory.startTransaction();
        }
        try {
            d = this.getDiscoverable(packet.getTo());
        }
        catch (Exception e) {
            session.sendError(packet, PacketError.MODIFY, "jid-malformed", "missing or malformed recipient", transaction);
            return;
        }
        if (d == null && packet.getTo().hasNode()) {
            this.relay(session, packet, transaction);
            return;
        }
        if (packet.getType() == InfoQuery.GET) {
            List queryNodes = packet.listElements(NAME_ITEMS);
            DiscoItemsQuery query = (DiscoItemsQuery)queryNodes.get(0);
            StreamDataFactory fac = session.getDataFactory();
            responseQuery = (DiscoItemsQuery)fac.createElementNode(NAME_ITEMS, null);
            if (d != null) {
                errorType = d.fillItems(responseQuery, packet.getTo(), query.getNode(), session);
            }
            if (errorType == null) {
                session.sendResult(packet, (StreamElement)responseQuery, transaction);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else if (packet.getType() == InfoQuery.SET) {
            List queryNodes = packet.listElements("query");
            DiscoItemsQuery query = (DiscoItemsQuery)queryNodes.get(0);
            if (d != null) {
                errorType = d.updateItems(query, packet.getTo(), session);
            }
            if (errorType == null) {
                session.sendResult(packet, transaction);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.", transaction);
        }
    }

    public void processInfoQuery(StreamEndPoint session, Packet packet) {
        Discoverable d;
        String errorText = null;
        PacketError.Type errorType = null;
        DiscoInfoQuery responseQuery = null;
        Log.debug("[Disco] info");
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (tranFactory != null) {
            transaction = tranFactory.startTransaction();
        }
        try {
            d = this.getDiscoverable(packet.getTo());
        }
        catch (Exception e) {
            session.sendError(packet, PacketError.MODIFY, "jid-malformed", "missing or malformed recipient", transaction);
            return;
        }
        if (d == null && packet.getTo().hasNode()) {
            this.relay(session, packet, transaction);
            return;
        }
        if (packet.getType() == InfoQuery.GET) {
            List queryNodes = packet.listElements(NAME_INFO);
            DiscoInfoQuery query = (DiscoInfoQuery)queryNodes.get(0);
            StreamDataFactory fac = session.getDataFactory();
            responseQuery = (DiscoInfoQuery)fac.createElementNode(NAME_INFO, null);
            responseQuery.setNode(query.getNode());
            if (d != null) {
                errorType = d.fillInfo(responseQuery, packet.getTo(), query.getNode(), session);
            }
            if (errorType == null) {
                session.sendResult(packet, (StreamElement)responseQuery, transaction);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "Only GET Disco Info IQ requests are supported.", transaction);
        }
    }

    public void processAgentInfoRequest(StreamEndPoint session, Packet packet) {
        String errorText = null;
        PacketError.Type errorType = null;
        Log.debug("[Agents] new packet");
        if (!session.validate(packet)) {
            return;
        }
        List queryNodes = packet.listElements(NAME_AGENTS);
        StreamElement query = (StreamElement)queryNodes.get(0);
        StreamDataFactory sdf = session.getDataFactory();
        if (packet.getType().equals((Object)InfoQuery.GET)) {
            Log.debug("[Agents] get");
            StreamElement responseQuery = sdf.createElementNode(NAME_AGENTS, null);
            Iterator iter = _discoverables.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String domain = (String)entry.getKey();
                if (domain.indexOf(46) < 0) {
                    domain = domain + "." + session.getJID().getDomain();
                }
                Discoverable d = (Discoverable)entry.getValue();
                StreamElement agent = sdf.createElementNode(NSI_AGENT, null);
                agent.setAttributeValue("jid", domain);
                responseQuery.add((StreamNode)agent);
                d.fillAgentInfo(agent, session);
                StreamElement name = sdf.createElementNode(NSI_NAME, null);
                name.add((StreamNode)sdf.createText(d.getName()));
                agent.add((StreamNode)name);
            }
            if (errorType == null) {
                session.sendResult(packet, responseQuery);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText);
            }
        } else {
            session.sendError(packet, PacketError.CANCEL, "bad-request", "IQ request types are set or get, period.");
        }
    }

    private void relay(StreamEndPoint session, Packet packet, MonitorTransaction transaction) {
        try {
            BaseUser u = this.getUser(packet.getTo().toBareJID());
            if (u != null) {
                this.deliver(session, packet, u, transaction);
            } else {
                session.sendError(packet, PacketError.CANCEL, "item-not-found", packet.getTo().toString() + " not found", transaction);
            }
        }
        catch (RealmException re) {
            Log.printStackTrace((Exception)((Object)re));
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage(), transaction);
        }
    }

    public void processBrowseRequest(StreamEndPoint session, Packet packet) {
        Discoverable dis;
        String errorText = null;
        PacketError.Type errorType = null;
        Log.debug("[Browse] new packet");
        if (!session.validate(packet)) {
            return;
        }
        try {
            dis = this.getDiscoverable(packet.getTo());
        }
        catch (Exception e) {
            session.sendError(packet, PacketError.MODIFY, "jid-malformed", "missing or malformed recipient");
            return;
        }
        List queryNodes = packet.listElements(NAME_BROWSE);
        StreamElement query = (StreamElement)queryNodes.get(0);
        StreamDataFactory sdf = session.getDataFactory();
        if (packet.getType().equals((Object)InfoQuery.GET)) {
            Log.debug("[Browse] get");
            StreamElement responseQuery = sdf.createElementNode(NAME_BROWSE, null);
            if (dis == null) {
                this.relay(session, packet, null);
                return;
            }
            dis.fillBrowseInfo(packet.getTo(), responseQuery, session);
            if (errorType == null) {
                session.sendResult(packet, responseQuery);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText);
            }
        } else {
            session.sendError(packet, PacketError.CANCEL, "bad-request", "IQ request types are set or get, period.");
        }
    }

    public void addDiscoverable(String key, Discoverable d) {
        if (_discoverables.get(key) == null) {
            _discoverables.put(key, d);
            Log.debug("[Disco] new key: " + key + " new size=" + _discoverables.size());
        } else {
            Log.debug("[Disco] key <" + key + "> already registered.");
        }
    }

    public void removeDiscoverable(String key) {
        _discoverables.remove(key);
        Log.debug("[Disco] key <" + key + "> removed.");
    }

    private Discoverable getDiscoverable(JID jid) {
        Object o = _discoverables.get(jid.toString());
        if (o == null) {
            o = _discoverables.get(jid.toBareJID().toString());
        }
        if (o == null) {
            String key = jid.getDomain();
            int i = key.indexOf(".");
            if (i > 0) {
                key = key.substring(0, i);
            }
            o = _discoverables.get(key);
        }
        if (o == null && !jid.hasNode()) {
            o = this;
        }
        Log.debug("[Disco] " + jid + " = " + o);
        return (Discoverable)o;
    }

    public PacketError.Type fillInfo(DiscoInfoQuery query, JID jid, String node, StreamEndPoint session) {
        query.addIdentity(this.getCategory(), this.getType(), this.getName());
        query.setAttributeValue("jid", session.getJID().getDomain());
        String[] ns = this.getNamespaces(query.getNode());
        for (int i = 0; i < ns.length; ++i) {
            query.addFeature(ns[i]);
        }
        return null;
    }

    public PacketError.Type fillItems(DiscoItemsQuery query, JID jid, String node, StreamEndPoint session) {
        Iterator iter = _discoverables.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String domain = (String)entry.getKey();
            if (domain.indexOf(46) < 0) {
                domain = domain + "." + jid.getDomain();
            }
            Discoverable d = (Discoverable)entry.getValue();
            query.addItem(new JID(domain), null, d.getName());
        }
        iter = S2SSession.getServers().iterator();
        while (iter.hasNext()) {
            String domain = (String)((Object)iter.next());
            query.addItem(new JID(domain), null, this.getName());
        }
        return null;
    }

    public PacketError.Type updateItems(DiscoItemsQuery query, JID jid, StreamEndPoint session) {
        return PacketError.MODIFY;
    }

    public String getName() {
        return "XMPP Server";
    }

    public String getCategory() {
        return "service";
    }

    public String getType() {
        return "jabber";
    }

    public String[] getNamespaces() {
        return this.getNamespaces(null);
    }

    public String[] getNamespaces(String node) {
        if (node != null && node.equals(MessageHandler.AMP_NAMESPACE)) {
            String[] ns = new String[]{MessageHandler.AMP_NAMESPACE + "?condition=deliver", MessageHandler.AMP_NAMESPACE + "?condition=expire-in", MessageHandler.AMP_NAMESPACE + "?condition=expire-at", MessageHandler.AMP_NAMESPACE + "?action=drop", MessageHandler.AMP_NAMESPACE + "?action=error", MessageHandler.AMP_NAMESPACE + "?action=notify", MessageHandler.AMP_NAMESPACE + "?action=alert"};
            return ns;
        }
        String[] ns = new String[]{"jabber:client", "jabber:iq:time", "jabber:iq:version", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/disco#info", "jabber:iq:browse", MessageHandler.AMP_NAMESPACE, MessageHandler.AMP_NAMESPACE + "#std-actions", MessageHandler.AMP_NAMESPACE + "#std-conditions"};
        return ns;
    }

    public PacketError.Type fillAgentInfo(StreamElement agentElement, StreamEndPoint session) {
        return PacketError.MODIFY;
    }

    public PacketError.Type fillBrowseInfo(JID jid, StreamElement query, StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        query.setAttributeValue("category", this.getCategory());
        query.setAttributeValue("type", this.getType());
        query.setAttributeValue("jid", session.getJID().getDomain());
        query.setAttributeValue("name", this.getName());
        String[] ns = this.getNamespaces();
        for (int i = 0; i < ns.length; ++i) {
            StreamElement n = sdf.createElementNode(NSI_NS, null);
            n.addText(ns[i]);
            query.add((StreamNode)n);
        }
        Log.debug("[Disco] enumerating, size=" + _discoverables.size());
        Iterator iter = _discoverables.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String domain = (String)entry.getKey();
            if (domain.indexOf(46) < 0) {
                domain = domain + "." + session.getJID().getDomain();
            }
            Log.debug("[Disco] enumerating, key=" + domain);
            Discoverable d = (Discoverable)entry.getValue();
            StreamElement item = sdf.createElementNode(NSI_ITEM, null);
            item.setAttributeValue("jid", domain);
            if (d.getName() != null) {
                item.setAttributeValue("name", d.getName());
            }
            if (d.getCategory() != null) {
                item.setAttributeValue("category", d.getCategory());
            }
            if (d.getType() != null) {
                item.setAttributeValue("type", d.getType());
            }
            if ((ns = d.getNamespaces()) != null) {
                for (int i = 0; i < ns.length; ++i) {
                    StreamElement n = sdf.createElementNode(NSI_NS, null);
                    n.addText(ns[i]);
                    item.add((StreamNode)n);
                }
            }
            query.add((StreamNode)item);
            Log.debug("[Disco] enumerating, added " + item);
        }
        iter = S2SSession.getServers().iterator();
        while (iter.hasNext()) {
            String domain = (String)((Object)iter.next());
            StreamElement item = sdf.createElementNode(NSI_ITEM, null);
            item.setAttributeValue("name", this.getName());
            item.setAttributeValue("category", this.getCategory());
            item.setAttributeValue("type", this.getType());
            query.add((StreamNode)item);
        }
        return null;
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                tranFactory = monitor.getTransactionFactory("disco");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _discoverables = new Hashtable();
    }
}

