/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.NMSGroup;
import com.sun.im.provider.Realm;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

class DestinationAccessControlList
implements Serializable {
    public static final int NONE = 1;
    public static final int READ = 2;
    public static final int LISTEN = 2;
    public static final int WRITE = 6;
    public static final int SPEAK = 6;
    public static final int VIEW = 6;
    public static final int MANAGE = 14;
    public static final int FULL = 14;
    private Vector v = new Vector();
    private int defaultAccess = 1;

    public void setDefault(int access) {
        this.defaultAccess = access;
    }

    public int getDefault() {
        return this.defaultAccess;
    }

    public Enumeration entries() {
        return new EntryEnum();
    }

    private Entry findEntry(CollaborationPrincipal p) {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            CollaborationPrincipal t = entry.p;
            if (p instanceof LocalUser && t instanceof LocalUser && p.getUID().equals(t.getUID())) {
                return entry;
            }
            if (!(p instanceof NMSGroup) || !(t instanceof NMSGroup) || !p.getUID().equals(t.getUID())) continue;
            return entry;
        }
        return null;
    }

    private Collection getGroups() {
        ArrayList<CollaborationPrincipal> list = new ArrayList<CollaborationPrincipal>();
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            CollaborationPrincipal t = entry.p;
            if (!(t instanceof NMSGroup)) continue;
            list.add(t);
        }
        return list;
    }

    public void add(CollaborationPrincipal p, int access) {
        Entry e = this.findEntry(p);
        if (e == null) {
            this.v.addElement(new Entry(p, access));
        }
    }

    public void remove(CollaborationPrincipal p) {
        Entry e = this.findEntry(p);
        if (e != null) {
            this.v.removeElement(e);
        }
    }

    public void removeAll() {
        this.v.removeAllElements();
    }

    public int getAccess(CollaborationPrincipal p) {
        Entry e = this.findEntry(p);
        if (e == null) {
            return this.defaultAccess;
        }
        return e.access;
    }

    public int getAccess(CollaborationPrincipal p, Realm r) {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            CollaborationPrincipal t = entry.p;
            if (p instanceof LocalUser && t instanceof LocalUser && p.getUID().equals(t.getUID())) {
                return entry.access;
            }
            if (p instanceof NMSGroup && t instanceof NMSGroup && p.getUID().equals(t.getUID())) {
                return entry.access;
            }
            try {
                if (!(p instanceof LocalUser) || !(t instanceof NMSGroup) || !r.isMemberOfGroup(p, (CollaborationGroup)((NMSGroup)t))) continue;
                return entry.access;
            }
            catch (Exception x) {
            }
        }
        return this.defaultAccess;
    }

    class EntryEnum
    implements Enumeration {
        Enumeration e;

        public EntryEnum() {
            Vector tmp = (Vector)DestinationAccessControlList.this.v.clone();
            this.e = tmp.elements();
        }

        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            Entry entry = (Entry)this.e.nextElement();
            return entry.p;
        }
    }

    class Entry
    implements Serializable {
        CollaborationPrincipal p;
        int access;

        Entry(CollaborationPrincipal p, int access) {
            this.p = p;
            this.access = access;
        }
    }
}

