/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BatchByteStreamFilter;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.ByteStreamFilter;
import com.sun.im.provider.MessageConverter;
import com.sun.im.service.util.StringUtility;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ContentFilters {
    private static boolean _filteringEnabled = false;
    private static final String USE_FILTERS = "iim_server.filter.enable";
    private static final String FILTERS = "iim_server.filters";
    static LinkedList _filters = new LinkedList();
    private static boolean _conversionEnabled = false;
    public static final String USE_CONVERSION = "iim_server.conversion";
    public static final String CONVERSION_PROVIDER = "iim_server.conversion.provider";
    static LinkedList _converters = new LinkedList();

    public static boolean enabled() {
        return !_filters.isEmpty();
    }

    public static boolean conversionEnabled() {
        return !_converters.isEmpty();
    }

    public static Iterator iterator() {
        return _filters.iterator();
    }

    public static Iterator conversionIterator() {
        return _converters.iterator();
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        try {
            String name;
            StringTokenizer st;
            String s;
            _filteringEnabled = StringUtility.getBoolean((String)sc.getSetting(USE_FILTERS, "true"));
            if (_filteringEnabled) {
                _filteringEnabled = false;
                Log.debug("[Filter] initializing archive providers");
                s = sc.getSetting(FILTERS);
                if (s != null) {
                    st = new StringTokenizer(s, ",");
                    while (st.hasMoreTokens()) {
                        name = st.nextToken().trim();
                        try {
                            ByteStreamFilter filter = (ByteStreamFilter)Class.forName(name).newInstance();
                            _filters.add(filter);
                            _filteringEnabled = true;
                            Log.info("[Filter] Loaded content filter: " + name);
                        }
                        catch (Exception e) {
                            Log.printStackTrace(e);
                            Log.error("[Filter] Failed to load content filter: " + name);
                        }
                    }
                }
            }
            if (_conversionEnabled = StringUtility.getBoolean((String)sc.getSetting(USE_CONVERSION, "true"))) {
                _conversionEnabled = false;
                Log.debug("[Filter] initializing archive providers");
                s = sc.getSetting(CONVERSION_PROVIDER);
                if (s != null) {
                    st = new StringTokenizer(s, ",");
                    while (st.hasMoreTokens()) {
                        name = st.nextToken().trim();
                        try {
                            MessageConverter converter = (MessageConverter)Class.forName(name).newInstance();
                            _converters.add(converter);
                            _conversionEnabled = true;
                            Log.info("[Filter] Loaded converter: " + name);
                        }
                        catch (Exception e) {
                            Log.printStackTrace(e);
                            Log.error("[Filter] Failed to load converter: " + name);
                        }
                    }
                }
            }
            if (_conversionEnabled) {
                _filters.add(new BatchByteStreamFilter());
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.error("[Filter] Failed initialize filters: " + e.toString());
        }
    }
}

