/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AclException;
import com.iplanet.im.server.BooleanAccessControlList;
import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmManager;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class BooleanAcl {
    static final String ADMINNAME = "sysAdmin";
    static FileUserSettings us = new FileUserSettings();
    static final String TOPICSADDDELNAME = "sysTopicsAdd";
    static final String ROOMSADDDELNAME = "sysRoomsAdd";
    static final String SAVEUSERSETTINGSNAME = "sysSaveUserSettings";
    static final String SENDALERTSNAME = "sysSendAlerts";
    static final String WATCHNAME = "sysWatch";
    static final String USER = "user";
    static final String EXT = ".acl";
    static final String SUBDIR = "acls";

    public static File getFile(String key) {
        String filename = key + EXT;
        File f = new File(NMS.getConfigDir(), SUBDIR);
        return new File(f, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean check(File f, LocalUser u, boolean defaultValue) {
        String line;
        if (!f.exists()) {
            Log.debug("[BooleanAcl] missing acl file: " + f.getAbsolutePath());
            return defaultValue;
        }
        BufferedReader d = null;
        Log.debug("[BooleanAcl] checking access of " + u.getUID() + " based on " + f.getAbsolutePath());
        boolean userAccess = false;
        boolean defaultAccess = true;
        d = new BufferedReader(new FileReader(f));
        while ((line = d.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            StringTokenizer st = new StringTokenizer(line, ":");
            if (st.countTokens() < 2) {
                Log.error("[BooleanAcl] invalid line in acl file: " + f.getAbsolutePath());
                continue;
            }
            String type = st.nextToken();
            type = type.trim();
            String value = st.nextToken();
            value = value.trim();
            if (type.equals("u")) {
                value = StringUtility.appendDomainToAddress((String)value, (String)NMS.getName());
                if (userAccess) continue;
                String bareUid = StringUtility.removeResource((String)u.getUID());
                userAccess = bareUid.equalsIgnoreCase(value);
                continue;
            }
            if (type.equals("g")) {
                String group = StringUtility.getLocalPartFromAddress((String)value);
                String server = StringUtility.getDomainFromAddress((String)value, (String)NMS.getName());
                NMSGroup nmsg = null;
                try {
                    nmsg = RealmManager.getGroup(u, group);
                    if (userAccess) continue;
                    userAccess = nmsg != null && nmsg.hasMember(u);
                }
                catch (RealmException e) {}
                continue;
            }
            if (type.equals("d")) {
                defaultAccess = value.equalsIgnoreCase("true");
                continue;
            }
            Log.warning("[BooleanAcl] invalid line in acl file: " + f);
        }
        boolean bl = userAccess || defaultAccess;
        Object var15_16 = null;
        try {
            if (d != null) {
                d.close();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                Log.warning("[BooleanAcl] check(" + f.toString() + "," + u.getUID() + ") failed: " + e.toString());
                Log.printStackTrace(e);
                Object var15_17 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    if (d != null) {
                        d.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (d != null) {
                    d.close();
                }
            }
            catch (Exception e2) {}
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static BooleanAccessControlList get(File f) throws AclException {
        BooleanAccessControlList booleanAccessControlList;
        if (!f.exists()) {
            Log.debug("[BooleanAcl] missing acl file: " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            try {
                String line;
                Log.debug("Getting acl file: " + f.getAbsolutePath());
                BooleanAccessControlList ret = new BooleanAccessControlList();
                d = new BufferedReader(new FileReader(f));
                while ((line = d.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    StringTokenizer st = new StringTokenizer(line, ":");
                    if (st.countTokens() < 2) {
                        Log.error("[BooleanAcl] invalid line in acl file: " + f.getAbsolutePath());
                        continue;
                    }
                    String type = st.nextToken();
                    type = type.trim();
                    String value = st.nextToken();
                    value = value.trim();
                    if (type.equals("u")) {
                        String server = StringUtility.getDomainFromAddress((String)(value = StringUtility.appendDomainToAddress((String)value, (String)NMS.getName())), (String)NMS.getName());
                        if (server.equalsIgnoreCase(NMS.getName())) {
                            try {
                                LocalUser nmsUser = RealmManager.getUser(value);
                                if (nmsUser == null) continue;
                                ret.add(nmsUser);
                            }
                            catch (RealmException re) {
                                Log.warning("[BooleanAcl] user not found: " + (Object)((Object)re));
                            }
                            continue;
                        }
                        String[] remoteuids = new String[]{value};
                        continue;
                    }
                    if (type.equals("g")) {
                        String group = StringUtility.getLocalPartFromAddress((String)value);
                        String server = StringUtility.getDomainFromAddress((String)group, (String)NMS.getName());
                        NMSGroup nmsg = null;
                        try {
                            nmsg = RealmManager.getGroup(null, group);
                        }
                        catch (RealmException e) {
                            Log.warning("Invalid group " + value + " in acl : " + f.getName());
                        }
                        if (nmsg != null) {
                            ret.add(nmsg);
                            continue;
                        }
                        ret.add(new NMSGroup(group, server, group));
                        continue;
                    }
                    if (!type.equals("d")) continue;
                    ret.setDefault(value.equalsIgnoreCase("true"));
                }
                booleanAccessControlList = ret;
                Object var12_14 = null;
            }
            catch (Exception e) {
                Log.error("[BooleanAcl] get(" + f.getAbsolutePath() + ") failed : " + e.toString());
                Log.printStackTrace(e);
                BooleanAccessControlList booleanAccessControlList2 = null;
                Object var12_15 = null;
                try {
                    if (d == null) return booleanAccessControlList2;
                    d.close();
                    return booleanAccessControlList2;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return booleanAccessControlList2;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {}
            catch (Exception e2) {
                throw throwable;
            }
            if (d == null) throw throwable;
            d.close();
            throw throwable;
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return booleanAccessControlList;
        }
        if (d == null) return booleanAccessControlList;
        d.close();
        return booleanAccessControlList;
    }

    protected static void set(File f, BooleanAccessControlList l) throws IOException {
        PrintWriter d = null;
        try {
            File tempfile = PlatformUtil.getTempFile((File)f);
            d = new PrintWriter(new BufferedWriter(new FileWriter(tempfile)));
            Enumeration e = l.entries();
            while (e.hasMoreElements()) {
                IMPrincipal p = (IMPrincipal)e.nextElement();
                String uid = NMS.getName().equalsIgnoreCase(p.getDomainName()) ? p.getName() : p.getUID();
                if (p instanceof LocalUser) {
                    d.println("u:" + uid);
                    continue;
                }
                if (!(p instanceof NMSGroup)) continue;
                d.println("g:" + uid);
            }
            d.println("d:" + l.getDefault());
            d.close();
            d = null;
            if (!PlatformUtil.renameTempFile((File)tempfile, (File)f)) {
                Log.error("Renaming the file from " + tempfile.getAbsolutePath() + " to " + f.getAbsolutePath() + " failed");
            }
        }
        catch (IOException e) {
            Log.error("[BooleanAcl] write error: " + e);
            if (d != null) {
                d.close();
            }
            throw e;
        }
    }

    static boolean checkAdmin(LocalUser u) {
        return BooleanAcl.check(BooleanAcl.getFile(ADMINNAME), u, false);
    }

    static BooleanAccessControlList getAdmin(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(ADMINNAME));
    }

    static void setAdmin(BooleanAccessControlList a, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(ADMINNAME), a);
    }

    static boolean checkTopicsAddDel(LocalUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(TOPICSADDDELNAME), u, false);
    }

    static BooleanAccessControlList getTopicsAddDel(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(TOPICSADDDELNAME));
    }

    static void setTopicsAddDel(BooleanAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(TOPICSADDDELNAME), l);
    }

    static boolean checkRoomsAddDel(LocalUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(ROOMSADDDELNAME), u, true);
    }

    static BooleanAccessControlList getRoomsAddDel(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(ROOMSADDDELNAME));
    }

    static void setRoomsAddDel(BooleanAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(ROOMSADDDELNAME), l);
    }

    static boolean checkSaveUserSettings(LocalUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(SAVEUSERSETTINGSNAME), u, true);
    }

    static BooleanAccessControlList getSaveUserSettings(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(SAVEUSERSETTINGSNAME));
    }

    static void setSaveUserSettings(BooleanAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(SAVEUSERSETTINGSNAME), l);
    }

    static boolean checkWatch(LocalUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(WATCHNAME), u, true);
    }

    static BooleanAccessControlList getWatch(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(WATCHNAME));
    }

    static void setWatch(BooleanAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(WATCHNAME), l);
    }

    static boolean checkSendAlerts(LocalUser u) {
        if (BooleanAcl.checkAdmin(u)) {
            return true;
        }
        return BooleanAcl.check(BooleanAcl.getFile(SENDALERTSNAME), u, true);
    }

    static BooleanAccessControlList getSendAlerts(LocalUser u) throws AclException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        return BooleanAcl.get(BooleanAcl.getFile(SENDALERTSNAME));
    }

    static void setSendAlerts(BooleanAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!BooleanAcl.checkAdmin(u)) {
            throw new AclException("[BooleanAcl] access denied");
        }
        BooleanAcl.set(BooleanAcl.getFile(SENDALERTSNAME), l);
    }
}

