/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.core.BindQuery;

public class BindHandler
extends AbstractHandler {
    public void process(StreamEndPoint sep, Packet packet) {
        ClientSession session = (ClientSession)sep;
        String errorText = null;
        String errorCondition = "forbidden";
        Log.debug("[Bind] new packet");
        StreamDataFactory sdf = session.getDataFactory();
        BindQuery bq = (BindQuery)packet.listExtensions("urn:ietf:params:xml:ns:xmpp-bind").get(0);
        if (packet.getType().equals((Object)InfoQuery.SET)) {
            if (!session.authenticated()) {
                Log.debug("[Bind] not yet authenticated");
                errorText = "Not yet authenticated.  No bind allowed.";
                session.sendError(packet, PacketError.AUTH, "unexpected-request", errorText);
            } else {
                BaseUser u = session.getUser();
                String newRes = bq.getResource();
                Log.debug("[Bind] new resource " + newRes);
                JID newJID = new JID(u.getJID() + "/" + newRes);
                session.setJID(newJID);
                u.addSession(session);
                BindQuery qn = (BindQuery)bq.copy();
                qn.clearElements();
                qn.setJID(newJID);
                session.sendResult(packet, (StreamElement)qn);
            }
        } else {
            Log.debug("[Bind] unsupported request: type=" + packet.getType());
            session.sendError(packet, PacketError.MODIFY, "bad-request", "[Bind] unsupported request: type=" + packet.getType());
        }
    }
}

