/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ContentFilters;
import com.iplanet.im.server.EndPoint;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.XMPPByteStream;
import com.iplanet.im.server.XMPPByteStreamBlock;
import com.sun.im.provider.ByteStream;
import com.sun.im.provider.ByteStreamBlock;
import com.sun.im.provider.ByteStreamFilter;
import com.sun.im.provider.MessageConverter;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.util.ByteCodec;

public class BatchByteStreamFilter
extends ByteStreamFilter {
    static File _tmpDir;
    static ByteCodec.Base64Codec base64;
    private static IBBHandler ibbHandler;
    private Hashtable _batches = new Hashtable();

    public void processData(ByteStream stream, ByteStreamBlock block) {
        block3: {
            Batch batch = (Batch)this._batches.get(stream.getID());
            try {
                if (batch != null) {
                    batch.append(block);
                    batch.setPacket(((XMPPByteStreamBlock)block).getPacket());
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                if (batch == null) break block3;
                batch.delete();
                this._batches.remove(stream.getID());
            }
        }
    }

    public void openStream(String from, String to, ByteStream stream) {
        try {
            Batch batch = new Batch(stream);
            this._batches.put(stream.getID(), batch);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void closeStream(ByteStream stream) {
        block6: {
            Batch batch = (Batch)this._batches.remove(stream.getID());
            try {
                if (batch != null) {
                    MessageImpl mp = new MessageImpl(batch);
                    Iterator i = ContentFilters.conversionIterator();
                    while (i.hasNext()) {
                        try {
                            ((MessageConverter)i.next()).convert((Message)mp);
                        }
                        catch (Exception e) {
                            Log.printStackTrace(e);
                        }
                    }
                    this.processConvertedMessage(batch, mp.getInputStream());
                    batch.delete();
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                if (batch == null) break block6;
                batch.delete();
            }
        }
    }

    private void processConvertedMessage(Batch batch, InputStream is) {
        int IBB_MESSAGE_SIZE = 4096;
        XMPPByteStream s = batch.getStream();
        try {
            IBB_MESSAGE_SIZE = Integer.parseInt(s.getOpenElement().getAttributeValue("block-size"));
        }
        catch (Exception e) {
            IBB_MESSAGE_SIZE = 4096;
        }
        StringBuffer buf = new StringBuffer();
        byte[] b = new byte[1023];
        int i = 0;
        int len = 0;
        while (len != -1) {
            try {
                len = is.read(b);
            }
            catch (IOException e) {
                Log.printStackTrace(e);
                len = -1;
            }
            int maxsize = IBB_MESSAGE_SIZE;
            if (len == -1) {
                maxsize = buf.length();
                if (maxsize == 0) {
                    break;
                }
            } else {
                buf.append(base64.encode(b, 0, len));
            }
            if (buf.length() < maxsize) continue;
            Packet p = (Packet)batch.getPacket().copy();
            StreamElement data = p.getFirstElement(IBBHandler.DATA_NAME);
            if (data == null) break;
            data.setAttributeValue("seq", Integer.toString(i++));
            data.clearText();
            data.addText(buf.substring(0, maxsize));
            buf.replace(0, maxsize, "");
            p.setID(EndPoint.getUniqueID("message"));
            ibbHandler.sendMessage(s.getSession(), p);
        }
        ibbHandler.sendIQ(s.getSession(), s.getClosePacket());
    }

    static {
        String dirname = NMS.getInstanceVarDir() + File.separator + "tmp";
        _tmpDir = new File(dirname);
        _tmpDir.mkdirs();
        base64 = new ByteCodec.Base64Codec();
        ibbHandler = NMS.get().getClientPacketDispatcher().getIBBHandler();
    }

    class MessageImpl
    implements Message {
        Batch _batch;
        InputStream _modified;

        MessageImpl(Batch batch) throws IOException {
            this._batch = batch;
            this._modified = this._batch.getInputStream();
        }

        public int getSize() {
            return (int)this._batch.size();
        }

        public String getContentID() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public String getContentName() {
            return this._batch.getStream().getName();
        }

        public InputStream getInputStream() throws CollaborationException {
            return this._modified;
        }

        public String getContent() throws CollaborationException {
            throw new CollaborationException("binary content - use getInputStream");
        }

        public String getContent(String contentType) throws CollaborationException {
            throw new CollaborationException("binary content - use getInputStream");
        }

        public byte[] getBytes(String encoding) throws CollaborationException {
            try {
                File f = File.createTempFile("bbsf", null, _tmpDir);
                f.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(f);
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = this._modified.read(b)) != -1) {
                    if (fos == null) continue;
                    fos.write(b, 0, len);
                }
                fos.close();
                byte[] ret = new byte[(int)f.length()];
                FileInputStream stream = new FileInputStream(f);
                stream.read(ret);
                stream.close();
                return ret;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public void setContent(byte[] content, String enc) throws CollaborationException {
            this._modified = new ByteArrayInputStream(content);
        }

        public void setContent(InputStream is, String enc) throws CollaborationException {
            this._modified = is;
        }

        public void setContent(String content) throws CollaborationException {
            throw new CollaborationException("binary content - use setContent(byte[]) or  setContent(InputStream)");
        }

        public void setContent(String content, String contentType) throws CollaborationException {
            throw new CollaborationException("binary content - use setContent(byte[]) or  setContent(InputStream)");
        }

        public void clearContent() throws CollaborationException {
            try {
                this._modified.skip(this._modified.available());
            }
            catch (IOException ioe) {
                throw new CollaborationException(ioe.toString());
            }
        }

        public void setContentType(String contentType) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void setContentName(String name) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void addPart(MessagePart part) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void addRecipient(String destination) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public Date getExpirationDate() {
            return null;
        }

        public String getHeader(String header) {
            return null;
        }

        public String getMessageId() {
            return null;
        }

        public String getOriginator() {
            return this._batch.getPacket().getFrom().toString();
        }

        public MessagePart[] getParts() {
            return new MessagePart[]{this};
        }

        public String[] getRecipients() throws CollaborationException {
            return new String[]{this._batch.getPacket().getTo().toString()};
        }

        public MessagePart newPart() throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void removePart(MessagePart part) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void removeRecipient(String destination) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void sendReply(Message message) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void sendStatus(int status) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void setExpirationDate(Date expireAt) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }

        public void setHeader(String header, String value) throws CollaborationException {
        }

        public void setOriginator(String originator) throws CollaborationException {
            throw new CollaborationException("Not Supported");
        }
    }

    class Batch {
        FileOutputStream fos;
        File f = File.createTempFile("bbsf", null, _tmpDir);
        Packet packet;
        XMPPByteStream stream;

        Batch(ByteStream stream) throws IOException {
            this.f.deleteOnExit();
            this.fos = new FileOutputStream(this.f);
            this.stream = (XMPPByteStream)stream;
        }

        long size() {
            return this.f.length();
        }

        void append(ByteStreamBlock block) throws IOException {
            byte[] b = block.getBytes();
            if (this.fos != null) {
                this.fos.write(b, 0, b.length);
            }
        }

        InputStream getInputStream() throws IOException {
            if (this.fos != null) {
                this.fos.close();
                this.fos = null;
            }
            return new FileInputStream(this.f);
        }

        void delete() {
            try {
                if (this.fos != null) {
                    this.fos.close();
                }
                this.f.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void setPacket(Packet p) {
            if (this.packet == null) {
                this.packet = p;
            }
        }

        Packet getPacket() {
            return this.packet;
        }

        XMPPByteStream getStream() {
            return this.stream;
        }
    }
}

