/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.core.AuthQuery;

public class AuthHandler
extends AbstractHandler {
    static MonitorTransactionFactory tranFactory = null;

    public void process(StreamEndPoint sep, Packet packet) {
        ClientSession session = (ClientSession)sep;
        if (session.isSASLAuthenticating()) {
            Log.debug("[ClientPacketDispatcher] skipped authHandler - auth in progress");
            return;
        }
        String errorText = null;
        String errorCondition = "forbidden";
        Log.debug("[Auth] new packet");
        StreamDataFactory sdf = session.getDataFactory();
        AuthQuery aq = (AuthQuery)packet.listExtensions("jabber:iq:auth").get(0);
        if (packet.getType().equals((Object)InfoQuery.SET)) {
            LocalUser u;
            MonitorTransaction transaction;
            block15: {
                transaction = null;
                if (tranFactory != null) {
                    transaction = tranFactory.startTransaction();
                }
                Log.debug("[Auth] new auth request");
                if (session.isSASLAuthenticating()) {
                    Log.debug("[Auth] returning, already doing SASL");
                    return;
                }
                session.setAuthenticating(true);
                u = null;
                if (aq != null) {
                    String uid = aq.getUsername();
                    String password = aq.getField("password");
                    String digest = aq.getField("digest");
                    try {
                        if (password != null) {
                            u = RealmManager.auth(uid, password);
                        }
                        if (u == null && digest != null) {
                            u = RealmManager.digestAuth(uid, NMS.getName(), digest, session.getStream().getOutboundContext().getID());
                        }
                        if (u == null) break block15;
                        if (session.isSASLAuthenticating()) {
                            session.setAuthenticating(false);
                            errorCondition = "unexpected-request";
                            errorText = "Ongoing SASL negotiation";
                            break block15;
                        }
                        session.setJID(new JID(u.getName(), u.getDomainName(), aq.getResource()));
                        session.setUser(u);
                        ((BaseUser)u).addSession(session);
                    }
                    catch (Exception e) {
                        u = null;
                        errorText = e.getMessage();
                        Log.printStackTrace(e);
                    }
                } else {
                    errorCondition = "bad-request";
                    errorText = "missing query element";
                }
            }
            session.setAuthenticating(false);
            if (u != null) {
                session.sendResult(packet, transaction);
            } else {
                session.sendError(packet, PacketError.AUTH, errorCondition, errorText, transaction);
            }
        } else if (packet.getType().equals((Object)InfoQuery.GET)) {
            Log.debug("[Auth] getting features");
            aq.setPassword(null);
            aq.setResource(null);
            session.sendResult(packet, (StreamElement)aq);
        }
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                tranFactory = monitor.getTransactionFactory("auth");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

