/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusy;
import com.sun.comclient.calendar.PropertiesException;

public class VFreeBusy
extends CalendarComponent {
    public static final String FREEBUSY = "FREEBUSY";
    public static final String DTEND = "DTEND";
    private boolean hasDuration = false;
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public VFreeBusy(DateTime dateTime, DateTime dateTime2, FreeBusy[] freeBusyArray) throws IllegalArgumentException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setProperty(DTEND, dateTime2);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = false;
        this.removeProperty("DURATION");
    }

    public VFreeBusy(DateTime dateTime, Duration duration, FreeBusy[] freeBusyArray) throws IllegalArgumentException, PropertiesException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setDuration(duration);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = true;
        this.removeProperty(DTEND);
    }

    public VFreeBusy(VFreeBusy vFreeBusy) throws IllegalArgumentException, PropertiesException {
        FreeBusy[] freeBusyArray;
        FreeBusy[] freeBusyArray2;
        if (null == vFreeBusy) {
            throw new IllegalArgumentException("input given for \"vfreebusy\" argument was found to be null");
        }
        this.setStart((DateTime)vFreeBusy.getStart().clone());
        this.hasDuration = vFreeBusy.hasDuration();
        if (this.hasDuration) {
            freeBusyArray2 = vFreeBusy.getDuration();
            freeBusyArray = new Duration(freeBusyArray2.toRFC2445());
            this.setDuration((Duration)freeBusyArray);
            this.removeProperty(DTEND);
        } else {
            this.setProperty(DTEND, vFreeBusy.getEnd().clone());
            this.removeProperty("DURATION");
        }
        freeBusyArray2 = vFreeBusy.getFreeBusy();
        freeBusyArray = new FreeBusy[freeBusyArray2.length];
        for (int i = 0; i < freeBusyArray2.length; ++i) {
            freeBusyArray[i] = (FreeBusy)freeBusyArray2[i].clone();
        }
        this.setProperty(FREEBUSY, freeBusyArray);
    }

    public Object clone() {
        try {
            return new VFreeBusy(this);
        }
        catch (PropertiesException propertiesException) {
            return null;
        }
    }

    private String calendarComponentToRFC2445() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Attendee[] attendeeArray;
        String string = new String("");
        if (null != this.getID()) {
            string = string + "\nUID:" + this.getID();
        }
        if (null != this.getUrl()) {
            string = string + "\nURL:" + this.getUrl();
        }
        if (null != this.getStamp()) {
            string = string + "\nDTSTAMP:" + this.getStamp().toISOString();
        }
        if (null != this.getOrganizer()) {
            string = string + "\n" + this.getOrganizer().toRFC2445();
        }
        if (null != (attendeeArray = this.getAttendees())) {
            for (int i = 0; i < attendeeArray.length; ++i) {
                string = string + "\n" + attendeeArray[i].toRFC2445();
            }
        }
        if (null != (stringArray3 = this.getComments())) {
            for (int i = 0; i < stringArray3.length; ++i) {
                string = string + "\nCOMMENT:" + stringArray3[i];
            }
        }
        if (null != (stringArray2 = this.getContacts())) {
            for (int i = 0; i < stringArray2.length; ++i) {
                string = string + "\nCONTACT:" + stringArray2[i];
            }
        }
        if (null != (stringArray = this.getRequestStatus())) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "\nRSTATUS:" + stringArray[i];
            }
        }
        return string;
    }

    private String freeBusyToRFC2445(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        for (int i = 0; i < freeBusyArray.length; ++i) {
            string = string + "\n" + freeBusyArray[i].toRFC2445();
        }
        return string;
    }

    private String freeBusyToString(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        for (int i = 0; i < freeBusyArray.length; ++i) {
            string = string + ";\n" + freeBusyArray[i].toString();
        }
        return string;
    }

    public String toRFC2445() {
        return "BEGIN:VFREEBUSY\nDTSTART:" + this.getStart().toISOString() + (this.hasDuration() ? "\n" + this.getDuration().toRFC2445() : "\nDTEND:" + this.getEnd().toISOString()) + this.freeBusyToRFC2445(this.getFreeBusy()) + this.calendarComponentToRFC2445() + "\nEND:VFREEBUSY";
    }

    public String toString() {
        return "VFreeBusy[start=" + this.getStart().toISOString() + "; hasDuration=" + this.hasDuration() + "; end=" + (null == this.getEnd() ? null : this.getEnd().toISOString()) + "; duration=" + (null == this.getDuration() ? null : this.getDuration().toRFC2445().substring(rfcDurationPrefixLength)) + this.freeBusyToString(this.getFreeBusy()) + ";\n" + super.toString() + "\n]";
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty(DTEND);
    }

    public FreeBusy[] getFreeBusy() {
        return (FreeBusy[])this.getProperty(FREEBUSY);
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }
}

