/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.SchedulingComponent;
import com.sun.comclient.calendar.VAlarm;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class VEvent
extends CalendarComponent
implements SchedulingComponent {
    private boolean allDay = false;
    public static final String DTEND = "DTEND";
    public static final String TRANSP = "TRANSP";
    private static final Hashtable _statusValues = new Hashtable();
    private static final Hashtable _classificationValues = new Hashtable();
    public static final String STATUS_TENTATIVE = "TENTATIVE";
    public static final String STATUS_CONFIRMED = "CONFIRMED";
    public static final String STATUS_CANCELLED = "CANCELLED";

    public VEvent() {
    }

    public VEvent(DateTime dateTime, DateTime dateTime2) {
        super(dateTime);
        try {
            this.setEndTime(dateTime2);
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
    }

    public VEvent(DateTime dateTime, DateTime dateTime2, String string) {
        this(dateTime, dateTime2);
        this.setSummary(string);
    }

    public VEvent(DateTime dateTime, String string) {
        this.setStartTime(dateTime);
        this.setSummary(string);
        this.setAllDay(true);
    }

    public VEvent(String string, DateTime dateTime, DateTime dateTime2, String string2, String string3) {
        this(dateTime, dateTime2, string2);
        this.setID(string);
        this.setDescription(string3);
    }

    public VEvent(DateTime dateTime, DateTime dateTime2, String string, String string2) {
        this(dateTime, dateTime2, string);
        this.setDescription(string2);
    }

    private String[] _split(String string, char c, int n) {
        String[] stringArray = new String[n];
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            if (n4 >= n - 1) break;
            stringArray[n4] = string.substring(n3, i);
            n3 = i + 1;
            ++n4;
        }
        if (n4 < n) {
            stringArray[n4] = string.substring(n3, n2);
        }
        return stringArray;
    }

    public void handleMultilineProperty(String string, String string2) throws PropertiesException {
        if (string.equals("ORGANIZER")) {
            this.setOrganizer(new Organizer(string2));
        } else if (string.equals("ATTENDEE")) {
            this.addAttendee(new Attendee(string2));
        } else if (string.equals("DESCRIPTION")) {
            this.setDescription(string2);
        } else if (string.equals("COMMENT")) {
            this.addComment(string2);
        } else if (string.equals("SUMMARY")) {
            this.setSummary(string2);
        }
    }

    public VEvent(String string) throws IllegalArgumentException, PropertiesException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            StreamTokenizer streamTokenizer = null;
            String string2 = bufferedReader.readLine();
            streamTokenizer = new StreamTokenizer(new StringReader(string2));
            if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("BEGIN")) {
                throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
            }
            if ((char)streamTokenizer.nextToken() != ':') {
                throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
            }
            if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("VEVENT")) {
                throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
            }
            String string3 = null;
            StringBuffer stringBuffer = null;
            while (!(string2 = bufferedReader.readLine()).equalsIgnoreCase("END:VEVENT")) {
                Object object;
                if (Character.isWhitespace(string2.charAt(0))) {
                    if (stringBuffer == null) continue;
                    stringBuffer.append(string2.trim());
                    continue;
                }
                if (string3 != null && stringBuffer != null) {
                    this.handleMultilineProperty(string3, stringBuffer.toString());
                    stringBuffer = null;
                }
                streamTokenizer = new StreamTokenizer(new StringReader(string2));
                streamTokenizer.nextToken();
                string3 = streamTokenizer.sval.toUpperCase();
                String[] stringArray = this._split(string2, ':', 2);
                if (stringArray.length != 2) {
                    throw new IllegalArgumentException("Invalid VEVENT format(check " + string3 + "tag)");
                }
                if (string3.equals("UID")) {
                    this.setID(stringArray[1]);
                    continue;
                }
                if (string3.equals("DTSTART")) {
                    this.setStartTime(new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("SUMMARY")) {
                    stringBuffer = new StringBuffer(stringArray[1]);
                    continue;
                }
                if (string3.equals(DTEND)) {
                    this.setEndTime(new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("DURATION")) {
                    this.setDuration(new Duration(stringArray[1]));
                    continue;
                }
                if (string3.equals("DESCRIPTION")) {
                    stringBuffer = new StringBuffer(stringArray[1]);
                    continue;
                }
                if (string3.equals("LOCATION")) {
                    this.setLocation(stringArray[1]);
                    continue;
                }
                if (string3.equals("CLASS")) {
                    this.setClassification(stringArray[1]);
                    continue;
                }
                if (string3.equals("DTSTAMP")) {
                    this.setStamp(new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("SEQUENCE")) {
                    this.setSequence(Integer.parseInt(stringArray[1]));
                    continue;
                }
                if (string3.equals("PRIORITY")) {
                    this.setPriority(Integer.parseInt(stringArray[1]));
                    continue;
                }
                if (string3.equals("RECURRENCE-ID")) {
                    this.setProperty("RECURRENCE-ID", new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals(TRANSP)) {
                    this.setProperty(TRANSP, stringArray[1]);
                    continue;
                }
                if (string3.equals("ORGANIZER")) {
                    stringBuffer = new StringBuffer(string2);
                    continue;
                }
                if (string3.equals("ATTENDEE")) {
                    stringBuffer = new StringBuffer(string2);
                    continue;
                }
                if (string3.equals("EXDATE")) {
                    this.addExceptionDate(new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("EXRULE")) {
                    object = new RecurrencePattern(stringArray[1]);
                    this.addExceptionRule((RecurrencePattern)object);
                    continue;
                }
                if (string3.equals("RDATE")) {
                    this.addRecurrenceDate(new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("RRULE")) {
                    object = new RecurrencePattern(stringArray[1]);
                    this.addRecurrenceRule((RecurrencePattern)object);
                    continue;
                }
                if (string3.equals("STATUS")) {
                    this.setStatus(stringArray[1]);
                    continue;
                }
                if (string3.equals("GEO")) {
                    this.setGeo(stringArray[1]);
                    continue;
                }
                if (string3.equals("CREATED")) {
                    this.setProperty("CREATED", new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("LAST-MODIFIED")) {
                    this.setProperty("LAST-MODIFIED", new DateTime(stringArray[1]));
                    continue;
                }
                if (string3.equals("ATTACH")) {
                    object = new Attach("RFC", string2);
                    this.addAttachment((Attach)object);
                    continue;
                }
                if (string3.equals("COMMENT")) {
                    stringBuffer = new StringBuffer(stringArray[1]);
                    continue;
                }
                if (string3.equals("CATEGORIES")) {
                    this.addCategory(stringArray[1]);
                    continue;
                }
                if (string3.equals("CONTACT")) {
                    this.addContact(stringArray[1]);
                    continue;
                }
                if (string3.equals("REQUEST-STATUS")) {
                    this.addRequestStatus(stringArray[1]);
                    continue;
                }
                if (string3.equals("RELATED-TO")) {
                    this.addRelatedTo(stringArray[1]);
                    continue;
                }
                if (string3.equals("RESOURCES")) {
                    this.addResource(stringArray[1]);
                    continue;
                }
                if (!string2.equals("BEGIN:VALARM")) continue;
                object = new StringBuffer("BEGIN:VALARM\n");
                while (!(string2 = bufferedReader.readLine()).equals("END:VALARM")) {
                    ((StringBuffer)object).append(string2 + "\n");
                }
                ((StringBuffer)object).append("END:VALARM");
                VAlarm vAlarm = new VAlarm(this, ((StringBuffer)object).toString());
                this.addAlarmComponent(vAlarm);
            }
            if (string3 != null && stringBuffer != null) {
                this.handleMultilineProperty(string3, stringBuffer.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (PropertiesException propertiesException) {
            throw propertiesException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VEvent(VEvent vEvent) throws IllegalArgumentException, PropertiesException {
        this(vEvent.toRFC2445());
        this.setAllDay(vEvent.isAllDay());
    }

    public DateTime getStartTime() {
        return this.getStart();
    }

    public void setStartTime(DateTime dateTime) {
        this.setStart(dateTime);
    }

    public DateTime getEndTime() {
        return (DateTime)this.getProperty(DTEND);
    }

    public void setEndTime(DateTime dateTime) throws PropertiesException {
        if (this.hasProperty("DURATION")) {
            PropertiesException propertiesException = new PropertiesException(1);
            throw propertiesException;
        }
        this.setProperty(DTEND, dateTime);
    }

    public void setDuration(Duration duration) throws PropertiesException {
        if (this.hasProperty(DTEND)) {
            PropertiesException propertiesException = new PropertiesException(1);
            throw propertiesException;
        }
        this.setProperty("DURATION", duration);
    }

    public VAlarm[] getAlarmComponents() {
        ArrayList arrayList = (ArrayList)this.getProperty("ALARM");
        if (arrayList == null) {
            return null;
        }
        VAlarm[] vAlarmArray = new VAlarm[arrayList.size()];
        return arrayList.toArray(vAlarmArray);
    }

    public void addAlarmComponent(VAlarm vAlarm) {
        ArrayList<VAlarm> arrayList = (ArrayList<VAlarm>)this.getProperty("ALARM");
        if (null == arrayList) {
            arrayList = new ArrayList<VAlarm>();
            arrayList.add(vAlarm);
            this.setProperty("ALARM", arrayList);
        } else {
            arrayList.add(vAlarm);
        }
    }

    public void removeAlarmComponent(VAlarm vAlarm) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("ALARM");
        if (null != arrayList && -1 != (n = arrayList.indexOf(vAlarm))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("ALARM");
            }
        }
    }

    public void removeAllAlarmComponents() {
        this.removeProperty("ALARM");
    }

    public Attach[] getAttachments() {
        ArrayList arrayList = (ArrayList)this.getProperty("ATTACH");
        if (arrayList == null) {
            return null;
        }
        Attach[] attachArray = new Attach[arrayList.size()];
        return arrayList.toArray(attachArray);
    }

    public void addAttachment(Attach attach) {
        ArrayList<Attach> arrayList = (ArrayList<Attach>)this.getProperty("ATTACH");
        if (null == arrayList) {
            arrayList = new ArrayList<Attach>();
            arrayList.add(attach);
            this.setProperty("ATTACH", arrayList);
        } else {
            arrayList.add(attach);
        }
    }

    public void removeAttachment(Attach attach) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("ATTACH");
        if (null != arrayList && -1 != (n = arrayList.indexOf(attach))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("ATTACH");
            }
        }
    }

    public void removeAllAttachments() {
        this.removeProperty("ATTACH");
    }

    public String[] getCategories() {
        ArrayList arrayList = (ArrayList)this.getProperty("CATEGORIES");
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addCategory(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty("CATEGORIES");
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty("CATEGORIES", arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeCategory(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("CATEGORIES");
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("CATEGORIES");
            }
        }
    }

    public void removeAllCategories() {
        this.removeProperty("CATEGORIES");
    }

    public String getClassification() {
        return (String)this.getProperty("CLASS");
    }

    public void setClassification(String string) throws PropertiesException {
        if (!string.toUpperCase().startsWith("X") && _classificationValues.get(string.toUpperCase()) == null) {
            PropertiesException propertiesException = new PropertiesException(2);
            throw propertiesException;
        }
        this.setProperty("CLASS", string.toUpperCase());
    }

    public DateTime getCreated() {
        return (DateTime)this.getProperty("CREATED");
    }

    public String getDescription() {
        return (String)this.getProperty("DESCRIPTION");
    }

    public void setDescription(String string) {
        this.setProperty("DESCRIPTION", string);
    }

    public DateTime getLastModified() {
        return (DateTime)this.getProperty("LAST-MODIFIED");
    }

    public void setLastModified(DateTime dateTime) {
        this.setProperty("LAST-MODIFIED", dateTime);
    }

    public String getLocation() {
        return (String)this.getProperty("LOCATION");
    }

    public void setLocation(String string) {
        this.setProperty("LOCATION", string);
    }

    public String getGeo() {
        return (String)this.getProperty("GEO");
    }

    public void setGeo(String string) throws PropertiesException {
        int n = string.indexOf(";");
        if (n == -1) {
            PropertiesException propertiesException = new PropertiesException(2);
            throw propertiesException;
        }
        try {
            Float f = new Float(string.substring(0, n));
            Float f2 = new Float(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            PropertiesException propertiesException = new PropertiesException(2);
            throw propertiesException;
        }
        this.setProperty("GEO", string);
    }

    public int getPriority() {
        Integer n = (Integer)this.getProperty("PRIORITY");
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setPriority(int n) throws PropertiesException {
        if (n > 9 || n < 0) {
            PropertiesException propertiesException = new PropertiesException(2);
            throw propertiesException;
        }
        this.setProperty("PRIORITY", new Integer(n));
    }

    public DateTime getRecurrenceID() {
        return (DateTime)this.getProperty("RECURRENCE-ID");
    }

    public String[] getRelatedTos() {
        ArrayList arrayList = (ArrayList)this.getProperty("RELATED-TO");
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addRelatedTo(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty("RELATED-TO");
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty("RELATED-TO", arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeRelatedTo(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("RELATED-TO");
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("RELATED-TO");
            }
        }
    }

    public void removeAllRelatedTos() {
        this.removeProperty("RELATED-TO");
    }

    public String[] getResources() {
        ArrayList arrayList = (ArrayList)this.getProperty("RESOURCES");
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addResource(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty("RESOURCES");
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty("RESOURCES", arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeResource(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("RESOURCES");
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("RESOURCES");
            }
        }
    }

    public void removeAllResources() {
        this.removeProperty("RESOURCES");
    }

    public int getSequence() {
        Integer n = (Integer)this.getProperty("SEQUENCE");
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setSequence(int n) {
        this.setProperty("SEQUENCE", new Integer(n));
    }

    public String getStatus() {
        return (String)this.getProperty("STATUS");
    }

    public void setStatus(String string) throws PropertiesException {
        if (_statusValues.get(string.toUpperCase()) != null) {
            this.setProperty("STATUS", string.toUpperCase());
            return;
        }
        PropertiesException propertiesException = new PropertiesException(2);
        throw propertiesException;
    }

    public String getSummary() {
        return (String)this.getProperty("SUMMARY");
    }

    public void setSummary(String string) {
        this.setProperty("SUMMARY", string);
    }

    public DateTime[] getExceptionDates() {
        ArrayList arrayList = (ArrayList)this.getProperty("EXDATE");
        if (arrayList == null) {
            return null;
        }
        DateTime[] dateTimeArray = new DateTime[arrayList.size()];
        return arrayList.toArray(dateTimeArray);
    }

    public void addExceptionDate(DateTime dateTime) {
        ArrayList<DateTime> arrayList = (ArrayList<DateTime>)this.getProperty("EXDATE");
        if (null == arrayList) {
            arrayList = new ArrayList<DateTime>();
            arrayList.add(dateTime);
            this.setProperty("EXDATE", arrayList);
        } else {
            arrayList.add(dateTime);
        }
    }

    public void removeExceptionDate(DateTime dateTime) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("EXDATE");
        if (null != arrayList && -1 != (n = arrayList.indexOf(dateTime))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("EXDATE");
            }
        }
    }

    public void removeAllExceptionDates() {
        this.removeProperty("EXDATE");
    }

    public RecurrencePattern[] getExceptionRules() {
        ArrayList arrayList = (ArrayList)this.getProperty("EXRULE");
        if (null == arrayList) {
            return null;
        }
        RecurrencePattern[] recurrencePatternArray = new RecurrencePattern[arrayList.size()];
        return arrayList.toArray(recurrencePatternArray);
    }

    public void addExceptionRule(RecurrencePattern recurrencePattern) {
        ArrayList<RecurrencePattern> arrayList = (ArrayList<RecurrencePattern>)this.getProperty("EXRULE");
        if (null == arrayList) {
            arrayList = new ArrayList<RecurrencePattern>();
            arrayList.add(recurrencePattern);
            this.setProperty("EXRULE", arrayList);
        } else {
            arrayList.add(recurrencePattern);
        }
    }

    public void removeExceptionRule(RecurrencePattern recurrencePattern) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("EXRULE");
        if (null != arrayList && -1 != (n = arrayList.indexOf(recurrencePattern))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("EXRULE");
            }
        }
    }

    public void removeAllExceptionRules() {
        this.removeProperty("EXRULE");
    }

    public DateTime[] getRecurrenceDates() {
        ArrayList arrayList = (ArrayList)this.getProperty("RDATE");
        if (arrayList == null) {
            return null;
        }
        DateTime[] dateTimeArray = new DateTime[arrayList.size()];
        return arrayList.toArray(dateTimeArray);
    }

    public void addRecurrenceDate(DateTime dateTime) {
        ArrayList<DateTime> arrayList = (ArrayList<DateTime>)this.getProperty("RDATE");
        if (null == arrayList) {
            arrayList = new ArrayList<DateTime>();
            arrayList.add(dateTime);
            this.setProperty("RDATE", arrayList);
        } else {
            arrayList.add(dateTime);
        }
    }

    public void removeRecurrenceDate(DateTime dateTime) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("RDATE");
        if (null != arrayList && -1 != (n = arrayList.indexOf(dateTime))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("RDATE");
            }
        }
    }

    public void removeAllRecurrenceDates() {
        this.removeProperty("RDATE");
    }

    public RecurrencePattern[] getRecurrenceRules() {
        ArrayList arrayList = (ArrayList)this.getProperty("RRULE");
        if (null == arrayList) {
            return null;
        }
        RecurrencePattern[] recurrencePatternArray = new RecurrencePattern[arrayList.size()];
        return arrayList.toArray(recurrencePatternArray);
    }

    public void addRecurrenceRule(RecurrencePattern recurrencePattern) {
        ArrayList<RecurrencePattern> arrayList = (ArrayList<RecurrencePattern>)this.getProperty("RRULE");
        if (null == arrayList) {
            arrayList = new ArrayList<RecurrencePattern>();
            arrayList.add(recurrencePattern);
            this.setProperty("RRULE", arrayList);
        } else {
            arrayList.add(recurrencePattern);
        }
    }

    public void removeRecurrenceRule(RecurrencePattern recurrencePattern) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty("RRULE");
        if (null != arrayList && -1 != (n = arrayList.indexOf(recurrencePattern))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty("RRULE");
            }
        }
    }

    public void removeAllRecurrenceRules() {
        this.removeProperty("RRULE");
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean bl) {
        this.allDay = bl;
    }

    public String toString() {
        return "VEvent[" + super.toString() + "\", allDay=\"" + this.allDay + "\"]";
    }

    public String toRFC2445() {
        int n;
        Object[] objectArray;
        String string = "BEGIN:VEVENT";
        if (this.hasProperty("UID")) {
            string = string + "\nUID:" + this.getID();
        }
        if (this.hasProperty("DTSTART")) {
            string = string + "\nDTSTART:" + this.getStartTime().toISO8601();
        }
        if (this.hasProperty("SUMMARY")) {
            string = string + "\nSUMMARY:" + ICalendar.escape(this.getSummary());
        }
        if (this.hasProperty(DTEND)) {
            string = string + "\nDTEND:" + this.getEndTime().toISO8601();
        }
        if (this.hasProperty("DURATION")) {
            string = string + "\nDURATION:" + this.getDuration().toRFC2445();
        }
        if (this.hasProperty("DESCRIPTION")) {
            string = string + "\nDESCRIPTION:" + ICalendar.escape(this.getDescription());
        }
        if (this.hasProperty("LOCATION")) {
            string = string + "\nLOCATION:" + ICalendar.escape(this.getLocation());
        }
        if (this.hasProperty("CLASS")) {
            string = string + "\nCLASS:" + this.getClassification();
        }
        if (this.hasProperty("DTSTAMP")) {
            string = string + "\nDTSTAMP:" + this.getStamp().toISO8601();
        }
        if (this.hasProperty("SEQUENCE")) {
            string = string + "\nSEQUENCE:" + Integer.toString(this.getSequence());
        }
        if (this.hasProperty("PRIORITY")) {
            string = string + "\nPRIORITY:" + Integer.toString(this.getPriority());
        }
        if (this.hasProperty("RECURRENCE-ID")) {
            string = string + "\nRECURRENCE-ID:" + this.getRecurrenceID().toISO8601();
        }
        if (this.hasProperty(TRANSP)) {
            string = string + "\nTRANSP:" + (String)this.getProperty(TRANSP);
        }
        if (this.hasProperty("ORGANIZER")) {
            string = string + "\n" + this.getOrganizer().toRFC2445();
        }
        if (this.hasAttendee()) {
            objectArray = this.getAttendees();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\n" + ((Attendee)objectArray[n]).toRFC2445();
            }
        }
        if (this.hasProperty("EXDATE")) {
            objectArray = this.getExceptionDates();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nEXDATE:" + ((DateTime)objectArray[n]).toISO8601();
            }
        }
        if (this.hasProperty("EXRULE")) {
            objectArray = this.getExceptionRules();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nEXRULE:" + ((RecurrencePattern)objectArray[n]).generatePattern();
            }
        }
        if (this.hasProperty("RDATE")) {
            objectArray = this.getRecurrenceDates();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nRDATE:" + ((DateTime)objectArray[n]).toISO8601();
            }
        }
        if (this.hasProperty("RRULE")) {
            objectArray = this.getRecurrenceRules();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nRRULE:" + ((RecurrencePattern)objectArray[n]).generatePattern();
            }
        }
        if (this.hasProperty("STATUS")) {
            string = string + "\nSTATUS:" + this.getStatus();
        }
        if (this.hasProperty("GEO")) {
            string = string + "\nGEO:" + this.getGeo();
        }
        if (this.hasProperty("CREATED")) {
            string = string + "\nCREATED:" + ((DateTime)this.getProperty("CREATED")).toISO8601();
        }
        if (this.hasProperty("LAST-MODIFIED")) {
            string = string + "\nLAST-MODIFIED:" + ((DateTime)this.getProperty("LAST-MODIFIED")).toISO8601();
        }
        if (this.hasProperty("ALARM")) {
            objectArray = this.getAlarmComponents();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\n" + ((VAlarm)objectArray[n]).toRFC2445();
            }
        }
        if (this.hasProperty("ATTACH")) {
            objectArray = this.getAttachments();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\n" + ((Attach)objectArray[n]).toRFC2445();
            }
        }
        if (this.hasProperty("CATEGORIES")) {
            objectArray = this.getCategories();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nCATEGORIES:" + (String)objectArray[n];
            }
        }
        if (this.hasProperty("COMMENT")) {
            objectArray = this.getComments();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nCOMMENT:" + (String)objectArray[n];
            }
        }
        if (this.hasProperty("CONTACT")) {
            objectArray = this.getContacts();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nCONTACT:" + (String)objectArray[n];
            }
        }
        if (this.hasProperty("REQUEST-STATUS")) {
            objectArray = this.getRequestStatus();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nRSTATUS:" + (String)objectArray[n];
            }
        }
        if (this.hasProperty("RELATED-TO")) {
            objectArray = this.getRelatedTos();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nRELATED-TO:" + (String)objectArray[n];
            }
        }
        if (this.hasProperty("RESOURCES")) {
            objectArray = this.getResources();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + "\nRESOURCES:" + (String)objectArray[n];
            }
        }
        string = string + "\nEND:VEVENT";
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            char[] cArray = new char[2048];
            FileReader fileReader = new FileReader(stringArray[0]);
            int n = fileReader.read(cArray, 0, 2048);
            String string = new String(cArray, 0, n);
            VEvent vEvent = new VEvent(string);
            System.out.println(vEvent.toRFC2445());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        _statusValues.put(STATUS_TENTATIVE, "Dummy1");
        _statusValues.put(STATUS_CONFIRMED, "Dummy2");
        _statusValues.put(STATUS_CANCELLED, "Dummy3");
        _classificationValues.put("CONFIDENTIAL", "Dummy1");
        _classificationValues.put("PRIVATE", "Dummy2");
        _classificationValues.put("PUBLIC", "Dummy3");
    }
}

