/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.PropertiesException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class RecurrencePattern {
    private int interval;
    private int numInstances = 0;
    private int frequency;
    private DateTime dtUntil = null;
    private String byMonthList = null;
    private String byDayList = null;
    private String byHourList = null;
    private String byMinuteList = null;
    private String bySecondsList = null;
    private String byMonthDayList = null;
    private String byWeekNumberList = null;
    private String byYearDayList = null;
    private String byInstancePosList = null;
    private String weekStart = "MO";
    public static final int SECONDLY = 10;
    public static final int MINUTELY = 20;
    public static final int HOURLY = 30;
    public static final int DAILY = 40;
    public static final int WEEKLY = 50;
    public static final int MONTHLY = 60;
    public static final int YEARLY = 70;
    public static final int FREQ = 101;
    public static final int INTERVAL = 201;
    public static final int COUNT = 301;
    public static final int UNTIL = 310;
    public static final int WKST = 325;
    public static final int BYSECOND = 401;
    public static final int BYMINUTE = 501;
    public static final int BYHOUR = 601;
    public static final int BYMONTH = 701;
    public static final int BYMONTHDAY = 710;
    public static final int BYDAY = 801;
    public static final int BYYEARDAY = 901;
    public static final int BYWEEKNO = 910;
    public static final int BYSETPOS = 920;
    public static final String THIS_INSTANCE = "THIS_INSTANCE";
    public static final String THIS_AND_FUTURE = "THIS_AND_FUTURE";
    public static final String THIS_AND_PRIOR = "THIS_AND_PRIOR";
    public static final String THIS_AND_ALL = "THIS_AND_ALL";
    private static final Hashtable paramTable = new Hashtable();
    private static final Hashtable freqTable = new Hashtable();

    private void processParams(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Syntax error in Recurrence Pattern");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        try {
            Integer n = (Integer)paramTable.get(string2);
            if (n == null) {
                throw new IllegalArgumentException("Invalid Recurrence Pattern");
            }
            switch (n) {
                case 101: {
                    this.frequency = (Integer)freqTable.get(string3);
                    return;
                }
                case 201: {
                    this.interval = Integer.parseInt(string3);
                    return;
                }
                case 301: {
                    this.numInstances = Integer.parseInt(string3);
                    return;
                }
                case 310: {
                    this.dtUntil = new DateTime(string3);
                    return;
                }
                case 401: {
                    this.bySecondsList = string3;
                    return;
                }
                case 501: {
                    this.byMinuteList = string3;
                    return;
                }
                case 601: {
                    this.byHourList = string3;
                    return;
                }
                case 801: {
                    this.byDayList = string3;
                    return;
                }
                case 901: {
                    this.byYearDayList = string3;
                    return;
                }
                case 910: {
                    this.byWeekNumberList = string3;
                    return;
                }
                case 701: {
                    this.byMonthList = string3;
                    return;
                }
                case 710: {
                    this.byMonthDayList = string3;
                    return;
                }
                case 325: {
                    this.weekStart = string3;
                    return;
                }
                case 920: {
                    this.byInstancePosList = string3;
                    return;
                }
            }
            throw new IllegalArgumentException("RecurrencePattern: Invalid property value");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    private String getListParam(String string, String string2) {
        if (string2 != null) {
            return ";" + string + "=" + string2;
        }
        return "";
    }

    public RecurrencePattern(int n, int n2, int n3) {
        this.frequency = n;
        this.interval = n2;
        this.numInstances = n3;
    }

    public RecurrencePattern(int n, int n2) {
        this.frequency = n;
        this.interval = n2;
        this.numInstances = -1;
    }

    public RecurrencePattern(int n, int n2, DateTime dateTime) {
        this.frequency = n;
        this.interval = n2;
        this.dtUntil = dateTime;
    }

    public RecurrencePattern(String string, int n, int n2) {
        this.frequency = (Integer)freqTable.get(string.toUpperCase());
        this.interval = n;
        this.numInstances = n2;
    }

    public RecurrencePattern(String string, int n) {
        this.frequency = (Integer)freqTable.get(string.toUpperCase());
        this.interval = n;
        this.numInstances = -1;
    }

    public RecurrencePattern(String string) throws IllegalArgumentException {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string3 = string;
        this.numInstances = -1;
        this.interval = 1;
        if (stringTokenizer.countTokens() > 1) {
            string2 = stringTokenizer.nextToken();
            if (string2 != null && !string2.equalsIgnoreCase("RRULE")) {
                throw new IllegalArgumentException("Not a Recurrence Pattern");
            }
            string3 = stringTokenizer.nextToken();
        }
        stringTokenizer = new StringTokenizer(string3, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            this.processParams(string2);
        }
    }

    public void setFrequency(String string) throws PropertiesException {
        Integer n = (Integer)freqTable.get(string);
        boolean bl = false;
        if (n == null) {
            throw new PropertiesException("RecurrencePattern:Invalid frequency value", 2);
        }
        this.frequency = n;
    }

    public void setUntilDate(DateTime dateTime) {
        this.dtUntil = dateTime;
    }

    public void setByMonth(String string) {
        this.byMonthList = string;
    }

    public void setByDay(String string) {
        this.byDayList = string;
    }

    public void setByHour(String string) {
        this.byHourList = string;
    }

    public void setByMinute(String string) {
        this.byMinuteList = string;
    }

    public void setBySecond(String string) {
        this.bySecondsList = string;
    }

    public void setByMonthDay(String string) {
        this.byMonthDayList = string;
    }

    public void setByYearDay(String string) {
        this.byYearDayList = string;
    }

    public void setByWeekNumber(String string) {
        this.byWeekNumberList = string;
    }

    public void setInstancePos(String string) {
        this.byInstancePosList = string;
    }

    public void setWeekStart(String string) {
        this.weekStart = string;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getFrequency() {
        Integer n = new Integer(this.frequency);
        int n2 = freqTable.size();
        Enumeration enumeration = freqTable.keys();
        for (int i = 0; i < n2; ++i) {
            String string = (String)enumeration.nextElement();
            if (!((Integer)freqTable.get(string)).equals(n)) continue;
            return string;
        }
        return null;
    }

    public DateTime getUntilDate() {
        return this.dtUntil;
    }

    public String getByHour() {
        return this.byHourList;
    }

    public String generatePattern() {
        String string = "FREQ=" + this.getFrequency();
        if (this.interval != 1) {
            string = string + ";INTERVAL=" + this.interval;
        }
        if (this.dtUntil != null) {
            string = string + ";UNTIL=" + this.dtUntil;
        } else if (this.numInstances != -1) {
            string = string + ";COUNT=" + this.numInstances;
        }
        string = string + this.getListParam("WKST", this.weekStart);
        string = string + this.getListParam("BYSECOND", this.bySecondsList);
        string = string + this.getListParam("BYMINUTE", this.byMinuteList);
        string = string + this.getListParam("BYHOUR", this.byHourList);
        string = string + this.getListParam("BYDAY", this.byDayList);
        string = string + this.getListParam("BYMONTH", this.byMonthList);
        string = string + this.getListParam("BYMONTHDAY", this.byMonthDayList);
        string = string + this.getListParam("BYYEARDAY", this.byYearDayList);
        string = string + this.getListParam("BYWEEKNO", this.byWeekNumberList);
        string = string + this.getListParam("BYSETPOS", this.byInstancePosList);
        string = string + this.getListParam("BYYEARDAY", this.byYearDayList);
        return string;
    }

    public String toRFC2445() {
        return this.generatePattern();
    }

    static {
        paramTable.put("FREQ", new Integer(101));
        paramTable.put("INTERVAL", new Integer(201));
        paramTable.put("COUNT", new Integer(301));
        paramTable.put("UNTIL", new Integer(310));
        paramTable.put("BYSECOND", new Integer(401));
        paramTable.put("BYMINUTE", new Integer(501));
        paramTable.put("BYHOUR", new Integer(601));
        paramTable.put("BYMONTH", new Integer(701));
        paramTable.put("BYMONTHDAY", new Integer(710));
        paramTable.put("BYDAY", new Integer(801));
        paramTable.put("WKST", new Integer(325));
        paramTable.put("BYWEEKNO", new Integer(910));
        paramTable.put("BYYEARDAY", new Integer(901));
        paramTable.put("BYSETPOS", new Integer(920));
        freqTable.put("SECONDLY", new Integer(10));
        freqTable.put("MINUTELY", new Integer(20));
        freqTable.put("HOURLY", new Integer(30));
        freqTable.put("DAILY", new Integer(40));
        freqTable.put("WEEKLY", new Integer(50));
        freqTable.put("MONTHLY", new Integer(60));
        freqTable.put("YEARLY", new Integer(70));
    }
}

