/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.StoreNotFoundException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.TimeZone;

public final class CalendarSession {
    Properties props;
    static /* synthetic */ Class class$com$sun$comclient$calendar$CalendarSession;

    public static CalendarSession getInstance(Properties properties) {
        return new CalendarSession(properties);
    }

    private CalendarSession(Properties properties) {
        this.props = properties;
    }

    public CalendarStore getStore(String string) throws StoreNotFoundException {
        if (string.equals("socs")) {
            string = "com.sun.comclient.calendar.socs.SOCSCalendarStore";
        } else if (string.equals("exchange")) {
            string = "com.sun.comclient.calendar.exchange.ExchangeCalStore";
        }
        CalendarStore calendarStore = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{class$com$sun$comclient$calendar$CalendarSession == null ? (class$com$sun$comclient$calendar$CalendarSession = CalendarSession.class$("com.sun.comclient.calendar.CalendarSession")) : class$com$sun$comclient$calendar$CalendarSession};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            calendarStore = (CalendarStore)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new StoreNotFoundException(exception.toString());
        }
        return calendarStore;
    }

    public CalendarStore getStore() throws StoreNotFoundException {
        String string = this.props.getProperty("cal.serviceAdapterClass");
        if (string == null) {
            throw new StoreNotFoundException("No service classname specified");
        }
        return this.getStore(string);
    }

    public TimeZone getTimeZone() {
        if (this.getProperty("cal.preferredTimeZone") != null) {
            return TimeZone.getTimeZone(this.getProperty("cal.preferredTimeZone"));
        }
        return null;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.setProperty("cal.preferredTimeZone", timeZone.getID());
    }

    public String getHost() {
        return this.getProperty("cal.host");
    }

    public void setHost(String string) {
        this.setProperty("cal.host", string);
    }

    public int getPort() {
        return Integer.parseInt(this.getProperty("cal.port", "-1"));
    }

    public void setPort(int n) {
        if (n <= 0) {
            n = -1;
        }
        this.setProperty("cal.port", Integer.toString(n));
    }

    public void setProperty(String string, String string2) {
        this.props.put(string, string2);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public Properties getProperties() {
        return this.props;
    }

    public String toString() {
        return "CalendarSession[" + this.props.toString() + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

