/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import java.util.ArrayList;
import java.util.Hashtable;

public class CalendarComponent {
    public static final String ATTENDEE = "ATTENDEE";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String DTSTART = "DTSTART";
    public static final String DURATION = "DURATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String RSTATUS = "REQUEST-STATUS";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String CALID = "RELATIVE-CALID";
    private Hashtable properties = null;

    protected CalendarComponent() {
    }

    protected CalendarComponent(DateTime dateTime) {
        this.setStart(dateTime);
    }

    protected CalendarComponent(String string, DateTime dateTime) {
        this.setID(string);
        this.setStart(dateTime);
    }

    public boolean hasAttendee() {
        return this.hasProperty(ATTENDEE);
    }

    public Attendee[] getAttendees() {
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            return null;
        }
        Attendee[] attendeeArray = new Attendee[arrayList.size()];
        return arrayList.toArray(attendeeArray);
    }

    public void addAttendee(Attendee attendee) {
        ArrayList<Attendee> arrayList = (ArrayList<Attendee>)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            arrayList = new ArrayList<Attendee>();
            arrayList.add(attendee);
            this.setProperty(ATTENDEE, arrayList);
        } else {
            arrayList.add(attendee);
        }
    }

    public void removeAttendee(Attendee attendee) {
        if (null == attendee) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null != arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Attendee attendee2 = (Attendee)arrayList.get(i);
                if (!attendee.toRFC2445().equals(attendee2.toRFC2445())) continue;
                arrayList.remove(i);
                if (arrayList.size() > 0) break;
                this.removeProperty(ATTENDEE);
                break;
            }
        }
    }

    public void removeAllAttendees() {
        this.removeProperty(ATTENDEE);
    }

    public String[] getContacts() {
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(CONTACT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(CONTACT, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null != arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!string.equals((String)arrayList.get(i))) continue;
                arrayList.remove(i);
                if (arrayList.size() > 0) break;
                this.removeProperty(CONTACT);
                break;
            }
        }
    }

    public void removeAllContacts() {
        this.removeProperty(CONTACT);
    }

    public String[] getComments() {
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(COMMENT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(COMMENT, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null != arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!string.equals((String)arrayList.get(i))) continue;
                arrayList.remove(i);
                if (arrayList.size() > 0) break;
                this.removeProperty(COMMENT);
                break;
            }
        }
    }

    public void removeAllComments() {
        this.removeProperty(COMMENT);
    }

    public DateTime getStamp() {
        return (DateTime)this.getProperty(DTSTAMP);
    }

    public void setStamp(DateTime dateTime) {
        this.setProperty(DTSTAMP, dateTime);
    }

    public DateTime getStart() {
        return (DateTime)this.getProperty(DTSTART);
    }

    public void setStart(DateTime dateTime) {
        this.setProperty(DTSTART, dateTime);
    }

    public Duration getDuration() {
        return (Duration)this.getProperty(DURATION);
    }

    public void setDuration(Duration duration) throws PropertiesException {
        this.setProperty(DURATION, duration);
    }

    public Organizer getOrganizer() {
        return (Organizer)this.getProperty(ORGANIZER);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(ORGANIZER, organizer);
    }

    public String[] getRequestStatus() {
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addRequestStatus(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(RSTATUS);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(RSTATUS, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeRequestStatus(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RSTATUS);
            }
        }
    }

    public void removeAllRequestStatus() {
        this.removeProperty(RSTATUS);
    }

    public String getID() {
        return (String)this.getProperty(UID);
    }

    public void setID(String string) {
        this.setProperty(UID, string);
    }

    public String getUrl() {
        return (String)this.getProperty(URL);
    }

    public void setUrl(String string) {
        this.setProperty(URL, string);
    }

    public String getCalID() {
        return (String)this.getProperty(CALID);
    }

    public void setCalID(String string) {
        this.setProperty(CALID, string);
    }

    public Object getProperty(String string) {
        if (null == string) {
            return null;
        }
        if (null != this.properties) {
            return this.properties.get(string);
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        if (null == string) {
            return;
        }
        if (null == this.properties) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, object);
    }

    public void removeProperty(String string) {
        if (null == string) {
            return;
        }
        if (null != this.properties) {
            this.properties.remove(string);
        }
    }

    public boolean hasProperty(String string) {
        if (null == string) {
            return false;
        }
        if (null != this.properties) {
            return this.properties.containsKey(string);
        }
        return false;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    protected void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public String toString() {
        return "CalendarComponent[" + (this.properties != null ? this.properties.toString() : "null") + "]";
    }
}

