/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.identity.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class Auth {
    static String IM_SERVICE = "SunIM";
    static String PRESENCE_SERVICE = "SunPresence";

    private static void addLoginCallbackMessage(Callback[] callbacks, String user, String password) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(user);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(password.toCharArray());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static SSOToken getSSOToken(String orgDN, String user, String password) throws UnsupportedCallbackException, LoginException, Exception {
        AuthContext lc = null;
        try {
            lc = new AuthContext(orgDN);
            lc.login();
        }
        catch (LoginException le) {
            return null;
        }
        Callback[] callbacks = null;
        if (lc.hasMoreRequirements() && (callbacks = lc.getRequirements()) != null) {
            Auth.addLoginCallbackMessage(callbacks, user, password);
            lc.submitRequirements(callbacks);
        }
        if (lc.getStatus() != AuthContext.Status.SUCCESS) {
            return null;
        }
        return lc.getSSOToken();
    }

    public static AMStoreConnection getAdminStoreConnection(String adminDN, String password) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken token = manager.createSSOToken((Principal)new MyPrincipal(adminDN), password);
        return new AMStoreConnection(token);
    }

    public static AMStoreConnection getAdminStoreConnection() throws SSOException {
        return Auth.getAdminStoreConnection(Auth.getAdminDN(), Auth.getAdminPassword());
    }

    public static String getAdminDN() {
        String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
        return adminDN;
    }

    public static String getAdminPassword() {
        String password = (String)AccessController.doPrivileged(new AdminPasswordAction());
        return password;
    }

    public static SSOToken getAdminSSOToken(String adminDN, String password) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        return manager.createSSOToken((Principal)new MyPrincipal(adminDN), password);
    }

    public static String getOrganizationDN(String ssoTokenString) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken ssoToken = manager.createSSOToken(ssoTokenString);
            AMStoreConnection connection = new AMStoreConnection(ssoToken);
            String userId = ssoToken.getPrincipal().getName();
            AMUser user = connection.getUser(userId);
            String orgDN = user.getOrganizationDN();
            return orgDN;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isServicesAssigned(AMUser user) throws AMException, SSOException {
        boolean presServAssigned = false;
        boolean imServAssigned = false;
        Set services = user.getAssignedServices();
        if (services != null) {
            Iterator i = services.iterator();
            while (i.hasNext()) {
                String servName = (String)i.next();
                if (servName.equals(PRESENCE_SERVICE)) {
                    presServAssigned = true;
                }
                if (!servName.equals(IM_SERVICE)) continue;
                imServAssigned = true;
            }
        }
        return presServAssigned && imServAssigned;
    }

    static class MyPrincipal
    implements Principal {
        String name;

        MyPrincipal(String dn) {
            this.name = dn;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o.toString().equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

