/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.identity.util;

import java.util.Enumeration;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;

public class RemoveObjectClass {
    static String binddn = "cn=Directory Manager";
    static String password = null;
    static String ldaphost = "localhost";
    static int port = 389;
    static String oc = null;
    static String schemadn = "cn=schema";
    static boolean removeAttributes = false;

    public static void main(String[] stringArray) {
        try {
            RemoveObjectClass.parseCommand(stringArray, 0);
            RemoveObjectClass.doit();
            System.exit(0);
        }
        catch (Exception exception) {
            System.exit(1);
        }
    }

    public static void parseCommand(String[] stringArray, int n) {
        try {
            for (int i = n; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-h")) {
                    ldaphost = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-p")) {
                    port = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-D")) {
                    binddn = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-w")) {
                    password = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-O")) {
                    oc = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-b")) {
                    schemadn = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-a")) continue;
                removeAttributes = true;
            }
            if (oc == null) {
                throw new Exception("Object class not specified");
            }
        }
        catch (Exception exception) {
            System.out.println("Usage: RemoveObjectClass -s name [ -h ldaphost ] [ -p port ] [ -D binddn ] [ -w password ] [ -b schemadn ] [ -a ]");
            System.exit(1);
        }
    }

    private static void doit() throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        lDAPConnection.connect(3, ldaphost, port, binddn, password);
        LDAPSchema lDAPSchema = new LDAPSchema();
        lDAPSchema.fetchSchema(lDAPConnection, schemadn);
        LDAPObjectClassSchema lDAPObjectClassSchema = lDAPSchema.getObjectClass(oc);
        if (lDAPObjectClassSchema != null) {
            lDAPObjectClassSchema.remove(lDAPConnection, schemadn);
            if (removeAttributes) {
                LDAPAttributeSchema lDAPAttributeSchema;
                Enumeration enumeration = lDAPObjectClassSchema.getOptionalAttributes();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        lDAPAttributeSchema = lDAPSchema.getAttribute((String)enumeration.nextElement());
                        if (lDAPAttributeSchema == null) continue;
                        lDAPAttributeSchema.remove(lDAPConnection, schemadn);
                    }
                }
                if ((enumeration = lDAPObjectClassSchema.getRequiredAttributes()) != null) {
                    while (enumeration.hasMoreElements()) {
                        lDAPAttributeSchema = lDAPSchema.getAttribute((String)enumeration.nextElement());
                        if (lDAPAttributeSchema == null) continue;
                        lDAPAttributeSchema.remove(lDAPConnection, schemadn);
                    }
                }
            }
        }
        lDAPConnection.disconnect();
    }
}

