/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.gap;

import com.iplanet.ens.gap.GapMsg;
import com.iplanet.ens.gap.GapMsgListener;
import com.iplanet.ens.gap.ParseException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class GapReader
implements Runnable {
    private boolean _keepGoing = true;
    private GapMsgListener _listener;
    private Vector _messages = new Vector();
    private Vector _listeners = new Vector();
    private Reader _inputReader;
    private InputStream _inputStream;
    private Exception _exception;
    OutputStream _log;
    String _encoding;
    public int MAX_LINE_LENGTH = 1024;

    public GapReader(InputStream inputStream, String string, OutputStream outputStream) {
        this._log = outputStream;
        this._inputStream = inputStream;
        this._encoding = string;
        try {
            this._inputReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((char)(n = this._inputStream.read()) != '\r') {
            if (n == -1) {
                throw new EOFException();
            }
            stringBuffer.append((char)n);
        }
        this._inputStream.read();
        if (this._log != null) {
            this._log.write(("<< " + stringBuffer.toString() + "\n").getBytes());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this._keepGoing = true;
        try {
            block6: while (this._keepGoing) {
                Object object;
                GapMsg gapMsg = new GapMsg(this.readLine());
                int n = gapMsg.getLen();
                if (n > 0) {
                    int n2;
                    object = new byte[n];
                    int n3 = 0;
                    int n4 = this._inputStream.read((byte[])object, n3, n);
                    if (n4 == -1) {
                        throw new ParseException("Error in parsing payload: numBytes read = " + n4 + " len = " + n);
                    }
                    n3 += n4;
                    for (n2 = n - n4; n2 > 0; n2 -= n4, n3 += n4) {
                        n4 = this._inputStream.read((byte[])object, n3, n2);
                        if (n4 != -1) continue;
                        throw new ParseException("Error in parsing payload: numBytes = " + n4 + " numLeft = " + n2 + " len = " + n);
                    }
                    if (n2 != 0) {
                        throw new ParseException("Error in parsing payload: numBytes = " + n4 + " numLeft = " + n2 + " len = " + n);
                    }
                    String string = this._encoding != null ? new String((byte[])object, this._encoding) : new String((byte[])object);
                    gapMsg.setPayload(string);
                }
                if (!this._listeners.isEmpty()) {
                    object = this._listeners.elements();
                    while (true) {
                        if (!object.hasMoreElements()) continue block6;
                        GapMsgListener gapMsgListener = (GapMsgListener)object.nextElement();
                        gapMsgListener.onMessage(gapMsg);
                    }
                }
                GapReader gapReader = this;
                object = gapReader;
                // MONITORENTER : gapReader
                this._messages.addElement(gapMsg);
                this.notifyAll();
                // MONITOREXIT : object
            }
            return;
        }
        catch (Exception exception) {
            Object object;
            this._exception = exception;
            exception.printStackTrace();
            if (!this._listeners.isEmpty()) {
                object = this._listeners.elements();
                while (object.hasMoreElements()) {
                    GapMsgListener gapMsgListener = (GapMsgListener)object.nextElement();
                    gapMsgListener.onMessage(null);
                }
            }
            object = this;
            // MONITORENTER : object
            this._keepGoing = false;
            this.notifyAll();
            // MONITOREXIT : object
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        GapReader gapReader = this;
        synchronized (gapReader) {
            this._keepGoing = false;
            this.notifyAll();
        }
    }

    public synchronized GapMsg readMsg() throws InterruptedException, ParseException, IOException {
        if (this._keepGoing) {
            if (this._messages.isEmpty()) {
                this.wait();
            }
            if (!this._messages.isEmpty()) {
                GapMsg gapMsg = (GapMsg)this._messages.firstElement();
                this.releaseMsg(gapMsg);
                return gapMsg;
            }
        }
        return null;
    }

    public synchronized GapMsg readMsg(int n) throws InterruptedException, ParseException, IOException {
        if (this._keepGoing) {
            if (this._messages.isEmpty()) {
                this.wait(n);
            }
            if (!this._messages.isEmpty()) {
                return (GapMsg)this._messages.firstElement();
            }
        }
        return null;
    }

    protected void releaseMsg(GapMsg gapMsg) {
        this._messages.remove(gapMsg);
    }

    protected void addListener(GapMsgListener gapMsgListener) {
        this._listeners.addElement(gapMsgListener);
    }
}

