/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public final class iIMUtility {
    static final String CFONTS = " <font size=\"2\"> ";
    static final String CFONTE = " </font>";
    static SafeResourceBundle iIMUtilityBundle = new SafeResourceBundle("com.iplanet.im.client.util.util");

    public static final boolean isAppAttachment(String name) {
        return !name.toLowerCase().endsWith(".exe") || !name.toLowerCase().endsWith(".bat") || !name.toLowerCase().endsWith(".com") || name.toLowerCase().startsWith("http://");
    }

    public static final void setColumn(JTable table, int c, boolean resize, int width, String head) {
        TableColumn tc = table.getColumnModel().getColumn(c);
        tc.setResizable(resize);
        tc.setHeaderValue(head);
        tc.setWidth(width);
        tc.setPreferredWidth(width);
    }

    public static final void showMessageProperties(Message m) {
        try {
            StringBuffer buf = new StringBuffer(ClientMessageFactory.getSubject(m) + iIMUtilityBundle.getString("Content_Properties__n"));
            buf.append(iIMUtilityBundle.getString("buf_append_4") + m.getMessageId());
            buf.append(iIMUtilityBundle.getString("buf_append_6") + m.getExpirationDate());
            buf.append(iIMUtilityBundle.getString("buf_append") + m.getOriginator());
            buf.append(iIMUtilityBundle.getString("buf_append_1"));
            String[] d = m.getRecipients();
            for (int i = 0; i < d.length; ++i) {
                buf.append("    ");
                buf.append(d[i] + " \n");
            }
            buf.append("\n\n");
            buf.append(iIMUtilityBundle.getString("buf_append_2"));
            buf.append(iIMUtilityBundle.getString("buf_append_3"));
            buf.append(m.getContentType());
            buf.append("\n");
            buf.append("\n");
            buf.append("\n");
            MessagePart[] parts = m.getParts();
            buf.append(ClientMessageFactory.getHTMLContent(parts[0]));
            EditorUtility.viewSource(buf.toString(), iIMUtilityBundle.getString("Properties_For") + ClientMessageFactory.getSubject(m));
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final String getTimeStampEx() {
        Calendar c = Calendar.getInstance();
        StringBuffer ret = new StringBuffer(CFONTS);
        if (c.get(11) > 12) {
            ret.append(c.get(11) - 12);
        } else {
            ret.append(c.get(11));
        }
        ret.append(":");
        if (c.get(12) < 10) {
            ret.append("0");
        }
        ret.append(c.get(12));
        ret.append(":");
        if (c.get(13) < 10) {
            ret.append("0");
        }
        ret.append(c.get(13));
        ret.append(CFONTE);
        return ret.toString();
    }

    public static final String getTimeStampReg() {
        Calendar c = Calendar.getInstance();
        StringBuffer ret = new StringBuffer();
        if (c.get(11) > 12) {
            ret.append(c.get(11) - 12);
        } else {
            ret.append(c.get(11));
        }
        ret.append(":");
        if (c.get(12) < 10) {
            ret.append("0");
        }
        ret.append(c.get(12));
        ret.append(":");
        if (c.get(13) < 10) {
            ret.append("0");
        }
        ret.append(c.get(13));
        return ret.toString();
    }

    public static final String getTimeStampSmall(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        StringBuffer ret = new StringBuffer();
        ret.append(c.get(2) + 1);
        ret.append("/");
        ret.append(c.get(5));
        ret.append(" ");
        if (c.get(11) > 12) {
            ret.append(c.get(11) - 12);
        } else if (c.get(11) == 0) {
            ret.append(12);
        } else {
            ret.append(c.get(11));
        }
        ret.append(":");
        if (c.get(12) < 10) {
            ret.append("0");
        }
        ret.append(c.get(12));
        return ret.toString();
    }

    public static final String getTimeStamp(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        StringBuffer ret = new StringBuffer();
        ret.append(c.get(1));
        ret.append("/");
        ret.append(c.get(2) + 1);
        ret.append("/");
        ret.append(c.get(5));
        ret.append(" - ");
        ret.append(c.get(11));
        ret.append(":");
        ret.append(c.get(12));
        ret.append(":");
        ret.append(c.get(13));
        return ret.toString();
    }

    public static final void printDoc(Frame parent, String s, JEditorPane txt) {
        try {
            System.out.println("<<< Start Print Job >>>");
            Properties props = new Properties();
            String title = iIMUtilityBundle.getString("Print_Message");
            PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(parent, title + s, props);
            if (pj == null) {
                return;
            }
            System.out.println("Returned props " + props);
            Dimension dPage = txt.getSize();
            Dimension dPj = pj.getPageDimension();
            System.out.println(dPage.width);
            System.out.println(dPage.height);
            System.out.println(dPj.width);
            System.out.println(dPj.height);
            int numPages = dPage.height / dPj.height;
            if (dPage.height % dPj.height > 0) {
                ++numPages;
            }
            System.out.println("PRINTING NUM PAGES " + numPages);
            int offset = 0;
            for (int n = 0; n < numPages; ++n) {
                Graphics g = pj.getGraphics();
                Rectangle rec = new Rectangle(0, 0, dPj.width, dPj.height);
                iIMUtility.print(txt, g, rec, offset);
                offset -= dPj.height;
            }
            pj.end();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static final void print(JEditorPane txtPane, Graphics g, Rectangle r, int trans) {
        g.clipRect(r.x, r.y, r.width, r.height);
        g.translate(0, trans);
        txtPane.print(g);
        g.dispose();
        g = null;
    }

    public static final String getTimeStamp() {
        return iIMUtility.getTimeStamp(new Date());
    }

    public static final String getNETVersion() {
        return "6.2";
    }

    public static final String getNMSVersion() {
        return "6.2";
    }
}

