/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.ImageLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class ViewUtility {
    public static final void updateUI(JFrame f) {
        if (f == null) {
            return;
        }
        SwingUtilities.updateComponentTreeUI(f.getContentPane());
    }

    private static final void setLAF(LookAndFeel laf) {
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.out.println("setLAF:" + e);
        }
    }

    public static final void setLAF(String className) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)Class.forName(className).newInstance());
    }

    public static final void setJavaLAF() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("setDefaultLAF:" + e);
        }
    }

    public static final void setDefaultLAF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println("setDefaultLAF:" + e);
        }
    }

    public static final void setBackground(JFrame frame, ImageIcon img) {
        if (img == null) {
            return;
        }
        ((JPanel)frame.getContentPane()).setOpaque(false);
        ImageLabel backlabel = new ImageLabel(img);
        frame.getLayeredPane().add((Component)backlabel, new Integer(Integer.MIN_VALUE));
        backlabel.setBounds(0, 0, 1500, 1500);
    }

    public static final ImageLabel getPanelBackground(JPanel panel, ImageIcon img) {
        if (img == null) {
            return null;
        }
        panel.setOpaque(false);
        ImageLabel backlabel = new ImageLabel(img);
        backlabel.setBounds(0, 0, 1500, 1500);
        return backlabel;
    }

    public static final Point getRectangleCenter(Dimension dOut, Dimension dIn) {
        return new Point((dOut.width - dIn.width) / 2, (dOut.height - dIn.height) / 2);
    }
}

