/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.util.PlatformUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class SwingUtils {
    public static JMenuItem menuItem(ActionListener listener, SafeResourceBundle bundle, String labelKey, String mnemonicKey, String acceleratorKey) {
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        String mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        String accelerator = acceleratorKey != null ? bundle.getString(acceleratorKey) : null;
        return SwingUtils.menuItem(listener, label, mnemonic, accelerator);
    }

    public static JMenuItem menuItem(ActionListener listener, String label, String mnemonic, String accelerator) {
        JMenuItem item = new JMenuItem(label);
        if (listener != null) {
            item.addActionListener(listener);
        }
        if (mnemonic != null && mnemonic.length() > 0) {
            item.setMnemonic(mnemonic.charAt(0));
        }
        if (accelerator != null && accelerator.length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke((int)accelerator.charAt(0), 2));
        }
        return item;
    }

    public static JRadioButtonMenuItem radioMenuItem(ActionListener listener, SafeResourceBundle bundle, String labelKey, String mnemonicKey, ButtonGroup mutExGroup) {
        String mnemonic;
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
        if (listener != null) {
            item.addActionListener(listener);
        }
        String string = mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        if (mnemonic != null && mnemonic.length() > 0) {
            item.setMnemonic(mnemonic.charAt(0));
        }
        if (mutExGroup != null) {
            mutExGroup.add(item);
        }
        return item;
    }

    public static JCheckBoxMenuItem checkBoxMenuItem(ActionListener listener, SafeResourceBundle bundle, String labelKey, String mnemonicKey, String acceleratorKey) {
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(label);
        String mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        String accelerator = acceleratorKey != null ? bundle.getString(acceleratorKey) : null;
        item.addActionListener(listener);
        if (mnemonic != null && mnemonic.length() > 0) {
            item.setMnemonic(mnemonic.charAt(0));
        }
        if (accelerator != null && accelerator.length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(new Character(accelerator.charAt(0)), 2));
        }
        return item;
    }

    public static JCheckBox checkBoxItem(SafeResourceBundle bundle, String actionCommandKey, String labelKey, String mnemonicKey, String toolTipKey) {
        String toolTipText;
        String actionCommand;
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        JCheckBox item = new JCheckBox(label);
        String mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        String string = actionCommand = actionCommandKey != null ? bundle.getString(actionCommandKey) : null;
        if (actionCommand != null) {
            item.setActionCommand(actionCommand);
        }
        if (mnemonic != null && mnemonic.length() > 0) {
            item.setMnemonic(mnemonic.charAt(0));
        }
        String string2 = toolTipText = toolTipKey != null ? bundle.getString(toolTipKey) : null;
        if (toolTipText != null && toolTipText.length() != 0) {
            item.setToolTipText(toolTipText);
        }
        return item;
    }

    public static boolean gotBug4919244(SafeResourceBundle bundle, String labelMnemonicKey, String buttonMnemonicKey) {
        if (PlatformUtil.isJDK1_3() || PlatformUtil.isJDK1_2()) {
            String labelMnemonic;
            String string = labelMnemonic = labelMnemonicKey != null ? bundle.getString(labelMnemonicKey) : null;
            if (labelMnemonic != null && labelMnemonic.length() > 0) {
                String buttonMnemonic;
                String string2 = buttonMnemonic = buttonMnemonicKey != null ? bundle.getString(buttonMnemonicKey) : null;
                if (buttonMnemonic != null && buttonMnemonic.length() > 0 && labelMnemonic.charAt(0) == buttonMnemonic.charAt(0)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static JLabel makeLabelItem(SafeResourceBundle bundle, String labelKey, String mnemonicKey, Component labelFor) {
        String mnemonic;
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        JLabel item = new JLabel(label);
        String string = mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        if (labelFor != null) {
            item.setLabelFor(labelFor);
        }
        if (mnemonic != null && mnemonic.length() > 0) {
            item.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        return item;
    }

    public static void setupButton(AbstractButton button, SafeResourceBundle bundle, String labelKey, String mnemonicKey, String actionCommandKey, String toolTipKey) {
        String toolTipText;
        String actionCommand;
        String mnemonic;
        String label = labelKey != null ? bundle.getString(labelKey) : null;
        button.setText(label);
        String string = mnemonic = mnemonicKey != null ? bundle.getString(mnemonicKey) : null;
        if (mnemonic != null && mnemonic.length() > 0) {
            button.setMnemonic(mnemonic.charAt(0));
        }
        String string2 = actionCommand = actionCommandKey != null ? bundle.getString(actionCommandKey) : null;
        if (actionCommand != null) {
            button.setActionCommand(actionCommand);
        }
        String string3 = toolTipText = toolTipKey != null ? bundle.getString(toolTipKey) : null;
        if (toolTipText != null && toolTipText.length() != 0) {
            button.setToolTipText(toolTipText);
        }
    }

    public static Dimension getComponentSize(JComponent comp, int cols, int rows) {
        Font font = comp.getFont();
        FontMetrics fm = comp.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        Dimension dim = new Dimension();
        dim.width = fm.charWidth('a') * cols;
        dim.height = fontHeight * rows;
        return dim;
    }
}

