/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.io.File;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

class StickyFileChooserFilter
extends FileFilter {
    private HashSet extensions = null;
    private String fileType = null;

    StickyFileChooserFilter(String fileExtensions, String fileType) {
        if (fileExtensions != null) {
            this.extensions = new HashSet();
            StringTokenizer st = new StringTokenizer(fileExtensions, ";");
            while (st.hasMoreTokens()) {
                String ext = st.nextToken();
                while (ext.startsWith("*")) {
                    ext = ext.substring(1);
                }
                if (!ext.startsWith(".")) {
                    ext = "." + ext;
                }
                this.extensions.add(ext);
            }
        }
        this.fileType = fileType;
    }

    public boolean accept(File f) {
        if (this.extensions == null || this.extensions.size() == 0) {
            return true;
        }
        if (f.isDirectory()) {
            return true;
        }
        int i = f.getName().lastIndexOf(".");
        if (i > 0) {
            String ext = f.getName().substring(i);
            return this.extensions.contains(ext);
        }
        return false;
    }

    public String getDescription() {
        return this.fileType;
    }
}

