/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.StickyFileChooserFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class StickyFileChooser {
    private static SafeResourceBundle _bundle = new SafeResourceBundle("com.iplanet.im.client.util.util");
    private static File currentDirectory = null;

    public static File chooseSaveFile(Component parent, String defaultFileName, String fileExtension, String fileType) {
        int rc = -1;
        String ext = fileExtension != null && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        JFileChooser fc = new JFileChooser(currentDirectory);
        if (fileExtension != null) {
            StickyFileChooserFilter filter = new StickyFileChooserFilter(fileExtension, fileType);
            fc.setFileFilter(filter);
        }
        if (defaultFileName != null) {
            fc.setSelectedFile(new File(currentDirectory, defaultFileName));
        }
        try {
            rc = fc.showSaveDialog(parent);
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (rc) {
            case 0: {
                int overwrite;
                File f = fc.getSelectedFile();
                if (parent != null && f.exists() && (overwrite = JOptionPane.showConfirmDialog(parent, _bundle.getString("FileDialog_fileExist_question"), _bundle.getString("FileDialog_fileExist_title"), 0)) == 1) {
                    f = null;
                }
                currentDirectory = fc.getCurrentDirectory();
                if (ext != null && !f.getName().endsWith(ext)) {
                    f = new File(f.getParentFile(), f.getName() + ext);
                }
                return f;
            }
        }
        return null;
    }

    public static File chooseFile(Component parent, String fileExtensions, String fileType, String dialogTitle, String approveButtonLabel, String approveButtonMnemonic) {
        int rc = -1;
        JFileChooser fc = new JFileChooser(currentDirectory);
        if (fileExtensions != null) {
            StickyFileChooserFilter filter = new StickyFileChooserFilter(fileExtensions, fileType);
            fc.setFileFilter(filter);
        }
        try {
            if (approveButtonLabel != null) {
                if (dialogTitle != null) {
                    fc.setDialogTitle(dialogTitle);
                }
                if (approveButtonLabel != null) {
                    fc.setApproveButtonText(approveButtonLabel);
                }
                if (approveButtonMnemonic != null) {
                    fc.setApproveButtonMnemonic(approveButtonMnemonic.charAt(0));
                }
                rc = fc.showDialog(parent, approveButtonLabel);
            } else {
                rc = fc.showOpenDialog(parent);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (rc) {
            case 0: {
                currentDirectory = fc.getCurrentDirectory();
                return fc.getSelectedFile();
            }
        }
        return null;
    }

    public static File chooseOpenFile(Component parent, String fileExtensions, String fileType) {
        return StickyFileChooser.chooseFile(parent, fileExtensions, fileType, null, null, null);
    }
}

