/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.GridBagConstraintsD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class StatusWindow
extends JWindow {
    private Component obj;
    private SplashMouseAdapter mouseAdapter;
    private Point point;
    EtchedBorder border = new EtchedBorder(4, Color.green.darker(), Color.black);
    private JPanel panel = new JPanel();
    private static long _sleep = 8L;
    private Dimension size = new Dimension(200, 45);
    private boolean run_thread = false;
    public long display_time = 20000L;
    int width = 6;
    int height = 6;
    private boolean allow_hide = false;

    public StatusWindow(JFrame aParent, Component obj, Point p, Color c) {
        this.obj = obj;
        this.point = p;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.panel, new GridBagConstraintsD(-1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 5, 26));
        this.panel.setLayout(new GridBagLayout());
        this.panel.add(obj, new GridBagConstraintsD(-1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 5, 26));
        this.mouseAdapter = new SplashMouseAdapter();
        this.addMouseListener(this.mouseAdapter);
        this.showStatusScreen();
        this.panel.setBorder(this.border);
        this.panel.setBackground(c);
    }

    public void close() {
        this.removeMouseListener(this.mouseAdapter);
        this.setVisible(false);
        this.run_thread = false;
        this.dispose();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.allow_hide = false;
            if (!this.run_thread) {
                this.run_thread = true;
                Thread t = new Thread(new ShowStatusThread());
                t.start();
            }
        } else {
            this.run_thread = false;
            this.setSize(1, 1);
        }
        super.setVisible(b);
        if (!b) {
            super.hide();
        } else {
            this.validate();
            this.invalidate();
        }
    }

    public void hide() {
        if (this.allow_hide) {
            super.hide();
        }
    }

    public void show() {
        super.show();
    }

    public void showStatusScreen() {
        this.setLocation(this.point);
        this.setVisible(true);
    }

    final class SafeSizerThread
    implements Runnable {
        int w = 1;
        int h = 1;
        boolean validate = true;

        SafeSizerThread() {
        }

        public void run() {
            StatusWindow.this.setSize(StatusWindow.this.width, StatusWindow.this.height);
            if (this.validate) {
                StatusWindow.this.invalidate();
                StatusWindow.this.validate();
            }
        }
    }

    final class ShowStatusThread
    implements Runnable {
        private long start_time = 0L;
        private final int wInc = 12;
        private final int hInc = 12;
        private SafeSizerThread sizer = new SafeSizerThread();

        ShowStatusThread() {
        }

        public void run() {
            boolean expand = true;
            while (expand && StatusWindow.this.run_thread) {
                try {
                    Thread.sleep(_sleep);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (StatusWindow.this.width >= ((StatusWindow)StatusWindow.this).size.width && StatusWindow.this.height >= ((StatusWindow)StatusWindow.this).size.height) {
                    expand = false;
                } else {
                    this.expand(false);
                }
                try {
                    Thread.sleep(_sleep);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.expand(true);
            }
            if (StatusWindow.this.run_thread) {
                try {
                    Thread.sleep(StatusWindow.this.display_time);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            boolean collapse = false;
            while (collapse && StatusWindow.this.run_thread) {
                try {
                    Thread.sleep(_sleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StatusWindow.this.width > 5 && StatusWindow.this.height > 5) {
                    this.collapse();
                    continue;
                }
                collapse = false;
            }
            StatusWindow.this.width = 1;
            StatusWindow.this.height = 1;
            SwingUtilities.invokeLater(this.sizer);
            StatusWindow.this.setVisible(false);
            StatusWindow.this.run_thread = false;
        }

        private final void expand(boolean validate) {
            if (StatusWindow.this.width < ((StatusWindow)StatusWindow.this).size.width) {
                StatusWindow.this.width += 12;
            }
            if (StatusWindow.this.height < ((StatusWindow)StatusWindow.this).size.height) {
                StatusWindow.this.height += 12;
            }
            SwingUtilities.invokeLater(this.sizer);
        }

        private final void collapse() {
            if (StatusWindow.this.width > 5) {
                StatusWindow.this.width -= 12;
            }
            if (StatusWindow.this.height > 5) {
                StatusWindow.this.height -= 12;
            }
            SwingUtilities.invokeLater(this.sizer);
        }
    }

    private class SplashMouseAdapter
    extends MouseAdapter {
        private SplashMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            StatusWindow.this.setVisible(false);
        }
    }
}

