/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.sun.im.service.util.PlatformUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.ImageIcon;

public final class SplashScreen
extends Window
implements MouseListener {
    private Image iImage;
    private int iBorderSize;
    private int iImgWidth;
    private int iImgHeight;
    private Color iBorderColor;
    private Frame parent;

    public SplashScreen(Frame aParent, String anImgName, int aBorderSize, Color aBorderColor) {
        super(aParent);
        this.parent = aParent;
        this.loadSplashImage(anImgName);
        this.iBorderSize = aBorderSize;
        this.iBorderColor = aBorderColor;
        this.init();
    }

    public SplashScreen(Frame aParent, Image img, int aBorderSize, Color aBorderColor) {
        super(aParent);
        this.parent = aParent;
        this.iBorderSize = aBorderSize;
        this.iBorderColor = aBorderColor;
        this.iImage = img;
        this.init();
    }

    private final void init() {
        this.showSplashScreen();
        this.requestFocus();
        this.addMouseListener(this);
    }

    public final void mouseClicked(MouseEvent e) {
        this.close();
    }

    public final void mousePressed(MouseEvent e) {
    }

    public final void mouseReleased(MouseEvent e) {
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }

    public final void close() {
        this.setVisible(false);
        this.removeMouseListener(this);
        if (this.iImage != null) {
            this.iImage.flush();
        }
        this.dispose();
        this.parent.dispose();
    }

    public final ImageIcon getIcon(String name) {
        URL u = this.getClass().getResource(name);
        return this.getIcon(u);
    }

    public final ImageIcon getIcon(URL u) {
        if (u == null) {
            System.out.println("Error:  icon not found " + u);
            return null;
        }
        return new ImageIcon(u);
    }

    private final void loadSplashImage(String name) {
        if (PlatformUtil.isJava2()) {
            ImageIcon ico = this.getIcon(name);
            this.iImage = ico.getImage();
        } else {
            this.iImage = Toolkit.getDefaultToolkit().getImage(name);
        }
    }

    private final void showSplashScreen() {
        if (this.iImage == null) {
            return;
        }
        if (this.iBorderColor != null) {
            this.setBackground(this.iBorderColor);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.iImgWidth = this.iImage.getWidth(null);
        this.iImgHeight = this.iImage.getHeight(null);
        int width = this.iImgWidth + this.iBorderSize * 2;
        int height = this.iImgHeight + this.iBorderSize * 2;
        this.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        this.setVisible(true);
    }

    public final void paint(Graphics g) {
        g.drawImage(this.iImage, this.iBorderSize, this.iBorderSize, this.iImgWidth, this.iImgHeight, null);
    }
}

