/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class Spinner
extends JComponent
implements ActionListener {
    JPanel JPanel1 = new JPanel();
    JTextField text = new JTextField(5);
    SpinnerEditor editor;
    protected int maxValue = 100;
    protected int minValue = 0;
    protected int increment = 1;
    private BasicArrowButton upbtn;
    private BasicArrowButton downbtn;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public Spinner() {
        this.setMaxValue(0);
        this.setIncrement(0);
        this.setSize(0, 0);
        this.text.setDocument(new NumberDocument());
        this.setLayout(new BorderLayout(0, 0));
        this.JPanel1.setLayout(new GridLayout(2, 1, 0, 0));
        this.add("East", this.JPanel1);
        this.add("Center", this.text);
        this.upbtn = new BasicArrowButton(1);
        this.upbtn.addActionListener(this);
        this.JPanel1.add(this.upbtn);
        this.downbtn = new BasicArrowButton(5);
        this.downbtn.addActionListener(this);
        this.JPanel1.add(this.downbtn);
    }

    public TableCellEditor getTableCellEditor() {
        if (this.editor == null) {
            this.editor = new SpinnerEditor();
        }
        return this.editor;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getValue() {
        System.out.println("getting spinner value " + this.text.getText());
        return Integer.parseInt(this.text.getText());
    }

    public void setValue(int value) {
        this.text.setText(Integer.toString(value));
    }

    public void actionPerformed(ActionEvent event) {
        int i = this.minValue;
        BasicArrowButton btn = (BasicArrowButton)event.getSource();
        String s = this.text.getText();
        s.trim();
        if (s.length() != 0) {
            i = Integer.parseInt(s);
        }
        i = btn == this.upbtn ? (i += this.increment) : (i -= this.increment);
        if (i >= this.minValue && i <= this.maxValue) {
            this.text.setText(Integer.toString(i));
        }
    }

    public static void main(String[] args) {
        class DriverFrame
        extends Frame {
            public DriverFrame() {
                this.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ DriverFrame this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void windowClosing(WindowEvent event) {
                        this.this$0.dispose();
                        System.exit(0);
                    }
                });
                this.setLayout(new BorderLayout());
                this.setSize(100, 100);
                this.add("Center", new Spinner());
            }
        }
        new DriverFrame().show();
    }

    class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            int i;
            boolean error = false;
            int len = str.length();
            for (i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                error = true;
                break;
            }
            if (!error) {
                StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
                sb.insert(offset, str);
                i = Integer.parseInt(sb.toString());
                if (i < Spinner.this.minValue || i > Spinner.this.maxValue) {
                    error = true;
                }
            }
            if (!error) {
                super.insertString(offset, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class SpinnerEditor
    implements TableCellEditor {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;

        SpinnerEditor() {
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? Spinner.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? Spinner.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int i = 0;
            if (value instanceof String) {
                i = Integer.parseInt((String)value);
            } else if (value instanceof Integer) {
                i = (Integer)value;
            }
            Spinner.this.setValue(i);
            return Spinner.this;
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = Spinner.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            System.out.println("value is " + Spinner.this.getValue());
            return new Integer(Spinner.this.getValue());
        }

        public boolean isCellEditable(EventObject anEvent) {
            return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= 2;
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = Spinner.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }
}

