/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.jni.JNILink;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;

public final class SoundUtility {
    public static boolean USE_STRONG_SOUND = true;

    private static void playWinSound(String file_path) {
        if (USE_STRONG_SOUND) {
            JNILink.playWinSoundStrong(file_path);
        } else {
            JNILink.playWinSound(file_path);
        }
    }

    public static void play(String file_path) {
        if (file_path == null) {
            return;
        }
        SwingUtilities.invokeLater(new PlaySoundRunnable(file_path));
    }

    public static void play(URL u) {
        if (u == null) {
            return;
        }
        SwingUtilities.invokeLater(new PlaySoundRunnable(u));
    }

    private static void playAudioFile(String filename) {
        File f = new File(filename);
        try {
            URL u = f.toURL();
            SoundUtility.playAudioFile(u);
        }
        catch (MalformedURLException e) {
            System.out.println("PlaformUtil.playAudioFile(): exception thrown: " + e);
            return;
        }
    }

    private static void playAudioFile(URL u) {
        if (u == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        AudioClip clip = Applet.newAudioClip(u);
        if (clip != null) {
            clip.play();
            clip = null;
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static class PlaySoundRunnable
    implements Runnable {
        private String file;
        private URL url;

        public PlaySoundRunnable(String f) {
            this.file = f;
        }

        public PlaySoundRunnable(URL u) {
            this.url = u;
        }

        public void run() {
            if (JNILink.USE_WIN_JNI) {
                SoundUtility.playWinSound(this.file);
            } else {
                SoundUtility.playAudioFile(this.url);
            }
        }
    }
}

