/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SameWidthFlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;
    private static final long serialVersionUID = 1L;

    public SameWidthFlowLayout() {
        this(1, 5, 5);
    }

    public SameWidthFlowLayout(int align) {
        this(align, 5, 5);
    }

    public SameWidthFlowLayout(int align, int hgap, int vgap) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension d;
        Component m;
        int i;
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int maxWidth = 0;
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            maxWidth = Math.max(maxWidth, d.width);
        }
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            dim.height = Math.max(dim.height, d.height);
            if (i > 0) {
                dim.width += this.hgap;
            }
            dim.width += maxWidth;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension d;
        Component m;
        int i;
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int maxWidth = 0;
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            maxWidth = Math.max(maxWidth, d.width);
        }
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getMinimumSize();
            dim.height = Math.max(dim.height, d.height);
            if (i > 0) {
                dim.width += this.hgap;
            }
            dim.width += maxWidth;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right + this.hgap * 2;
        dim.height += insets.top + insets.bottom + this.vgap * 2;
        return dim;
    }

    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        switch (this.align) {
            case 0: {
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += width;
            }
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getSize();
            m.setLocation(x, y + (height - d.height) / 2);
            x += this.hgap + d.width;
        }
    }

    public void layoutContainer(Container target) {
        Component m;
        int i;
        Insets insets = target.getInsets();
        Dimension d = target.getSize();
        int maxwidth = d.width - (insets.left + insets.right + this.hgap * 2);
        int nmembers = target.getComponentCount();
        int x = 0;
        int y = insets.top + this.vgap;
        int rowh = 0;
        int start = 0;
        int largestWidth = 0;
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            largestWidth = Math.max(largestWidth, d.width);
        }
        for (i = 0; i < nmembers; ++i) {
            m = target.getComponent(i);
            if (!m.isVisible()) continue;
            d = m.getPreferredSize();
            m.setSize(largestWidth, d.height);
            if (x == 0 || x + largestWidth <= maxwidth) {
                if (x > 0) {
                    x += this.hgap;
                }
                x += largestWidth;
                rowh = Math.max(rowh, d.height);
                continue;
            }
            this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, i);
            x = largestWidth;
            y += this.vgap + rowh;
            rowh = d.height;
            start = i;
        }
        this.moveComponents(target, insets.left + this.hgap, y, maxwidth - x, rowh, start, nmembers);
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

