/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SaveUrlRunnable;
import com.sun.im.service.util.HTMLDocumentLoader;
import com.sun.im.service.util.HtmlUtility;
import com.sun.im.service.util.Worker;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JEditorPane;

public final class NetUtility {
    public static final void setPageEx(JEditorPane txt, String url) {
        try {
            NetUtility.setPageEx(txt, new URL(url));
        }
        catch (Exception e) {
            txt.setText(e.toString());
            System.out.println("setPageEx:" + e);
        }
    }

    public static final void setPageEx(JEditorPane txt, URL url) {
        try {
            if (EditorUtility.documentLoader == null) {
                EditorUtility.documentLoader = new HTMLDocumentLoader();
            }
            txt.setDocument(EditorUtility.documentLoader.loadDocument(url));
        }
        catch (Exception e) {
            txt.setText(e.toString());
            System.out.println("setPageEx:" + e);
        }
    }

    public static final void setPage(JEditorPane txt, String url) {
        try {
            NetUtility.setPage(txt, new URL(url));
        }
        catch (Exception e) {
            txt.setText(e.toString());
            System.out.println("setPage:" + e);
        }
    }

    public static final void setPage(JEditorPane txt, URL url) {
        try {
            txt.setPage(url);
        }
        catch (Exception e) {
            String msg = "Error Loading URL ";
            StringBuffer ret = new StringBuffer("<html><body>");
            ret.append(HtmlUtility.getFontColor((int)2, (String)"2"));
            ret.append("<b>");
            ret.append("Error Loading URL ");
            ret.append(url.toString());
            ret.append("</b>");
            ret.append("<br>");
            ret.append("</font>");
            ret.append(e);
            ret.append("</body></html>");
            txt.setText(ret.toString());
        }
    }

    public static final URL createUrl(String s) {
        try {
            return new URL(s);
        }
        catch (Exception e) {
            System.out.println("createUrl:" + e);
            return null;
        }
    }

    public static final byte[] loadUrl(String url, boolean use_cache) {
        URL u = NetUtility.createUrl(url);
        return NetUtility.loadUrlBytes(u, use_cache);
    }

    public static final byte[] loadUrlBytes(URL u, boolean use_cache) {
        int bytesread = 0;
        int cache_size = 1024;
        byte[] b = new byte[cache_size];
        if (u == null) {
            return b;
        }
        try {
            URLConnection uc = u.openConnection();
            uc.setUseCaches(use_cache);
            InputStream infile = uc.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (bytesread >= 0 && (bytesread = infile.read(b, 0, cache_size)) != -1) {
                out.write(b, 0, bytesread);
            }
            infile.close();
            b = out.toByteArray();
            out.close();
        }
        catch (Exception e) {
            System.out.println("loadUrlBytes:" + e);
        }
        return b;
    }

    public static final void SaveUrl(String lnk, String pth, boolean use_cache, Worker w) {
        if (w != null) {
            w.addRunnable((Runnable)new SaveUrlRunnable(lnk, pth, use_cache));
        } else {
            EditorUtility.save(new File(pth), NetUtility.loadUrl(lnk, use_cache));
        }
    }

    public static final String getUrlFileName(URL u) {
        String s = u.getFile();
        return s.substring(s.lastIndexOf("/") + 1, s.length());
    }

    public static final boolean isImageUrl(URL u) {
        return NetUtility.isImageUrl(u.getFile());
    }

    public static final boolean isImageUrl(String s) {
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif");
    }
}

