/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ImageView
extends View
implements ImageObserver,
MouseListener,
MouseMotionListener {
    public static final String TOP = "top";
    public static final String TEXTTOP = "texttop";
    public static final String MIDDLE = "middle";
    public static final String ABSMIDDLE = "absmiddle";
    public static final String CENTER = "center";
    public static final String BOTTOM = "bottom";
    private static boolean sIsInc = true;
    private static int sIncRate = 100;
    private AttributeSet attr;
    private Element fElement;
    private Image fImage;
    private int fHeight;
    private int fWidth;
    private Container fContainer;
    private Rectangle fBounds = new Rectangle();
    private Component fComponent;
    private Point fGrowBase;
    private boolean fGrowProportionally;
    private boolean loading;
    private boolean isLink;
    private int border;
    private int xSpace;
    private int ySpace;
    private static Icon sPendingImageIcon;
    private static Icon sMissingImageIcon;
    private static final String PENDING_IMAGE_SRC = "icons/image-delayed.gif";
    private static final String MISSING_IMAGE_SRC = "icons/image-failed.gif";
    private static final boolean DEBUG = false;
    static final String IMAGE_CACHE_PROPERTY = "imageCache";
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    private static final int DEFAULT_BORDER = 2;

    public ImageView(Element elem) {
        super(elem);
        this.initialize(elem);
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Element elem) {
        ImageView imageView;
        ImageView imageView2 = this;
        synchronized (imageView2) {
            this.loading = true;
            this.fHeight = 0;
            this.fWidth = 0;
        }
        int width = 0;
        int height = 0;
        boolean customWidth = false;
        boolean customHeight = false;
        try {
            this.fElement = elem;
            AttributeSet attr = elem.getAttributes();
            AttributeSet anchorAttr = (AttributeSet)attr.getAttribute(HTML.Tag.A);
            this.isLink = anchorAttr != null && anchorAttr.isDefined(HTML.Attribute.HREF);
            this.border = this.getIntAttr(HTML.Attribute.BORDER, this.isLink() ? 2 : 0);
            this.xSpace = this.getIntAttr(HTML.Attribute.HSPACE, 0);
            this.ySpace = this.getIntAttr(HTML.Attribute.VSPACE, 0);
            URL src = this.getSourceURL();
            if (src != null) {
                Dictionary cache = (Dictionary)this.getDocument().getProperty(IMAGE_CACHE_PROPERTY);
                if (cache != null) {
                    this.fImage = (Image)cache.get(src);
                }
                if (this.fImage == null) {
                    this.fImage = Toolkit.getDefaultToolkit().getImage(src);
                }
            }
            boolean bl = customHeight = (height = this.getIntAttr(HTML.Attribute.HEIGHT, -1)) > 0;
            if (!customHeight && this.fImage != null) {
                height = this.fImage.getHeight(this);
            }
            if (height <= 0) {
                height = 32;
            }
            boolean bl2 = customWidth = (width = this.getIntAttr(HTML.Attribute.WIDTH, -1)) > 0;
            if (!customWidth && this.fImage != null) {
                width = this.fImage.getWidth(this);
            }
            if (width <= 0) {
                width = 32;
            }
            if (this.fImage != null) {
                if (customWidth && customHeight) {
                    Toolkit.getDefaultToolkit().prepareImage(this.fImage, height, width, this);
                } else {
                    Toolkit.getDefaultToolkit().prepareImage(this.fImage, -1, -1, this);
                }
            }
            Object var11_12 = null;
            imageView = this;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            ImageView imageView3 = this;
            synchronized (imageView3) {
                this.loading = false;
                if (customWidth || this.fWidth == 0) {
                    this.fWidth = width;
                }
                if (customHeight || this.fHeight == 0) {
                    this.fHeight = height;
                }
            }
            throw throwable;
        }
        synchronized (imageView) {
            this.loading = false;
            if (customWidth || this.fWidth == 0) {
                this.fWidth = width;
            }
            if (customHeight || this.fHeight == 0) {
                this.fHeight = height;
            }
        }
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    boolean isLink() {
        return this.isLink;
    }

    int getBorder() {
        return this.border;
    }

    int getSpace(int axis) {
        if (axis == 0) {
            return this.xSpace;
        }
        return this.ySpace;
    }

    Color getBorderColor() {
        StyledDocument doc = (StyledDocument)this.getDocument();
        return doc.getForeground(this.getAttributes());
    }

    boolean hasPixels(ImageObserver obs) {
        return this.fImage != null && this.fImage.getHeight(obs) > 0 && this.fImage.getWidth(obs) > 0;
    }

    private URL getSourceURL() {
        String src = (String)this.fElement.getAttributes().getAttribute(HTML.Attribute.SRC);
        if (src == null) {
            return null;
        }
        URL reference = ((HTMLDocument)this.getDocument()).getBase();
        try {
            URL u = new URL(reference, src);
            return u;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private int getIntAttr(HTML.Attribute name, int deflt) {
        AttributeSet attr = this.fElement.getAttributes();
        if (attr.isDefined(name)) {
            int i;
            String val = (String)attr.getAttribute(name);
            if (val == null) {
                i = deflt;
            } else {
                try {
                    i = Math.max(0, Integer.parseInt(val));
                }
                catch (NumberFormatException x) {
                    i = deflt;
                }
            }
            return i;
        }
        return deflt;
    }

    public void setParent(View parent) {
        super.setParent(parent);
        Container container = this.fContainer = parent != null ? this.getContainer() : null;
        if (parent == null && this.fComponent != null) {
            this.fComponent.getParent().remove(this.fComponent);
            this.fComponent = null;
        }
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        boolean wChanged;
        super.changedUpdate(e, a, f);
        int height = this.fHeight;
        int width = this.fWidth;
        this.initialize(this.getElement());
        boolean hChanged = this.fHeight != height;
        boolean bl = wChanged = this.fWidth != width;
        if (hChanged || wChanged) {
            this.preferenceChanged(null, hChanged, wChanged);
        }
    }

    public void paint(Graphics g, Shape a) {
        Color oldColor = g.getColor();
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.fBounds.setBounds(alloc);
        int border = this.getBorder();
        int x = this.fBounds.x + border + this.getSpace(0);
        int y = this.fBounds.y + border + this.getSpace(1);
        int width = this.fWidth;
        int height = this.fHeight;
        int sel = this.getSelectionState();
        if (!this.hasPixels(this)) {
            Icon icon;
            g.setColor(Color.lightGray);
            g.drawRect(x, y, width - 1, height - 1);
            g.setColor(oldColor);
            this.loadIcons();
            Icon icon2 = icon = this.fImage == null ? sMissingImageIcon : sPendingImageIcon;
            if (icon != null) {
                icon.paintIcon(this.getContainer(), g, x, y);
            }
        }
        if (this.fImage != null) {
            g.drawImage(this.fImage, x, y, width, height, this);
        }
        Color bc = this.getBorderColor();
        if (sel == 2) {
            int delta = 2 - border;
            if (delta > 0) {
                x += delta;
                y += delta;
                width -= delta << 1;
                height -= delta << 1;
                border = 2;
            }
            bc = null;
            g.setColor(Color.black);
            g.fillRect(x + width - 5, y + height - 5, 5, 5);
        }
        if (border > 0) {
            if (bc != null) {
                g.setColor(bc);
            }
            for (int i = 1; i <= border; ++i) {
                g.drawRect(x - i, y - i, width - 1 + i + i, height - 1 + i + i);
            }
            g.setColor(oldColor);
        }
    }

    protected void repaint(long delay) {
        if (this.fContainer != null && this.fBounds != null) {
            this.fContainer.repaint(delay, this.fBounds.x, this.fBounds.y, this.fBounds.width, this.fBounds.height);
        }
    }

    protected int getSelectionState() {
        int p0 = this.fElement.getStartOffset();
        int p1 = this.fElement.getEndOffset();
        if (this.fContainer instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)this.fContainer;
            int start = textComp.getSelectionStart();
            int end = textComp.getSelectionEnd();
            if (start <= p0 && end >= p1) {
                if (start == p0 && end == p1 && this.isEditable()) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    protected boolean isEditable() {
        return this.fContainer instanceof JEditorPane && ((JEditorPane)this.fContainer).isEditable();
    }

    protected Color getHighlightColor() {
        JTextComponent textComp = (JTextComponent)this.fContainer;
        return textComp.getSelectionColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if (this.fImage == null || this.fImage != img) {
            return false;
        }
        if ((flags & 0xC0) != 0) {
            this.fImage = null;
            this.repaint(0L);
            return false;
        }
        short changed = 0;
        if ((flags & 2) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.HEIGHT)) {
            changed = (short)(changed | 1);
        }
        if ((flags & 1) != 0 && !this.getElement().getAttributes().isDefined(HTML.Attribute.WIDTH)) {
            changed = (short)(changed | 2);
        }
        ImageView imageView = this;
        synchronized (imageView) {
            if ((changed & 1) == 1) {
                this.fWidth = width;
            }
            if ((changed & 2) == 2) {
                this.fHeight = height;
            }
            if (this.loading) {
                return true;
            }
        }
        if (changed != 0) {
            Document doc = this.getDocument();
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readLock();
                }
                this.preferenceChanged(null, true, true);
            }
            finally {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).readUnlock();
                }
            }
            return true;
        }
        if ((flags & 0x30) != 0) {
            this.repaint(0L);
        } else if ((flags & 8) != 0 && sIsInc) {
            this.repaint(sIncRate);
        }
        return (flags & 0x20) == 0;
    }

    public float getPreferredSpan(int axis) {
        int extra = 2 * (this.getBorder() + this.getSpace(axis));
        switch (axis) {
            case 0: {
                return this.fWidth + extra;
            }
            case 1: {
                return this.fHeight + extra;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(axis);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public void setSize(float width, float height) {
    }

    protected void resize(int width, int height) {
        if (width == this.fWidth && height == this.fHeight) {
            return;
        }
        this.fWidth = width;
        this.fHeight = height;
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(HTML.Attribute.WIDTH, Integer.toString(width));
        attr.addAttribute(HTML.Attribute.HEIGHT, Integer.toString(height));
        ((StyledDocument)this.getDocument()).setCharacterAttributes(this.fElement.getStartOffset(), this.fElement.getEndOffset(), attr, false);
    }

    public void mousePressed(MouseEvent e) {
        Dimension size = this.fComponent.getSize();
        if (e.getX() >= size.width - 7 && e.getY() >= size.height - 7 && this.getSelectionState() == 2) {
            Point loc = this.fComponent.getLocationOnScreen();
            this.fGrowBase = new Point(loc.x + e.getX() - this.fWidth, loc.y + e.getY() - this.fHeight);
            this.fGrowProportionally = e.isShiftDown();
        } else {
            this.fGrowBase = null;
            JTextComponent comp = (JTextComponent)this.fContainer;
            int start = this.fElement.getStartOffset();
            int end = this.fElement.getEndOffset();
            int mark = comp.getCaret().getMark();
            int dot = comp.getCaret().getDot();
            if (e.isShiftDown()) {
                if (mark <= start) {
                    comp.moveCaretPosition(end);
                } else {
                    comp.moveCaretPosition(start);
                }
            } else {
                if (mark != start) {
                    comp.setCaretPosition(start);
                }
                if (dot != end) {
                    comp.moveCaretPosition(end);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.fGrowBase != null) {
            Point loc = this.fComponent.getLocationOnScreen();
            int width = Math.max(2, loc.x + e.getX() - this.fGrowBase.x);
            int height = Math.max(2, loc.y + e.getY() - this.fGrowBase.y);
            if (e.isShiftDown() && this.fImage != null) {
                float imgWidth = this.fImage.getWidth(this);
                float imgHeight = this.fImage.getHeight(this);
                if (imgWidth > 0.0f && imgHeight > 0.0f) {
                    float prop = imgHeight / imgWidth;
                    float pwidth = (float)height / prop;
                    float pheight = (float)width * prop;
                    if (pwidth > (float)width) {
                        width = (int)pwidth;
                    } else {
                        height = (int)pheight;
                    }
                }
            }
            this.resize(width, height);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.fGrowBase = null;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private Icon makeIcon(String gifFile) throws IOException {
        int n;
        InputStream resource = ImageView.class.getResourceAsStream(gifFile);
        if (resource == null) {
            System.err.println(ImageView.class.getName() + "/" + gifFile + " not found.");
            return null;
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.flush();
        buffer = out.toByteArray();
        if (buffer.length == 0) {
            System.err.println("warning: " + gifFile + " is zero-length");
            return null;
        }
        return new ImageIcon(buffer);
    }

    private void loadIcons() {
        try {
            if (sPendingImageIcon == null) {
                sPendingImageIcon = this.makeIcon(PENDING_IMAGE_SRC);
            }
            if (sMissingImageIcon == null) {
                sMissingImageIcon = this.makeIcon(MISSING_IMAGE_SRC);
            }
        }
        catch (Exception x) {
            System.err.println("ImageView: Couldn't load image icons");
        }
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }
}

