/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image m_image = null;
    boolean bResize = true;

    public ImagePanel(Image image) {
        this.m_image = image;
    }

    public void setImage(Image img) {
        this.m_image = img;
        this.setSize(this.m_image.getWidth(this), this.m_image.getHeight(this));
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(25, 25);
        if (this.m_image != null) {
            d.width = Math.max(0, this.m_image.getWidth(this));
            d.height = Math.max(0, this.m_image.getHeight(this));
        }
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void update(Graphics g) {
        if (this.m_image == null) {
            String msg = "Image Was Not Found!";
            g.drawString(msg, 10, 10);
        } else {
            int width = this.m_image.getWidth(this);
            int height = this.m_image.getHeight(this);
            int x = 0;
            int y = 0;
            if (this.bResize && width >= 0 && height >= 0) {
                this.setSize(width, height);
                this.bResize = false;
            }
            g.drawImage(this.m_image, x + 24, y + 24, this.m_image.getWidth(this) - 4, this.m_image.getHeight(this) - 4, this);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }
}

