/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public final class ImageLabel
extends JLabel {
    private ImageIcon icon;
    private int winc = 0;
    private int hinc = 0;
    public boolean center = false;

    public ImageLabel(ImageIcon image) {
        this.icon = image;
        this.winc = this.icon.getIconWidth();
        this.hinc = this.icon.getIconHeight();
    }

    public final void setimage(ImageIcon i) {
        this.icon = i;
    }

    public final void paintComponentFill(Graphics g) {
        Dimension dim = this.getParent().getSize();
        for (int i = 0; i < dim.height + this.hinc; i += this.hinc) {
            for (int j = 0; j < dim.width + this.winc; j += this.winc) {
                this.icon.paintIcon(this, g, j, i);
            }
        }
    }

    public final void paintComponentCenter(Graphics g) {
        Dimension dOut = this.getParent().getSize();
        this.icon.paintIcon(this, g, (dOut.width - this.winc) / 2, (dOut.height - this.hinc) / 2);
    }

    public final void paintComponent(Graphics g) {
        if (this.center) {
            this.paintComponentCenter(g);
        } else {
            this.paintComponentFill(g);
        }
    }

    public final Dimension getPreferredSize() {
        return new Dimension(super.getSize());
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

