/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.HTMLFactoryX;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.text.StyleContext;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class IMHTMLEditorKit
extends HTMLEditorKit {
    private static ViewFactory _HTMLFactory = new HTMLFactoryX();

    public IMHTMLEditorKit() {
        URL styleSheetURL;
        StyleSheet styleSheet = this.getStyleSheet();
        String marginTopAttribute = "margin-top";
        String fontFamilyAttribute = "font-family";
        StyleContext.NamedStyle pStyle = (StyleContext.NamedStyle)styleSheet.getStyle("p");
        if (pStyle != null) {
            Enumeration<?> enames = pStyle.getAttributeNames();
            while (enames.hasMoreElements()) {
                Object thisobject = enames.nextElement();
                if (marginTopAttribute.compareTo(thisobject.toString()) != 0) continue;
                pStyle.removeAttribute(thisobject);
            }
        }
        if ((styleSheetURL = this.getClass().getResource("/com/sun/im/desktop/brand/chat-styles.css")) == null) {
            styleSheetURL = this.getClass().getResource("/com/sun/im/desktop/default/brand/chat-styles.css");
        }
        if (styleSheetURL != null) {
            StyleSheet tmpStyleSheet = new StyleSheet();
            tmpStyleSheet.importStyleSheet(styleSheetURL);
            styleSheet.addStyleSheet(tmpStyleSheet);
        } else {
            System.err.println("IMHTMLEditorKit.<init>: Could not load stylesheet");
        }
        this.setStyleSheet(styleSheet);
    }

    public ViewFactory getViewFactory() {
        return _HTMLFactory;
    }

    public static class InsertBreakAction
    extends HTMLEditorKit.HTMLTextAction {
        public InsertBreakAction() {
            super("insert-br");
        }

        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                int carPos = editor.getCaretPosition();
                try {
                    ((HTMLEditorKit)editor.getEditorKit()).insertHTML((HTMLDocument)editor.getDocument(), carPos, "<br>", 0, 0, HTML.Tag.BR);
                    editor.setCaretPosition(carPos + 1);
                }
                catch (Exception x) {
                    System.out.println("IMHTMLEditorKit.InsertBreakAction.actionPerformed: Exception thrown: " + x);
                }
            }
        }
    }
}

