/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.MinSBHtmlWriter;
import com.iplanet.im.client.util.SBHtmlWriter;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.HTMLDocumentLoader;
import com.sun.im.service.util.ImageDictionary;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLDocument;

public class EditorUtility {
    public static HTMLDocumentLoader documentLoader;
    public static ImageDictionary _dic;
    private static SafeResourceBundle _bundle;
    static final String ID_GETTEXT_ERROR = "** Error parsing text - Document may have been corrupted **";

    public static void writeString(File file, String s) {
        FileUtility.writeString((File)file, (String)s);
    }

    public static final void save(String path, String s, Worker w) {
        FileUtility.save((File)new File(path), (String)s, (Worker)w);
    }

    public static void save(File file, String s, Worker w) {
        FileUtility.save((File)file, (String)s, (Worker)w);
    }

    public static void saveImage(File file, BufferedImage img, float quality, boolean forceBaseLine) {
        if (file == null) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            JPEGImageEncoder enc = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = enc.getDefaultJPEGEncodeParam(img);
            param.setQuality(quality, forceBaseLine);
            enc.setJPEGEncodeParam(param);
            enc.encode(img);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.out.println("saveImage:" + e);
        }
    }

    public static final void save(String path, byte[] b) {
        FileUtility.save((File)new File(path), (byte[])b);
    }

    public static final void save(File file, byte[] b) {
        FileUtility.save((File)file, (byte[])b);
    }

    public static final void saveObject(File file, Object o) {
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fo = new FileOutputStream(file);
            ObjectOutputStream out = new ObjectOutputStream(fo);
            out.writeObject(o);
            out.flush();
            fo.close();
            out.close();
        }
        catch (Exception e) {
            System.out.println("saveObject:" + e);
        }
    }

    public static final Object loadObject(File file) {
        if (file == null) {
            return null;
        }
        Object o = null;
        try {
            FileInputStream fi = new FileInputStream(file);
            ObjectInputStream in = new ObjectInputStream(fi);
            o = in.readObject();
            fi.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println("loadObject:" + e);
        }
        return o;
    }

    public static final byte[] loadByte(JFrame frame, String path) {
        return EditorUtility.loadByte(frame, new File(path));
    }

    public static final byte[] loadByte(JFrame frame, File file) {
        byte[] filebytes = new byte[(int)file.length()];
        EditorUtility.loadByte(frame, file, filebytes);
        return filebytes;
    }

    public static void loadByte(JFrame frame, File file, byte[] filebytes) {
        block2: {
            try {
                FileInputStream stream = new FileInputStream(file);
                stream.read(filebytes);
                stream.close();
            }
            catch (IOException e) {
                System.out.println("loadByte:" + e);
                if (frame == null) break block2;
                String str = StringUtility.substitute((String)_bundle.getString("EditorUtility_not_found"), (String)"__MACRO__", (String)file.getName());
                JOptionPane.showMessageDialog(frame, str);
            }
        }
    }

    public static final String loadString(JFrame frame, String path) {
        File file = new File(path);
        String s = EditorUtility.loadString(frame, file);
        return s;
    }

    public static String loadString(JFrame frame, File file) {
        String s;
        block3: {
            s = "";
            String temp = "";
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                s = in.readLine();
                while (s != null && temp != null && (temp = in.readLine()) != null) {
                    s = s + temp;
                }
                in.close();
            }
            catch (Exception e) {
                System.out.println("loadString:" + e);
                if (frame == null) break block3;
                JOptionPane.showMessageDialog(frame, e);
            }
        }
        return s;
    }

    public static final void viewSource(String s, String title) {
        JFrame frm = new JFrame(title);
        frm.setBounds(0, 0, 500, 300);
        JEditorPane txt = new JEditorPane();
        txt.setBounds(10, 10, 250, 100);
        JScrollPane scroll = new JScrollPane(txt, 20, 30);
        frm.getContentPane().setLayout(new BorderLayout(0, 0));
        frm.getContentPane().add("Center", scroll);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
        txt.setEditable(false);
        txt.setText(s);
        txt.select(0, 0);
    }

    public static final void setFontFamily(JTextPane txt, String fnt) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, fnt);
        txt.setCharacterAttributes(attr, false);
    }

    public static final void setFontSize(JTextPane txt, int size) {
        MutableAttributeSet attr = txt.getInputAttributes();
        StyleConstants.setFontSize(attr, size);
        txt.setCharacterAttributes(attr, false);
    }

    public static final void setFontColor(JTextPane txt, Color c) {
        MutableAttributeSet attr = txt.getInputAttributes();
        StyleConstants.setForeground(attr, c);
        txt.setCharacterAttributes(attr, false);
    }

    public static final void setTextUnderline(JTextPane txt, boolean underline) {
        MutableAttributeSet attr = txt.getInputAttributes();
        StyleConstants.setUnderline(attr, underline);
        txt.setCharacterAttributes(attr, false);
    }

    public static final void setTextBold(JTextPane txt, boolean bold) {
        MutableAttributeSet attr = txt.getInputAttributes();
        StyleConstants.setBold(attr, bold);
        txt.setCharacterAttributes(attr, false);
    }

    public static final void setTextItalic(JTextPane txt, boolean italic) {
        MutableAttributeSet attr = txt.getInputAttributes();
        StyleConstants.setItalic(attr, italic);
        txt.setCharacterAttributes(attr, false);
    }

    public static final AttributeSet getCaretAttributes(JTextPane txt, int pos) {
        if (--pos < 0) {
            pos = txt.getCaretPosition();
        }
        AttributeSet a = pos == txt.getStyledDocument().getLength() ? txt.getInputAttributes() : txt.getStyledDocument().getCharacterElement(pos).getAttributes();
        return a;
    }

    public static final String getCaretFontFamily(JTextPane txt, int pos) {
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.getFontFamily(a);
    }

    public static final String getCurrentCaretFontFamily(JTextPane txt) {
        return EditorUtility.getCaretFontFamily(txt, txt.getCaretPosition());
    }

    public static final int getCaretFontSize(JTextPane txt, int pos) {
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.getFontSize(a);
    }

    public static final int getCurrentCaretFontSize(JTextPane txt) {
        return EditorUtility.getCaretFontSize(txt, txt.getCaretPosition());
    }

    public static final Color getCaretFontColor(JTextPane txt, int pos) {
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.getForeground(a);
    }

    public static final Color getCurrentCaretFontColor(JTextPane txt) {
        return EditorUtility.getCaretFontColor(txt, txt.getCaretPosition());
    }

    public static final boolean isCaretUnderline(JTextPane txt, int pos) {
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.isUnderline(a);
    }

    public static final boolean isCurrentCaretUnderline(JTextPane txt) {
        return EditorUtility.isCaretUnderline(txt, txt.getCaretPosition());
    }

    public static final boolean isCaretItalic(JTextPane txt, int pos) {
        if (pos < 0) {
            pos = txt.getCaretPosition();
        }
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.isItalic(a);
    }

    public static final boolean isCurrentCaretItalic(JTextPane txt) {
        return EditorUtility.isCaretItalic(txt, txt.getCaretPosition());
    }

    public static final boolean isCaretBold(JTextPane txt, int pos) {
        AttributeSet a = EditorUtility.getCaretAttributes(txt, pos);
        return StyleConstants.isBold(a);
    }

    public static final boolean isCurrentCaretBold(JTextPane txt) {
        return EditorUtility.isCaretBold(txt, txt.getCaretPosition());
    }

    public static final void appendToDocument(String text, JEditorPane pane) {
        EditorUtility.insertDocumentText(-1, text, pane, false);
    }

    public static final void insertDocumentText(int pos, String text, JEditorPane txt, boolean overwrite) {
        if (overwrite) {
            txt.setDocument(txt.getEditorKit().createDefaultDocument());
        }
        try {
            Document doc = txt.getDocument();
            if (pos < 0) {
                pos = doc.getLength();
            }
            BufferedReader bufin = new BufferedReader(new StringReader(text));
            txt.getEditorKit().read(bufin, doc, pos);
            bufin.close();
            txt.getParent().repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("insertDocumentText:" + e);
        }
    }

    public static final void overwriteHtmlDocumentText(HTMLDocument d, String text, JEditorPane txt, boolean threaded, boolean cache) {
        threaded = false;
        if (!threaded) {
            try {
                if (documentLoader == null) {
                    documentLoader = new HTMLDocumentLoader();
                }
                if (d == null) {
                    txt.setDocument(documentLoader.loadDocument(text));
                } else {
                    txt.setDocument(documentLoader.loadDocument(d, text, cache));
                }
            }
            catch (Exception e) {
                System.out.println("overwriteHtmlDocumentText:" + e);
            }
        }
    }

    public static final String getHtmlDocumentText(JEditorPane txtPane) {
        try {
            StringWriter w = new StringWriter();
            BufferedWriter bw = new BufferedWriter(w);
            SBHtmlWriter hw = new SBHtmlWriter((Writer)bw, (HTMLDocument)txtPane.getDocument());
            hw.write();
            bw.close();
            w.close();
            return w.toString();
        }
        catch (Exception e) {
            System.out.println("EditorUtility.getHtmlDocumentText(): " + e);
            return ID_GETTEXT_ERROR;
        }
    }

    public static final String getHtmlDocumentBody(JEditorPane txtPane) {
        try {
            StringWriter w = new StringWriter();
            BufferedWriter bw = new BufferedWriter(w);
            MinSBHtmlWriter hw = new MinSBHtmlWriter((Writer)bw, (HTMLDocument)txtPane.getDocument());
            hw.write();
            bw.close();
            w.close();
            return w.toString();
        }
        catch (Exception e) {
            System.out.println("getHtmlDocumentBody:" + e);
            return ID_GETTEXT_ERROR;
        }
    }

    public static final void removeHtmlStartTags(JEditorPane txtMessage) {
        if (!PlatformUtil.isJDK1_1() && !PlatformUtil.isJDK1_2()) {
            return;
        }
        try {
            txtMessage.setSelectionStart(0);
            txtMessage.setSelectionEnd(3);
            txtMessage.replaceSelection("");
        }
        catch (Exception e) {
            System.out.println("removeHtmlStartTags:" + e);
        }
    }

    public static final String getDocumentText(int pos, JEditorPane txtPane) {
        String tmp = ID_GETTEXT_ERROR;
        try {
            StringWriter writer = new StringWriter();
            BufferedWriter buf = new BufferedWriter(writer);
            txtPane.getEditorKit().write(buf, txtPane.getDocument(), pos, txtPane.getDocument().getLength());
            buf.close();
            writer.close();
            tmp = writer.toString();
        }
        catch (Exception e) {
            System.out.println("getDocumentText:" + e);
        }
        return tmp;
    }

    public static final Object[] parseHtmlDocument(HTMLDocument doc, Object tag, Object attrib) {
        Element elem = doc.getDefaultRootElement();
        ElementIterator iter = new ElementIterator(elem);
        Vector<Object> data = new Vector<Object>();
        while ((elem = iter.next()) != null) {
            Object result;
            AttributeSet as = elem.getAttributes();
            Object o = as.getAttribute(tag);
            if (o == null || !(o instanceof AttributeSet) || (result = ((AttributeSet)o).getAttribute(attrib)) == null) continue;
            data.addElement(result);
        }
        Object[] objects = new Object[data.size()];
        data.copyInto(objects);
        data = null;
        return objects;
    }

    public static final void clearDir(File dir, Date delete) {
        if (dir.isDirectory()) {
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                File temp = new File(dir, list[i]);
                if (temp.isDirectory()) continue;
                if (delete == null) {
                    temp.delete();
                    continue;
                }
                Date d = new Date(temp.lastModified());
                if (!d.before(delete)) continue;
                temp.delete();
            }
        }
    }

    public static final String formatLongString(String fname) {
        fname = fname.replace('.', '_');
        fname = fname.replace(' ', '_');
        fname = fname.replace('$', '_');
        fname = fname.replace('@', '_');
        fname = fname.replace('%', '_');
        fname = fname.replace(':', '_');
        if (PlatformUtil.isOS2() && fname.length() > 8) {
            fname = fname.substring(0, 8);
        }
        return fname;
    }

    public static final File formatFileName(String dir, String fname, String extension, boolean use_short) {
        fname = fname.replace('.', '_');
        fname = fname.replace(':', '_');
        if (use_short) {
            fname = EditorUtility.formatLongString(fname);
        }
        int n = 0;
        StringBuffer buf = new StringBuffer(dir);
        if (!dir.endsWith(File.separator)) {
            buf.append(File.separator);
        }
        buf.append(fname);
        buf.append(extension);
        File f = new File(buf.toString());
        while (f.exists()) {
            ++n;
            if (fname.length() > 6) {
                fname = fname.substring(0, 6);
            }
            buf = new StringBuffer(dir);
            if (!dir.endsWith(File.separator)) {
                buf.append(File.separator);
            }
            buf.append(fname);
            buf.append(n);
            buf.append(extension);
            f = new File(buf.toString());
            buf = null;
            if (n <= 99) continue;
            return f;
        }
        return f;
    }

    public static final void installEnterBinding(JTextComponent component) {
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        String noEnter = "ENTER_Binding_Removed";
        Keymap map = JTextComponent.getKeymap("ENTER_Binding_Removed");
        if (map == null) {
            map = JTextComponent.addKeymap("ENTER_Binding_Removed", component.getKeymap());
            map.addActionForKeyStroke(enter, new TextAction("ENTER_Binding_Removed"){

                public void actionPerformed(ActionEvent e) {
                    JTextComponent text = (JTextComponent)e.getSource();
                    JButton button = SwingUtilities.getRootPane(text).getDefaultButton();
                    if (button != null) {
                        button.doClick();
                    }
                }
            });
        }
        component.setKeymap(map);
    }

    static {
        _dic = new ImageDictionary();
        _bundle = new SafeResourceBundle("com.iplanet.im.client.util.util");
    }
}

