/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.io.IOException;
import java.io.Writer;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DocumentWriter
extends Writer {
    private Document doc;
    private AttributeSet a;
    private int length = 0;

    public DocumentWriter(Document doc, AttributeSet a, int length) {
        this.doc = doc;
        this.a = a;
        this.length = length;
    }

    public DocumentWriter(Document doc) {
        this(doc, null, 0);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, len));
    }

    public void write(String str) throws IOException {
        if (this.doc == null) {
            throw new IOException("Writer was closed");
        }
        SwingUtilities.invokeLater(new Later(str));
    }

    public void flush() throws IOException {
        if (this.doc == null) {
            throw new IOException("Writer was closed");
        }
    }

    public void close() throws IOException {
        this.doc = null;
    }

    class Later
    implements Runnable {
        String str;

        Later(String s) {
            this.str = s;
        }

        public void run() {
            try {
                if (DocumentWriter.this.length != 0 && DocumentWriter.this.doc.getLength() > DocumentWriter.this.length) {
                    try {
                        DocumentWriter.this.doc.remove(0, DocumentWriter.this.doc.getLength() - DocumentWriter.this.length);
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
                try {
                    DocumentWriter.this.doc.insertString(DocumentWriter.this.doc.getLength(), this.str, DocumentWriter.this.a);
                }
                catch (BadLocationException ble) {
                    throw new IOException(ble.getMessage());
                }
            }
            catch (Exception e) {
                System.out.println("DocumentOutput Exception " + e);
            }
        }
    }
}

