/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DialogButtonsPanel
extends JPanel {
    public static final int ID_OK_LABEL = 1;
    public static final int ID_SEND_LABEL = 2;
    public static final int ID_ADD_CONTACTS_LABEL = 3;
    public static final int ID_CLOSE_LABEL = 4;
    public static final int ID_APPLY_CHANGES_LABEL = 5;
    public static final int ID_ADD_ROOMS_LABEL = 6;
    public static final String ID_APPLY_ACTION_COMMAND = "apply";
    public static final String ID_OK_ACTION_COMMAND = "ok";
    public static final String ID_CANCEL_ACTION_COMMAND = "cancel";
    public static final String ID_HELP_ACTION_COMMAND = "help";
    public static final int ID_APPLY = 8;
    public static final int ID_OK = 4;
    public static final int ID_CANCEL = 2;
    public static final int ID_HELP = 1;
    public static final int ID_ALL = 15;
    public static final int ID_OK_CANCEL = 6;
    private static SafeResourceBundle _bundle = new SafeResourceBundle("com.iplanet.im.client.util.util");
    private ActionListener _listener = null;
    private int _buttonMask = 7;
    JPanel pnlButtons = null;
    JButton btnApply = new JButton();
    JButton btnOk = new JButton();
    JButton btnCancel = new JButton();
    JButton btnClose = new JButton();
    JButton btnHelp = new JButton();

    public DialogButtonsPanel(ActionListener listener, int buttonMask) {
        this._listener = listener;
        this._buttonMask = buttonMask;
        this.initComponents();
    }

    public DialogButtonsPanel(ActionListener listener) {
        this(listener, 7);
    }

    private void setButton(JButton button, String labelKey, String mnemonicKey, String actionCommand) {
        SwingUtils.setupButton(button, _bundle, labelKey, mnemonicKey, null, null);
        button.setActionCommand(actionCommand);
        this.pnlButtons.add(button);
        button.addActionListener(this._listener);
    }

    private void initComponents() {
        this.setLayout(new FlowLayout(4, 0, 0));
        this.pnlButtons = new JPanel();
        GridLayout grid = new GridLayout();
        grid.setHgap(5);
        this.pnlButtons.setLayout(grid);
        if ((this._buttonMask & 8) == 8) {
            this.setButton(this.btnApply, "DialogButtonsPanel_btnApply_text", "DialogButtonsPanel_btnApply_text_M", ID_APPLY_ACTION_COMMAND);
        }
        if ((this._buttonMask & 4) == 4) {
            this.setButton(this.btnOk, "DialogButtonsPanel_btnOk_text", null, ID_OK_ACTION_COMMAND);
        }
        if ((this._buttonMask & 2) == 2) {
            this.setButton(this.btnCancel, "DialogButtonsPanel_btnCancel_text", null, ID_CANCEL_ACTION_COMMAND);
        }
        if ((this._buttonMask & 1) == 1) {
            this.setButton(this.btnHelp, "DialogButtonsPanel_btnHelp_text", "DialogButtonsPanel_btnHelp_text_M", ID_HELP_ACTION_COMMAND);
        }
        this.add(this.pnlButtons);
    }

    public void setDefaultButton(int buttonID) {
        switch (buttonID) {
            case 8: {
                this.getRootPane().setDefaultButton(this.btnApply);
                break;
            }
            case 4: {
                this.getRootPane().setDefaultButton(this.btnOk);
                break;
            }
            case 2: {
                this.getRootPane().setDefaultButton(this.btnCancel);
                break;
            }
            case 1: {
                this.getRootPane().setDefaultButton(this.btnHelp);
            }
        }
    }

    public boolean isApplyButtonEnabled() {
        if (this.btnApply == null) {
            return false;
        }
        return this.btnApply.isEnabled();
    }

    public void setApplyButtonEnabled(boolean enabled) {
        if (this.btnApply == null) {
            return;
        }
        this.btnApply.setEnabled(enabled);
    }

    public void setApplyButtonLabel(int labelID) {
        this.setButtonLabel(this.btnApply, labelID);
    }

    public void setOkButtonLabel(int labelID) {
        this.setButtonLabel(this.btnOk, labelID);
    }

    public void setCancelButtonLabel(int labelID) {
        this.setButtonLabel(this.btnCancel, labelID);
    }

    public void setOkButtonLabel(String okButtonLabel) {
        this.btnOk.setText(okButtonLabel);
    }

    public void setCancelButtonLabel(String cancelButtonLabel) {
        this.btnCancel.setText(cancelButtonLabel);
    }

    public void setHelpButtonLabel(String cancelButtonLabel) {
        this.btnHelp.setText(cancelButtonLabel);
    }

    private void setButtonLabel(AbstractButton btn, int labelID) {
        switch (labelID) {
            case 1: {
                btn.setText(_bundle.getString("DialogButtonsPanel_btnOk_text"));
                break;
            }
            case 3: {
                btn.setText(_bundle.getString("DialogButtonsPanel_btnAddContacts_text"));
                btn.setMnemonic(_bundle.getString("DialogButtonsPanel_btnAddContacts_text_M").charAt(0));
                break;
            }
            case 4: {
                btn.setText(_bundle.getString("DialogButtonsPanel_btnClose_text"));
                btn.setMnemonic(_bundle.getString("DialogButtonsPanel_btnClose_text_M").charAt(0));
                break;
            }
            case 5: {
                btn.setText(_bundle.getString("DialogButtonsPanel_apply_changes"));
                btn.setMnemonic(_bundle.getString("DialogButtonsPanel_apply_changes_M").charAt(0));
                break;
            }
            case 2: {
                btn.setText(_bundle.getString("DialogButtonsPanel_btnSend_text"));
                btn.setMnemonic(_bundle.getString("DialogButtonsPanel_btnSend_text_M").charAt(0));
                break;
            }
            case 6: {
                btn.setText(_bundle.getString("DialogButtonsPanel_add_rooms"));
                btn.setMnemonic(_bundle.getString("DialogButtonsPanel_add_rooms_M").charAt(0));
            }
        }
    }

    public void disableButtons(boolean value) {
        this.btnOk.setEnabled(value);
        this.btnCancel.setEnabled(value);
        this.btnHelp.setEnabled(value);
    }
}

