/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorFillIcon
implements Icon {
    private int width;
    private int height;
    private Color fillColor;
    private Color shadow;
    private int borderSize;
    private int fillHeight;
    private int fillWidth;
    private int TYPE = 0;
    public static final int BORDER_SIZE = 2;
    public static final int DEFAULT_SIZE = 32;
    public static final int BLOCK_ICON = 0;
    public static final int TEXT_ICON = 1;

    public ColorFillIcon(Color fill, int width, int height, int borderSize) {
        this.fillColor = fill;
        this.borderSize = borderSize;
        this.width = width;
        this.height = height;
        this.shadow = Color.black;
        this.fillWidth = width - 2 * borderSize;
        this.fillHeight = height - 2 * borderSize;
    }

    public ColorFillIcon(Color fill, int size, int type) {
        this(fill, size, size, 2);
        this.TYPE = type;
    }

    public ColorFillIcon(Color fill) {
        this(fill, 32, 32, 2);
    }

    public final void setShadow(Color c) {
        this.shadow = c;
    }

    public final void setFillColor(Color c) {
        this.fillColor = c;
    }

    public final int getIconWidth() {
        return this.width;
    }

    public final int getIconHeight() {
        return this.height;
    }

    public final void paintIcon(Component comp, Graphics g, int x, int y) {
        if (this.TYPE == 1) {
            this.paintTextIcon(g, x, y);
        } else if (this.TYPE == 0) {
            this.paintBlockIcon(g, x, y);
        }
    }

    private final void paintBlockIcon(Graphics g, int x, int y) {
        Color c = g.getColor();
        if (this.borderSize > 0) {
            g.setColor(this.shadow);
            for (int i = 0; i < this.borderSize; ++i) {
                g.drawRect(x + i, y + i, this.width - 2 * i - 1, this.height - 2 * i - 1);
            }
        }
        g.setColor(this.fillColor);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.fillWidth, this.fillHeight);
        g.setColor(c);
    }

    private final void paintTextIcon(Graphics g, int x, int y) {
        Color c = g.getColor();
        g.setColor(this.fillColor);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.fillWidth, this.fillHeight);
        g.drawString("T", x + this.borderSize + this.fillWidth + 3, y + this.borderSize + this.fillHeight);
        g.setColor(c);
    }

    public final Color getColor() {
        return this.fillColor;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Color) {
            return this.fillColor.getRGB() == ((Color)o).getRGB();
        }
        return super.equals(o);
    }
}

