/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.util;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.ContentStreamListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.SenderFileStreamingProfile;
import com.sun.im.service.SenderStreamingProfile;
import com.sun.im.service.util.HTMLConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class ClientMessageFactory {
    public static final String ID_AUTO_LAUNCH = "AUTO_LAUNCH";
    public static final String ID_SOUND_FILE = "SOUND";
    public static final String ID_SOUND_BYTES = "SOUND_BYTES";
    public static final String ID_TYPE = "TYPE";
    public static final String ID_LOCATION = "LOCATION";
    public static final String ID_OBJECT = "OBJECT";
    public static final String ID_URL = "URL";
    public static final String ID_CUSTOM = "CUSTOM";
    public static final String ID_STORAGE = "storage";
    public static final String ID_GET_URL = "geturl";
    public static final String ID_SUBJECT = "subject";
    public static final String ID_ROOM = "room";
    public static final String ID_ATTACHMENT = "ATTACHMENT";
    public static final String ID_PATH = "PATH";
    public static final String ID_MSGTYPE_MODCHAT = "application/x-iim-moderated";
    public static final String ID_MSGTYPE_TEXT = "text/plain";
    public static final String ID_MSGTYPE_HTML = "text/html";
    public static final String ID_MSGTYPE_POLL = "application/x-iim-poll";
    public static final String ID_MSGTYPE_POLL_REPLY = "application/x-iim-poll-reply";
    public static final String ID_MSGTYPE_URL = "application/x-iim-url";
    public static final String ID_ENCODING = null;
    public static final String ID_BASE64 = "Base64";
    static final HTMLConverter htmlConverter = new HTMLConverter();

    public static void sendAlertPollMsg(Message message, MessageStatusListener listener) {
        try {
            Manager._messageSession.sendMessage(message, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void markMessage(Message m, int status) {
        Manager.worker.addRunnable((Runnable)new MarkMessageRunnable(m, status));
    }

    public static final void sendConferenceMsgNow(Message message, Conference conf, boolean invite, InviteMessageStatusListener listener) throws CollaborationException {
        if (message != null) {
            ClientMessageFactory.printMessage(message);
            if (invite) {
                conf.invite(30, message, listener);
            } else {
                conf.addMessage(message);
            }
        }
    }

    public static final void sendModeratedConferenceMsgNow(Message message, Conference conf, int status, String reason) throws CollaborationException {
        conf.addModeratedMessage(message, status, reason);
    }

    public static final void sendNewsMsgNow(Message message, Conference nc) throws CollaborationException {
        nc.addMessage(message);
    }

    public static void addUsersToMessage(Object[] o, Message m) {
        Vector<Object> v = new Vector<Object>();
        for (int n = 0; n < o.length; ++n) {
            v.addElement(o[n]);
        }
        ClientMessageFactory.addUsersToMessage(v, m);
    }

    public static void addUsersToMessage(Vector v, Message m) {
        try {
            if (v == null) {
                return;
            }
            for (int i = 0; i < v.size(); ++i) {
                if (v.elementAt(i) instanceof PersonalStoreEntry) {
                    m.addRecipient(((PersonalStoreEntry)v.elementAt(i)).getEntryId());
                    continue;
                }
                if (v.elementAt(i) instanceof Conference) {
                    m.addRecipient(((Conference)v.elementAt(i)).getDestination());
                    continue;
                }
                if (!(v.elementAt(i) instanceof CollaborationPrincipal)) continue;
                m.addRecipient(((CollaborationPrincipal)v.elementAt(i)).getUID());
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e:" + (Object)((Object)e));
        }
    }

    public static final void sendInviteMsg(CollaborationPrincipal[] nu, String msg, Conference conf, boolean remove_me, InviteMessageStatusListener listener) throws CollaborationException {
        InviteMessage newMsg = conf.createInviteMessage();
        MessagePart part = newMsg.newPart();
        ClientMessageFactory.addPart((Message)newMsg, ID_MSGTYPE_HTML, msg);
        System.out.println("remove me is " + remove_me);
        for (int i = 0; i < nu.length; ++i) {
            if (remove_me && nu[i].getUID().equals(CurrentUserManager.getCurrentUserID())) continue;
            System.out.println("Adding the recipient " + nu[i].getUID());
            newMsg.addRecipient(nu[i].getUID());
        }
        ClientMessageFactory.sendConferenceMsgNow((Message)newMsg, conf, true, listener);
    }

    public static final void sendConferenceMsg(Message message, Conference conf) {
        try {
            ClientMessageFactory.sendConferenceMsgNow(message, conf, false, null);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void sendModeratedConferenceMsg(Message message, Conference conf, int status, String reason) {
        try {
            ClientMessageFactory.sendModeratedConferenceMsgNow(message, conf, status, reason);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void sendTypingMsg(Conference conf, boolean typing) {
        try {
            Message m = conf.createMessage();
            int status = 9;
            if (typing) {
                status = 8;
            }
            m.sendStatus(status);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void sendNewsMsg(Message message, NewsChannel nc) throws CollaborationException {
        Manager.worker.addRunnable((Runnable)new SendNewsMsgThread(message, nc));
    }

    public static final Message createRoomMsg(String type, String body, Conference c) {
        try {
            Message msg = c.createMessage();
            ClientMessageFactory.updateMessage(msg, body, type, "");
            return msg;
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e:" + (Object)((Object)e));
            return null;
        }
    }

    public static final void updateMessage(Message m, String c, String t, String subj) {
        ClientMessageFactory.addSubject(m, subj);
        ClientMessageFactory.addPart(m, t, c);
    }

    public static final void addSubject(Message m, String sub) {
        try {
            m.setHeader(ID_SUBJECT, sub);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final String getSubject(Message m) {
        return m.getHeader(ID_SUBJECT);
    }

    public static final String getHTMLContent(MessagePart part) {
        try {
            String ret = part.getContent(ID_MSGTYPE_HTML);
            if (ret == null) {
                ret = part.getContent();
            }
            return ret;
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void addHeaders(Message m, Hashtable header) {
        if (header == null) {
            return;
        }
        try {
            Enumeration e = header.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = header.get(key);
                m.setHeader(key.toString(), header.get(key).toString());
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    public static final void addPart(Message m, String type, Object cont) {
        try {
            MessagePart part = m.newPart();
            part.setContentType(type);
            if (cont instanceof String) {
                if (type.equals(ID_MSGTYPE_POLL_REPLY) || type.equals(ID_MSGTYPE_POLL)) {
                    part.setContent((String)cont);
                } else if (ID_MSGTYPE_TEXT.equals(type)) {
                    part.setContent((String)cont);
                } else {
                    part.setContent((String)cont, ID_MSGTYPE_HTML);
                    part.setContent(ClientMessageFactory.convertToText((String)cont));
                }
                Manager.Out("setting content = " + cont);
            }
            m.addPart(part);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void addAttachments(Message m, List files, int offset) {
        try {
            Iterator itr = files.iterator();
            while (itr.hasNext()) {
                m.setHeader("ATTACHMENT-" + offset++, ((File)itr.next()).getName());
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static void sendAttachments(String[] rcpt, List files, boolean remove_me) {
        Iterator itr = files.iterator();
        while (itr.hasNext()) {
            Manager.worker.addRunnable((Runnable)new SendFileThread(rcpt, (File)itr.next(), remove_me));
        }
    }

    public static void printMessage(Message message) {
        Manager.debug("    Content-type: " + message.getContentType());
        MessagePart[] parts = message.getParts();
        for (int i = 0; i < parts.length; ++i) {
            Manager.debug("    Part " + i);
            Manager.debug("        Content-type: " + parts[i].getContentType());
            try {
                Manager.debug(parts[i].getContent());
                Manager.debug("HTML Data: " + ClientMessageFactory.getHTMLContent(parts[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String convertToText(String str) {
        return htmlConverter.convertToText(str);
    }

    public static List getAttachmentList(Message m) {
        String name;
        if (m == null) {
            return null;
        }
        int i = 0;
        LinkedList<String> list = new LinkedList<String>();
        while ((name = m.getHeader("ATTACHMENT-" + i++)) != null) {
            list.add(name);
        }
        return list;
    }

    public static void changeAttachmentName(Message m, String oldName, String newName) {
        String name;
        if (m == null) {
            return;
        }
        int i = 0;
        while ((name = m.getHeader("ATTACHMENT-" + i++)) != null) {
            if (!name.equals(oldName)) continue;
            try {
                m.setHeader("ATTACHMENT-" + (i - 1), newName);
            }
            catch (CollaborationException ce) {
                ce.printStackTrace();
            }
            return;
        }
    }

    static class SendNewsMsgThread
    implements Runnable {
        private Message message;
        private NewsChannel nc;

        public SendNewsMsgThread(Message message, NewsChannel nc) {
            this.message = message;
            this.nc = nc;
        }

        public void run() {
            try {
                ClientMessageFactory.sendNewsMsgNow(this.message, (Conference)this.nc);
            }
            catch (CollaborationException e) {
                Manager.Out("Unable to post the News Message" + e.toString());
            }
        }
    }

    static class SendFileThread
    implements ContentStreamListener,
    Runnable {
        private File file;
        private static String[] methods = new String[]{"http://jabber.org/protocol/ibb", "jabber:iq:oob"};
        private String[] rcpt;
        private boolean remove_me;

        public SendFileThread(String[] rcpt, File f, boolean remove_me) {
            this.file = f;
            this.rcpt = rcpt;
            this.remove_me = remove_me;
        }

        public void run() {
            SenderFileStreamingProfile profile;
            try {
                profile = new SenderFileStreamingProfile(this.file, true, "File attachment");
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return;
            }
            for (int i = 0; i < this.rcpt.length; ++i) {
                if (this.remove_me && this.rcpt[i].equals(CurrentUserManager.getCurrentUserID())) continue;
                try {
                    Manager._streamingService.open(this.rcpt[i], methods, (SenderStreamingProfile)profile, (ContentStreamListener)this);
                    continue;
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
            }
        }

        public void closed(int status, String reason) {
        }

        public void started() {
        }
    }

    static final class MarkMessageRunnable
    implements Runnable {
        private Message m;
        private int status;

        public MarkMessageRunnable(Message m, int status) {
            this.m = m;
            this.status = status;
        }

        public final void run() {
            try {
                this.m.sendStatus(this.status);
            }
            catch (CollaborationException e) {
                Manager.Out("Exception e:" + (Object)((Object)e));
            }
        }
    }
}

