/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.topic;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.swing.AddMsg;
import com.iplanet.im.client.swing.AttachmentPanel;
import com.iplanet.im.client.swing.MessagePanel;
import com.iplanet.im.client.swing.SubscriptionEvent;
import com.iplanet.im.client.swing.SubscriptionListener;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.swing.topic.MessageObject;
import com.iplanet.im.client.util.BlinkableJTabbedPane;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.IMHTMLEditorKit;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class TopicView
extends iIMFrame
implements SubscriptionListener,
ChangeListener {
    static SafeResourceBundle topicViewBundle = new SafeResourceBundle("com.iplanet.im.client.swing.topic.topic");
    static SafeResourceBundle commonBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    private static final String TOP = "Top";
    private static final String LEFT = "Left";
    private static final String BOTTOM = "Bottom";
    private static final String RIGHT = "Right";
    private SmartJPopupMenu popup;
    private ButtonGroup tabPosGroup;
    private JRadioButtonMenuItem miTabNorth;
    private JRadioButtonMenuItem miTabSouth;
    private JRadioButtonMenuItem miTabEast;
    private JRadioButtonMenuItem miTabWest;
    private JCheckBoxMenuItem miHideTabs;
    private JCheckBoxMenuItem miScroll;
    private JCheckBoxMenuItem miHideTools;
    private JMenuItem miNext;
    private JMenuItem miPrevious;
    private JMenuItem miMarkAsSeen;
    private JMenuItem miPostNewMsg;
    private JMenuItem miManage;
    private JMenuItem miSubscribe;
    private JMenuItem miCommunicator;
    private JMenuItem miSettings;
    private JMenuItem miViewSource;
    private JMenuItem miSave;
    private JMenuItem miClose;
    private JMenuItem miProperties;
    private JMenuItem miReply;
    private JMenuItem miForward;
    private JMenuItem miPrint;
    private JMenuItem miEdit;
    private JMenuItem miHelp;
    private JMenu mFile;
    private JMenu mView;
    private JMenu mTools;
    private JMenu mHelp;
    private JMenuBar menuBar;
    AttachmentPanel attachments;
    private boolean attachmentPanelShown = false;
    private boolean _isPaused = false;
    private boolean _isMoveLocked = false;
    private String _title = "";
    private Timer timer = null;
    private Point position;
    private PopupListener popupListener;
    private Hashtable messageUpdate = new Hashtable(5);
    private Vector queue = new Vector(5);
    private Vector alert_queue = new Vector(4);
    private Vector ignoreMsg = new Vector(5);
    private String currentMsgId = null;
    private MessageObject currentObject;
    private static int _openedTopics = 0;
    private static Vector _channelsWithNewMessage = new Vector();
    private int minWidthSoAllButtonsShow;
    JPanel pnlView;
    JPanel pnlViewAttach;
    BlinkableJTabbedPane tabs;
    MessagePanel scroller;
    JEditorPane txtMessage;
    JPanel pnlButtons;
    JButton btnLeft;
    JButton btnPause;
    JButton btnRight;
    JPanel pnlBottom;
    JPanel pnlButtonsAndBottom;
    JButton btnCommunicator;
    JButton btnSettings;
    JButton btnSubscribe;
    JButton btnManage;
    JButton btnPost;
    JButton btnDelete;
    JButton btnClose;
    JButton btnHelp;
    EtchedBorder etchedBorder1;

    public TopicView() {
        this.initComponents();
        Dimension d = iIMPropsUtil.getTopicWindowDim(CurrentUserManager.getCurrentUserProperties());
        Manager.Out("d.width: " + d.width);
        if (d.width < this.minWidthSoAllButtonsShow) {
            d.width = this.minWidthSoAllButtonsShow;
        }
        this.centerWindow();
        this.doInit();
        ++_openedTopics;
        Manager.Out("   DEBUG TOPIC: CREATED \n");
    }

    private void initComponents() {
        this.pnlView = new JPanel();
        this.pnlButtons = new JPanel();
        this.pnlBottom = new JPanel();
        this.pnlButtonsAndBottom = new JPanel();
        this.tabs = new BlinkableJTabbedPane();
        this.scroller = new MessagePanel();
        this.txtMessage = new JEditorPane();
        this.btnLeft = new JButton();
        this.btnPause = new JButton();
        this.btnRight = new JButton();
        this.btnCommunicator = new JButton();
        this.btnSettings = new JButton();
        this.btnSubscribe = new JButton();
        this.btnPost = new JButton();
        this.btnDelete = new JButton();
        this.btnManage = new JButton();
        this.btnClose = new JButton();
        this.btnHelp = new JButton();
        this.etchedBorder1 = new EtchedBorder();
        this.popup = new SmartJPopupMenu();
        this.setVisible(false);
        String title = topicViewBundle.getString("TopicView_title_default");
        this.getAccessibleContext().setAccessibleDescription(title);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.initMenuBar();
        this.pnlView.setLayout(new GridBagLayout());
        this.tabs.setAutoscrolls(true);
        this.pnlView.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.pnlView.add((Component)this.scroller, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.txtMessage.setEditable(false);
        this.txtMessage.setContentType("text/html");
        this.txtMessage.setEditorKit(new IMHTMLEditorKit());
        this.scroller.setParent(this);
        this.scroller.setViewportView(this.txtMessage);
        this.scroller.setView(this.txtMessage);
        this.attachments = new AttachmentPanel(this);
        FlowLayout flow = new FlowLayout(1, 2, 5);
        this.pnlButtons.setLayout(flow);
        this.getContentPane().add("Center", this.pnlView);
        this.btnLeft.setToolTipText(topicViewBundle.getString("TopicView_previous"));
        this.btnLeft.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_previous.png", (Object)this));
        this.btnLeft.setMnemonic(topicViewBundle.getString("TopicView_previous_M").charAt(0));
        this.pnlButtons.add(this.btnLeft);
        this.btnPause.setToolTipText(topicViewBundle.getString("TopicView_play_pause"));
        this.btnPause.setMnemonic(topicViewBundle.getString("TopicView_play_pause_M").charAt(0));
        this.updatePauseButton();
        this.pnlButtons.add(this.btnPause);
        this.btnRight.setToolTipText(topicViewBundle.getString("TopicView_next"));
        this.btnRight.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_next.png", (Object)this));
        this.btnRight.setMnemonic(topicViewBundle.getString("TopicView_next_M").charAt(0));
        this.pnlButtons.add(this.btnRight);
        this.pnlBottom.setLayout(new FlowLayout(2, 2, 2));
        SwingUtils.setupButton(this.btnCommunicator, topicViewBundle, "TopicView_im", "TopicView_im_M", null, null);
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.pnlBottom.add(this.btnCommunicator);
        } else {
            this.btnCommunicator.setVisible(false);
            this.btnCommunicator.setEnabled(false);
        }
        this.btnSettings.setHorizontalTextPosition(0);
        this.btnSettings.setVerticalTextPosition(3);
        this.btnSettings.setVerticalAlignment(3);
        this.btnSettings.setText(topicViewBundle.getString("TopicView_settings"));
        if (!UserAccessControl.canOpenControlPanel()) {
            this.pnlBottom.add(this.btnSettings);
        }
        SwingUtils.setupButton(this.btnPost, topicViewBundle, "TopicView_btnPost", "TopicView_btnPost_M", null, "TopicView_btnPost_toolTipText");
        this.btnPost.setEnabled(false);
        this.pnlBottom.add(this.btnPost);
        SwingUtils.setupButton(this.btnDelete, topicViewBundle, "TopicView_btnDelete", "TopicView_btnDelete_M", null, "TopicView_btnDelete_toolTipText");
        this.btnDelete.setEnabled(false);
        this.pnlBottom.add(this.btnDelete);
        SwingUtils.setupButton(this.btnSubscribe, topicViewBundle, "TopicView_subscribe", "TopicView_subscribe_M", null, null);
        this.pnlBottom.add(this.btnSubscribe);
        if (Manager.ALLOW_NEWS_MANAGEMENT) {
            SwingUtils.setupButton(this.btnManage, topicViewBundle, "TopicView_manage", "TopicView_manage_M", null, null);
            this.pnlBottom.add(this.btnManage);
        }
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            SwingUtils.setupButton(this.btnClose, topicViewBundle, "TopicView_close", "TopicView_close_M", null, null);
        } else {
            SwingUtils.setupButton(this.btnClose, topicViewBundle, "TopicView_exit", "TopicView_exit_M", null, null);
        }
        this.pnlBottom.add(this.btnClose);
        SwingUtils.setupButton(this.btnHelp, topicViewBundle, "TopicView_help", "TopicView_help_M", null, null);
        this.pnlBottom.add(this.btnHelp);
        this.minWidthSoAllButtonsShow = flow.preferredLayoutSize((Container)this.pnlBottom).width + 15;
        Manager.Out("minWidthSoAllButtonsShow: " + this.minWidthSoAllButtonsShow);
        this.pnlButtonsAndBottom.setLayout(new BorderLayout(0, 0));
        this.pnlButtonsAndBottom.add("North", this.pnlButtons);
        this.pnlButtonsAndBottom.add("Center", this.pnlBottom);
        this.getContentPane().add("South", this.pnlButtons);
        this.popupListener = new PopupListener();
        this.popup.addPopupMenuListener(this.popupListener);
        this.txtMessage.addMouseListener(this.popupListener);
        this.btnLeft.addActionListener(this);
        this.btnPause.addActionListener(this);
        this.btnRight.addActionListener(this);
        this.btnPost.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.tabs.addChangeListener(this);
        this.btnSettings.addActionListener(this);
        if (Manager.ALLOW_NEWS_MANAGEMENT) {
            this.btnManage.addActionListener(this);
        }
        this.btnHelp.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.btnSubscribe.addActionListener(this);
        this.btnCommunicator.addActionListener(this);
    }

    private JMenu getJMenu(String labelKey, String mnemonicKey) {
        String label = labelKey != null ? commonBundle.getString(labelKey) : null;
        String mnemonic = mnemonicKey != null ? commonBundle.getString(mnemonicKey) : null;
        JMenu menu = new JMenu(label != null ? label : " ");
        if (mnemonic != null && mnemonic.length() > 0) {
            menu.setMnemonic(mnemonic.charAt(0));
        }
        return menu;
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.mFile = this.getJMenu("menuTitle_File", "menuTitle_File_M");
        this.mView = this.getJMenu("menuTitle_View", "menuTitle_View_M");
        this.mTools = this.getJMenu("menuTitle_Tools", "menuTitle_Tools_M");
        this.mHelp = this.getJMenu("menuTitle_Help", "menuTitle_Help_M");
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mView);
        this.menuBar.add(this.mTools);
        this.menuBar.add(this.mHelp);
        this.initMenuItems();
        this.buildMenus();
        this.setJMenuBar(this.menuBar);
    }

    private final void initMenuItems() {
        String tabPos = iIMPropsUtil.getTabPlacement(CurrentUserManager.getCurrentUserProperties());
        this.tabPosGroup = new ButtonGroup();
        this.miTabNorth = SwingUtils.radioMenuItem(this, topicViewBundle, "TopicView_miTabNorth___new_JMenuItem", "TopicView_miTabNorth___new_JMenuItem_M", this.tabPosGroup);
        this.miTabEast = SwingUtils.radioMenuItem(this, topicViewBundle, "TopicView_miTabEast___new_JMenuItem", "TopicView_miTabEast___new_JMenuItem_M", this.tabPosGroup);
        this.miTabSouth = SwingUtils.radioMenuItem(this, topicViewBundle, "TopicView_miTabSouth___new_JMenuItem", "TopicView_miTabSouth___new_JMenuItem_M", this.tabPosGroup);
        this.miTabWest = SwingUtils.radioMenuItem(this, topicViewBundle, "TopicView_miTabWest___new_JMenuItem", "TopicView_miTabWest___new_JMenuItem_M", this.tabPosGroup);
        this.miTabNorth.setSelected(tabPos.equals(TOP));
        this.miTabEast.setSelected(tabPos.equals(LEFT));
        this.miTabSouth.setSelected(tabPos.equals(BOTTOM));
        this.miTabWest.setSelected(tabPos.equals(RIGHT));
        this.miHideTabs = SwingUtils.checkBoxMenuItem(this, topicViewBundle, "TopicView_hidetab___new_JMenuItem", "TopicView_hidetab___new_JMenuItem_M", null);
        this.miHideTabs.setSelected(iIMPropsUtil.isHideTopicTabEnabled(CurrentUserManager.getCurrentUserProperties()));
        this.miHideTools = SwingUtils.checkBoxMenuItem(this, topicViewBundle, "TopicView_hidetools___new_JMenuItem", "TopicView_hidetools___new_JMenuItem_M", null);
        this.miHideTools.setSelected(iIMPropsUtil.isHideTopicToolsEnabled(CurrentUserManager.getCurrentUserProperties()));
        this.miScroll = SwingUtils.checkBoxMenuItem(this, topicViewBundle, "TopicView_scroll___new_JMenuItem", "TopicView_scroll___new_JMenuItem_M", null);
        this.miNext = SwingUtils.menuItem(this, topicViewBundle, "TopicView_miNext___new_JMenuItem", "TopicView_miNext___new_JMenuItem_M", null);
        this.miManage = SwingUtils.menuItem(this, topicViewBundle, "TopicView_manage", "TopicView_manage_M", null);
        this.miSubscribe = SwingUtils.menuItem(this, topicViewBundle, "TopicView_subscribe", "TopicView_subscribe_M", null);
        this.miCommunicator = SwingUtils.menuItem(this, topicViewBundle, "TopicView_im", "TopicView_im_M", null);
        this.miPrevious = SwingUtils.menuItem(this, topicViewBundle, "TopicView_miPrevious___new_JMenuItem", "TopicView_miPrevious___new_JMenuItem_M", null);
        this.miMarkAsSeen = SwingUtils.menuItem(this, topicViewBundle, "TopicView_miMarkAsSeen___new_JMenuItem", "TopicView_miMarkAsSeen___new_JMenuItem_M", null);
        this.miPostNewMsg = SwingUtils.menuItem(this, topicViewBundle, "TopicView_newmsg___new_JMenuItem", "TopicView_newmsg___new_JMenuItem_M", null);
        this.miViewSource = SwingUtils.menuItem(this, topicViewBundle, "TopicView_source___new_JMenuItem", "TopicView_source___new_JMenuItem_M", null);
        this.miSettings = SwingUtils.menuItem(this, topicViewBundle, "TopicView_settings", "TopicView_settings_M", null);
        this.miSave = SwingUtils.menuItem(this, topicViewBundle, "TopicView_save___new_JMenuItem", "TopicView_save___new_JMenuItem_M", null);
        this.miClose = Manager.ALLOW_PRESENCE_ACCESS ? SwingUtils.menuItem(this, topicViewBundle, "btnClose_text", "btnClose_text_M", "btnClose_text_A") : SwingUtils.menuItem(this, topicViewBundle, "TopicView_exit", "TopicView_exit_M", "TopicView_exit_A");
        this.miProperties = SwingUtils.menuItem(this, topicViewBundle, "TopicView_properties___new_JMenuItem", "TopicView_properties___new_JMenuItem_M", null);
        if (Manager.ALLOW_CHAT) {
            this.miReply = SwingUtils.menuItem(this, topicViewBundle, "TopicView_reply___new_JMenuItem", "TopicView_reply___new_JMenuItem_M", null);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miForward = SwingUtils.menuItem(this, topicViewBundle, "TopicView_forward___new_JMenuItem", "TopicView_forward___new_JMenuItem_M", null);
        }
        this.miPrint = SwingUtils.menuItem(this, topicViewBundle, "TopicView_print___new_JMenuItem", null, "TopicView_print___new_JMenuItem_A");
        this.miEdit = SwingUtils.menuItem(this, topicViewBundle, "TopicView_edit___new_JMenuItem", "TopicView_edit___new_JMenuItem_M", null);
        this.miHelp = SwingUtils.menuItem(this, topicViewBundle, "TopicView_help_MenuItem", "TopicView_help_MenuItem_M", "TopicView_help_MenuItem_A");
    }

    private void buildMenus() {
        this.mFile.removeAll();
        this.mFile.add(this.miSave);
        this.mFile.add(this.miPrint);
        this.mFile.addSeparator();
        this.mFile.add(this.miClose);
        this.mView.removeAll();
        this.mView.add(this.miScroll);
        this.mView.addSeparator();
        this.mView.add(this.miHideTools);
        this.mView.add(this.miHideTabs);
        this.mView.add(this.miTabNorth);
        this.mView.add(this.miTabEast);
        this.mView.add(this.miTabSouth);
        this.mView.add(this.miTabWest);
        this.mTools.removeAll();
        this.mTools.add(this.miProperties);
        if (Manager.ALLOW_CHAT) {
            this.mTools.add(this.miReply);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.mTools.add(this.miForward);
        }
        this.mTools.add(this.miViewSource);
        if (Manager.ALLOW_NEWS_MANAGEMENT) {
            this.mTools.add(this.miManage);
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.mTools.add(this.miSubscribe);
        }
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.mTools.add(this.miCommunicator);
            this.miCommunicator.setEnabled(true);
        } else {
            this.miCommunicator.setEnabled(false);
        }
        if (Manager.ALLOW_SETTINGS_CHANGES) {
            this.mTools.add(this.miSettings);
        } else {
            this.miSettings.setEnabled(false);
        }
        this.mHelp.removeAll();
        this.mHelp.add(this.miHelp);
    }

    private final void doInit() {
        this.loadTabs();
        this.initTimer();
        this.setVisible(true);
        this.update();
    }

    private final void setTabPlacement() {
        String pos = iIMPropsUtil.getTabPlacement(CurrentUserManager.getCurrentUserProperties());
        iIMPropsUtil.setTabPlacement(CurrentUserManager.getCurrentUserProperties(), pos);
        if (pos.equals(TOP)) {
            this.tabs.setTabPlacement(1);
        } else if (pos.equals(BOTTOM)) {
            this.tabs.setTabPlacement(3);
        } else if (pos.equals(RIGHT)) {
            this.tabs.setTabPlacement(4);
        } else if (pos.equals(LEFT)) {
            this.tabs.setTabPlacement(2);
        }
    }

    public final void windowIconified(WindowEvent e) {
        iIMPropsUtil.setTopicWindowDim(CurrentUserManager.getCurrentUserProperties(), this.getSize());
        if (iIMPropsUtil.isTopicMoveLocked(CurrentUserManager.getCurrentUserProperties())) {
            this.setVisible(false);
            this.setVisible(true);
        }
    }

    public final void windowDeiconified(WindowEvent e) {
    }

    public final void windowClosing(WindowEvent event) {
        this.close(true);
    }

    private final void loadTabs() {
        Manager.Out("DEBUG: TopicView.loadTabs()");
        String[] ids = TopicManager.getSubscribedTopicIDs();
        if (ids == null || ids.length <= 0) {
            this.createTab(null);
        } else {
            for (int n = 0; n < ids.length; ++n) {
                this.createTab(ids[n]);
                try {
                    NewsChannel nc = TopicManager.getTopic(ids[n]);
                    if (nc == null) continue;
                    nc.setListener((NewsChannelListener)new NewsChannelListenerImpl(ids[n]));
                    continue;
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
            }
            this.refreshTopicMessages();
        }
    }

    private final void initTimer() {
        Manager.Out("   DEBUG TOPIC: initTimer()");
        this.timer = new Timer(iIMPropsUtil.getTopicScrollInterval(CurrentUserManager.getCurrentUserProperties()), this);
        this.timer.start();
    }

    private final void setTabPosition(int n) {
        this.tabs.setTabPlacement(n);
    }

    private final void toggleTabs() {
        boolean b = this.tabs.isVisible();
        iIMPropsUtil.setHideTopicTabEnabled(CurrentUserManager.getCurrentUserProperties(), b);
        this.toggleTabs(b);
    }

    private final void toggleTabs(boolean b) {
        this.tabs.setVisible(!b);
        this.scroller.setVisible(b);
        if (b) {
            ((MessagePanel)this.tabs.getSelectedComponent()).getViewport().remove(this.txtMessage);
            this.scroller.setViewportView(this.txtMessage);
        } else {
            this.scroller.getViewport().remove(this.txtMessage);
            ((MessagePanel)this.tabs.getSelectedComponent()).setViewportView(this.txtMessage);
        }
        Enumeration<AbstractButton> e = this.tabPosGroup.getElements();
        while (e.hasMoreElements()) {
            ((JRadioButtonMenuItem)e.nextElement()).setEnabled(!b);
        }
        this.invalidate();
        this.validate();
    }

    private final boolean isUpdating() {
        return this._isFrameBlinking || this.getCurrentMessageView().IS_SCROLLING;
    }

    private final synchronized void changeTab() {
        int selected = this.tabs.getSelectedIndex();
        if (this.timer == null || selected < 0) {
            return;
        }
        String tmp = (String)this.queue.elementAt(selected);
        _channelsWithNewMessage.removeElement(tmp);
        if (this.tabs.isVisible()) {
            ((MessagePanel)this.tabs.getSelectedComponent()).setViewportView(this.txtMessage);
        }
        this.repaint();
        this.markRead();
        this.refreshTopicMessages();
        this.setTopicTitle(topicViewBundle.getString("TopicView_updating"));
        this.updateButtonsforTab();
        this.update();
    }

    private final boolean checkTabRotation() {
        if (!iIMPropsUtil.isRotateTopicEnabled(CurrentUserManager.getCurrentUserProperties())) {
            if (this.currentObject != null && this.currentObject.isLastMessage()) {
                this.refreshTopicMessages();
            }
            return false;
        }
        if (this.currentObject == null) {
            this.setNewIndex(this.getNextIndex());
            return true;
        }
        if (this.currentObject.isEmpty() && this.currentObject.ROTATE) {
            this.refreshTopicMessages();
            if (!this.currentObject.isEmpty()) {
                return false;
            }
            this.currentObject.ROTATE = true;
            this.setNewIndex(this.getNextIndex());
            return true;
        }
        if (this.currentObject.isEmpty() && !this.currentObject.ROTATE) {
            this.currentObject.ROTATE = true;
            return false;
        }
        if (this.currentObject.isLastMessage() || this.currentObject.ROTATE) {
            int miNext = this.getNextIndex();
            if (miNext == this.tabs.getSelectedIndex()) {
                this.refreshTopicMessages();
                return false;
            }
            this.setNewIndex(miNext);
            return true;
        }
        return false;
    }

    private void setNewIndex(int n) {
        if (this.tabs.getSelectedIndex() == n || n < 0) {
            return;
        }
        if (this.tabs.isVisible()) {
            ((MessagePanel)this.tabs.getSelectedComponent()).getViewport().remove(this.txtMessage);
        }
        this.tabs.setSelectedIndex(n);
        this.updateButtonsforTab();
    }

    private final void update() {
        if (this.timer == null || !this.isVisible()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer.setDelay(iIMPropsUtil.getTopicScrollInterval(CurrentUserManager.getCurrentUserProperties()));
        this.timer.restart();
        if (this.checkTabRotation()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (this.currentObject.isEmpty()) {
            this.displayMessage(null);
        } else if (this.currentObject.isLastMessage() && this.queue.size() == 1) {
            this.displayMessage(this.currentObject.getmiNextMessage());
            this.refreshTopicMessages();
        } else if (this.currentObject.isLastMessage()) {
            this.update();
        } else if (this.currentObject.getMessageSize() == 1 && this.queue.size() == 1) {
            this.refreshTopicMessages();
        } else {
            this.displayMessage(this.currentObject.getmiNextMessage());
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private final void displayMessage(Message m) {
        String selectedString;
        int selected = this.tabs.getSelectedIndex();
        if (this.miReply != null && m != null && ((selectedString = (String)this.queue.elementAt(selected)) != null || selectedString.length() > 0)) {
            if (!selectedString.equals(TopicManager.ID_TOPIC_ALERT_ID)) {
                this.miReply.setEnabled(false);
            } else {
                this.miReply.setEnabled(true);
            }
        }
        this.setTopicTitle(topicViewBundle.getString("TopicView_Title_Empty"));
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body bgcolor=white>");
        buf.append("<p>");
        buf.append(topicViewBundle.getString("TopicView_Empty_Content"));
        buf.append("</p>");
        buf.append("</body></html>");
        this.txtMessage.setBackground(Color.white);
        this.getCurrentMessageView();
        MessagePanel.displayTextMessage(this.txtMessage, buf.toString());
        this.attachments.updateAttachmentPanelForMessage(m);
        boolean showAttachmentPanel = this.attachments.attachmentsPresent();
        if (this.attachmentPanelShown != showAttachmentPanel) {
            if (this.attachmentPanelShown) {
                this.pnlView.remove(this.attachments.getAttachmentPanel());
            } else {
                this.pnlView.add((Component)this.attachments.getAttachmentPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 5, 2, 5), 0, 0));
            }
            this.pnlView.validate();
        }
        this.attachmentPanelShown = showAttachmentPanel;
        if (m != null) {
            this.currentMsgId = m.getMessageId();
            String subj = m.getHeader("subject");
            if (subj == null) {
                subj = topicViewBundle.getString("no_subject");
            }
            String title = StringUtility.substitute((String)topicViewBundle.getString("TopicView_title_core"), (String)"__MACRO__", (String)subj);
            String from = m.getOriginator() != null ? m.getOriginator() : "";
            this.setTopicTitle(StringUtility.substitute((String)title, (String)"__MACRO1__", (String)from));
            if ("application/x-iim-url".equals(m.getContentType())) {
                this.getCurrentMessageView();
                MessagePanel.displayMessage(this.txtMessage, m, true);
                if (iIMPropsUtil.isScrollTopicEnabled(CurrentUserManager.getCurrentUserProperties()) && !this.getCurrentMessageView().IS_SCROLLING && this.isVisible()) {
                    this.getCurrentMessageView().doEffect();
                }
            } else {
                this.getCurrentMessageView();
                MessagePanel.displayMessage(this.txtMessage, m, true);
            }
        }
        this.getCurrentMessageView().resetScrollPosition();
        if (selected >= 0) {
            if (this.queue.size() == 0) {
                return;
            }
            String tmp = (String)this.queue.elementAt(selected);
            _channelsWithNewMessage.removeElement(tmp);
        }
    }

    private MessagePanel getCurrentMessageView() {
        if (this.tabs.isVisible()) {
            return (MessagePanel)this.tabs.getSelectedComponent();
        }
        return this.scroller;
    }

    private final int getNextIndex() {
        int n = this.tabs.getSelectedIndex();
        if (++n >= this.queue.size()) {
            n = 0;
        }
        return n;
    }

    private void setCurrentObject(MessageObject mo) {
        this.currentObject = mo;
        boolean enable = mo != null && !this.currentObject.isEmpty();
        this.miSave.setEnabled(enable);
        this.miPrint.setEnabled(enable);
        this.miProperties.setEnabled(enable);
        this.miViewSource.setEnabled(enable);
        if (this.miReply != null) {
            this.miReply.setEnabled(enable);
        }
        if (this.miForward != null) {
            this.miForward.setEnabled(enable);
        }
        if (this.miEdit != null) {
            this.miEdit.setEnabled(enable);
        }
    }

    private final void createTab(String s) {
        this.createTab(s, -1);
    }

    private final void createTab(String s, int index) {
        Manager.Out("DEBUG: TopicView.createTab(): s: " + s);
        if (this.queue.size() <= 0 && this.tabs.getTabCount() > 0) {
            this.tabs.removeTabAt(0);
        }
        MessagePanel scr = new MessagePanel(20, 30);
        scr.setViewportView(this.txtMessage);
        if (s == null) {
            this.getCurrentMessageView();
            MessagePanel.displayTextMessage(this.txtMessage, "Empty");
            this.setTopicTitle(topicViewBundle.getString("TopicView_no_subscriptions"));
            this.setCurrentObject(new MessageObject(new Vector(1), "empty"));
            scr.add(this.txtMessage);
            if (index < 0) {
                this.tabs.addTab(topicViewBundle.getString("TopicView_Title_Empty"), scr);
            } else {
                this.tabs.insertTab(topicViewBundle.getString("TopicView_Title_Empty"), null, scr, null, index);
            }
        } else if (index < 0) {
            this.queue.addElement(s);
            this.tabs.addTab(s, scr);
        } else {
            this.queue.insertElementAt(s, index);
            this.tabs.insertTab(s, null, scr, null, index);
        }
        this.changeTab();
    }

    public void subscriptionChange(SubscriptionEvent evt) {
        SwingUtilities.invokeLater(new SubscriptionEventRunnable(evt));
    }

    private void subscribe(String id) {
        try {
            Manager.Out("Inside subscribe");
            NewsChannel nc = TopicManager.getTopic(id);
            if (TopicManager.ID_TOPIC_ALERT_ID.equals(id)) {
                iIMPropsUtil.setTopicAlertChannelEnabled(CurrentUserManager.getCurrentUserProperties(), true);
                TopicManager.setTopicAlertChannelEnabled(true);
                UserPropsManager.saveUserSettings(Manager._personalStoreSession.getProfile(), CurrentUserManager.getCurrentUserProperties(), true);
            }
            if (nc != null) {
                nc.subscribe((NewsChannelListener)new NewsChannelListenerImpl(id));
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private final void newAlertMessage(String id) {
        Manager.Out("   DEBUG TOPIC: ADD New Alert Message");
        if (id == null) {
            this.tabs.setAlertAt(this.tabs.getSelectedIndex(), false);
            return;
        }
        if (!this.tabs.isAlertAt(this.tabs.getSelectedIndex())) {
            Vector ids = Manager.getVectorFromArray(TopicManager.getTopicMessageIds(TopicManager.ID_TOPIC_ALERT_ID));
            if (ids == null) {
                Manager.Out("TopicView.newAlertMessage(): unknown error occured getting ids");
                ids = new Vector(2);
            }
            this.setCurrentObject(new MessageObject(ids, TopicManager.ID_TOPIC_ALERT_ID));
            this.setAlertTabFocus();
            this.currentMsgId = id;
            this.displayMessage(TopicManager.getTopicMessage(TopicManager.ID_TOPIC_ALERT_ID, id));
            boolean min = iIMPropsUtil.getMinimizeAlerts(CurrentUserManager.getCurrentUserProperties());
            ApplicationManager.refreshFrame(this, min, true);
            this.tabs.setAlertAt(this.tabs.getSelectedIndex(), true);
            if (!min) {
                this.setOnTop(true);
            }
        } else {
            this.alert_queue.addElement(id);
            String title = StringUtility.substitute((String)topicViewBundle.getString("n_alerts_waiting"), (String)"__MACRO__", (String)String.valueOf(this.alert_queue.size()));
            this.setTitle(title);
            this.getAccessibleContext().setAccessibleDescription(title);
        }
    }

    private final void setAlertTabFocus() {
        this.setNewIndex(this.queue.indexOf(TopicManager.ID_TOPIC_ALERT_ID));
    }

    private final void setTopicTitle(String t) {
        this._title = t;
        if (this.tabs.getSelectedIndex() < 0 || this.queue.size() <= 0) {
            String title = topicViewBundle.getString("TopicView_Title_Empty");
            this.setTitle(title);
            this.getAccessibleContext().setAccessibleDescription(title);
            return;
        }
        NewsChannel top = TopicManager.getTopic((String)this.queue.elementAt(this.tabs.getSelectedIndex()));
        if (top == null) {
            String title = topicViewBundle.getString("topicView_offline");
            this.setTitle(title);
            this.getAccessibleContext().setAccessibleDescription(title);
            return;
        }
        String newTitle = new String();
        newTitle = this._isPaused && iIMPropsUtil.isRotateTopicEnabled(CurrentUserManager.getCurrentUserProperties()) ? StringUtility.substitute((String)topicViewBundle.getString("TopicView_title_paused"), (String)"__MACRO1__", (String)top.getDestination()) : StringUtility.substitute((String)topicViewBundle.getString("TopicView_title"), (String)"__MACRO1__", (String)top.getDestination());
        newTitle = StringUtility.substitute((String)newTitle, (String)"__MACRO2__", (String)t);
        this.setTitle(newTitle);
        this.getAccessibleContext().setAccessibleDescription(newTitle);
    }

    private final void refreshTopicMessages() {
        this.setCurrentObject(null);
        this.currentMsgId = null;
        int index = this.tabs.getSelectedIndex();
        if (index < 0 || this.queue.size() <= 0) {
            this.setCurrentObject(new MessageObject(new Vector(1), "empty"));
            return;
        }
        String id = (String)this.queue.elementAt(index);
        Vector ids = Manager.getVectorFromArray(TopicManager.getTopicMessageIds(id));
        if (ids == null) {
            Manager.Out("Bulletin Board Was Not Found " + id);
            this.setCurrentObject(new MessageObject(new Vector(1), "empty"));
            return;
        }
        for (int n = 0; n < this.ignoreMsg.size(); ++n) {
            if (!ids.contains(this.ignoreMsg.elementAt(n))) continue;
            ids.removeElement(this.ignoreMsg.elementAt(n));
        }
        this.setCurrentObject(new MessageObject(ids, id));
    }

    private final void removeTab(String id) {
        int num;
        Manager.Out("DEBUG TopicView.removeTab(): id: " + id);
        if (this.tabs.getTabCount() < 1) {
            return;
        }
        if (this.tabs.getTabCount() == 1) {
            this.createTab(null);
        }
        if ((num = this.queue.indexOf(id)) >= 0) {
            int x = this.tabs.getSelectedIndex();
            if (x == num) {
                this.setNewIndex(0);
            }
            this.queue.removeElementAt(num);
            this.tabs.removeTabAt(num);
        }
        if (this.tabs.isVisible()) {
            ((MessagePanel)this.tabs.getSelectedComponent()).setViewportView(this.txtMessage);
        } else {
            this.scroller.setViewportView(this.txtMessage);
        }
    }

    private final boolean shouldUpdate(Message m) {
        if (!this.messageUpdate.containsKey(m.getMessageId())) {
            this.messageUpdate.put(m.getMessageId(), new Long(1L));
        }
        Long n = (Long)this.messageUpdate.get(m.getMessageId());
        if (System.currentTimeMillis() > n) {
            this.messageUpdate.put(m.getMessageId(), new Long(System.currentTimeMillis()));
            return true;
        }
        return false;
    }

    private final void doPause(boolean b) {
        if (this._isMoveLocked) {
            return;
        }
        this._isPaused = b;
        this.setTopicTitle(this._title);
        if (this._isPaused) {
            this.btnPause.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_play.png", (Object)this));
            this.btnPause.setToolTipText(topicViewBundle.getString("TopicView_play_pause"));
        } else {
            this.btnPause.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_pause.png", (Object)this));
            this.btnPause.setToolTipText(topicViewBundle.getString("TopicView_pause_messages"));
        }
    }

    public void updatePauseButton() {
        boolean doLooping = iIMPropsUtil.isRotateTopicEnabled(CurrentUserManager.getCurrentUserProperties());
        this.btnPause.setEnabled(doLooping);
        Manager.Out("updatePauseButton, doLooping: " + doLooping);
        this._isPaused = true;
        this.btnPause.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_play.png", (Object)this));
    }

    private final void goForward() {
        if (this.isUpdating()) {
            return;
        }
        this.update();
    }

    private final void gomiPrevious() {
        if (this.isUpdating() || this.currentObject == null) {
            return;
        }
        if (this.currentObject.setToPreviousMessage()) {
            if (!iIMPropsUtil.isRotateTopicEnabled(CurrentUserManager.getCurrentUserProperties())) {
                this.currentObject.setToLastMessage();
                this.displayMessage(this.currentObject.getMessage());
                return;
            }
            int x = this.tabs.getSelectedIndex();
            x = x == 0 ? this.tabs.getTabCount() - 1 : --x;
            this.setNewIndex(x);
            this.currentObject.setToLastMessage();
            this.displayMessage(this.currentObject.getMessage());
        } else {
            this.update();
        }
    }

    private final void markMessage() {
        Manager.Out("  DEBUG TOPIC: MARK MSG SEEN");
        if (this.currentObject == null) {
            return;
        }
        Message m = this.currentObject.getMessage();
        if (m == null) {
            return;
        }
        this.ignoreMsg.addElement(m.getMessageId());
        this.update();
    }

    private void highlightTab() {
    }

    private final void markRead() {
        Message m = TopicManager.getTopicMessage(TopicManager.ID_TOPIC_ALERT_ID, this.currentMsgId);
        if (m == null) {
            this.tabs.setAlertAt(this.tabs.getSelectedIndex(), false);
            return;
        }
        if (!iIMPropsUtil.isTopicOnTopEnabled(CurrentUserManager.getCurrentUserProperties())) {
            this.setOnTop(false);
        }
        ClientMessageFactory.markMessage(m, 7);
        if (this.alert_queue.size() > 0) {
            this.currentMsgId = (String)this.alert_queue.firstElement();
            this.alert_queue.removeElementAt(0);
            this.newAlertMessage(this.currentMsgId);
        } else {
            this.tabs.setAlertAt(this.tabs.getSelectedIndex(), false);
        }
    }

    private final void setToolsVisible(boolean b) {
        this.pnlButtons.setEnabled(b);
        this.pnlButtons.setVisible(b);
        iIMPropsUtil.setHideTopicToolsEnabled(CurrentUserManager.getCurrentUserProperties(), !b);
    }

    private final void viewSource() {
        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(this.txtMessage), topicViewBundle.getString("miViewSource"));
    }

    private final void removeListeners() {
        this.txtMessage.removeMouseListener(this.popupListener);
        this.popup.removePopupMenuListener(this.popupListener);
        this.btnLeft.removeActionListener(this);
        this.btnPause.removeActionListener(this);
        this.btnRight.removeActionListener(this);
        this.btnPost.removeActionListener(this);
        this.btnDelete.removeActionListener(this);
        this.tabs.removeChangeListener(this);
        this.btnSettings.removeActionListener(this);
        if (Manager.ALLOW_NEWS_MANAGEMENT) {
            this.btnManage.removeActionListener(this);
        }
        this.btnClose.removeActionListener(this);
        this.btnHelp.removeActionListener(this);
        this.btnSubscribe.removeActionListener(this);
        this.btnCommunicator.removeActionListener(this);
        if (this.popup != null) {
            this.miNext.removeActionListener(this);
            this.miPrevious.removeActionListener(this);
            this.miMarkAsSeen.removeActionListener(this);
            this.miPostNewMsg.removeActionListener(this);
            this.miScroll.removeActionListener(this);
            this.miViewSource.removeActionListener(this);
            this.miSettings.removeActionListener(this);
            this.miHideTools.removeActionListener(this);
            this.miSave.removeActionListener(this);
            if (Manager.ALLOW_CHAT) {
                this.miReply.removeActionListener(this);
            }
            this.miPrint.removeActionListener(this);
            this.miEdit.removeActionListener(this);
        }
    }

    public void dispose() {
        this.tabs.removeAll();
        this.removeListeners();
        --_openedTopics;
        this.timer.stop();
        this.setVisible(false);
        this.attachments.dispose();
        super.dispose();
    }

    public final void refresh() {
        if (this.timer != null) {
            iIMPropsUtil.setTopicWindowPoint(CurrentUserManager.getCurrentUserProperties(), this.getLocation());
            iIMPropsUtil.setTopicWindowDim(CurrentUserManager.getCurrentUserProperties(), this.getSize());
            iIMPropsUtil.setHideTopicToolsEnabled(CurrentUserManager.getCurrentUserProperties(), !this.pnlButtons.isVisible());
        }
    }

    public final void close(boolean validate) {
        if (iIMPropsUtil.isTopicCloseLocked(CurrentUserManager.getCurrentUserProperties())) {
            this.setVisible(true);
            return;
        }
        if (validate && ApplicationManager.isLastActiveObject()) {
            if (iIM.canExit(this)) {
                iIM.exit(this);
            }
        } else {
            this.dispose();
        }
    }

    private final void saveTopic() {
        Manager.Out("  DEBUG TOPIC: SaveTopic()");
        if (this.currentObject == null) {
            return;
        }
        Message m = this.currentObject.getMessage();
        if (m == null) {
            JOptionPane.showMessageDialog(this, topicViewBundle.getString("Error_saving_content"));
        } else {
            String txt = EditorUtility.getHtmlDocumentText(this.txtMessage);
            File f = StickyFileChooser.chooseSaveFile(this, m.getHeader("subject"), ".html", commonBundle.getString("HTML_Files"));
            if (f == null) {
                return;
            }
            FileUtility.save((File)f, (String)txt, (Worker)Manager.worker);
        }
    }

    private final void showProperties() {
        Manager.Out("    DEBUG TOPIC: Show Props");
        if (this.currentObject == null || this.currentObject.isEmpty()) {
            return;
        }
        iIMUtility.showMessageProperties(this.currentObject.getMessage());
    }

    private final void forwardMsg() {
        try {
            Manager.Out("  DEBUG TOPIC: forwardMsg()");
            if (!UserAccessControl.canSendAlerts()) {
                JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
            } else {
                if (this.currentObject == null) {
                    return;
                }
                Message m = this.currentObject.getMessage();
                if (m == null) {
                    return;
                }
                iIM.AddMsg(m);
            }
        }
        catch (Exception e) {
            Manager.Out("Exception from cabSendAlerts()");
            JOptionPane.showMessageDialog(this, topicViewBundle.getString("Unknown_error_occurred"));
        }
    }

    private final void sendReply() {
        if (this.currentMsgId == null) {
            return;
        }
        String id = (String)this.queue.elementAt(this.tabs.getSelectedIndex());
        Message m = TopicManager.getTopicMessage(id, this.currentMsgId);
        CollaborationPrincipal[] tmp = new CollaborationPrincipal[]{UserCache.getPrincipal(m.getOriginator())};
        iIM.startNewChat(tmp);
    }

    private final void setScroll() {
        boolean b = iIMPropsUtil.isScrollTopicEnabled(CurrentUserManager.getCurrentUserProperties());
        iIMPropsUtil.setScrollTopicEnabled(CurrentUserManager.getCurrentUserProperties(), !b);
    }

    private final void addMsg() {
        Manager.Out("DEBUG: TopicView.addMsg()");
        if (this.queue.size() == 0) {
            return;
        }
        String q = (String)this.queue.elementAt(this.tabs.getSelectedIndex());
        NewsChannel t = TopicManager.getTopic(q);
        if (t.getDestination().equals(TopicManager.ID_TOPIC_ALERT_ID)) {
            return;
        }
        try {
            if (t != null) {
                if (!UserAccessControl.hasPrivilege((Conference)t, 4)) {
                    JOptionPane.showMessageDialog(this, topicViewBundle.getString("You_do_not_have_the_proper_privilege"));
                    return;
                }
                Vector<NewsChannel> vec = new Vector<NewsChannel>(2);
                vec.addElement(t);
                iIM.AddMsg(vec, null, 0);
            } else {
                JOptionPane.showMessageDialog(this, topicViewBundle.getString("Could_not_find_topic") + t);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, topicViewBundle.getString("Unknown_error_occurred_1"));
        }
    }

    private final void deleteMsg() {
        Manager.Out("DEBUG: TopicView.deleteMsg()");
        if (this.queue.size() == 0) {
            return;
        }
        String q = (String)this.queue.elementAt(this.tabs.getSelectedIndex());
        NewsChannel t = TopicManager.getTopic(q);
        if (t.getDestination().equals(TopicManager.ID_TOPIC_ALERT_ID)) {
            return;
        }
        try {
            if (t != null) {
                if (!UserAccessControl.hasPrivilege((Conference)t, 30)) {
                    JOptionPane.showMessageDialog(this, topicViewBundle.getString("You_do_not_have_manage_privileges_for"));
                    return;
                }
                try {
                    t.removeMessage(this.currentMsgId);
                    this.goForward();
                }
                catch (CollaborationException ne) {
                    JOptionPane.showMessageDialog(this, ne.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this, topicViewBundle.getString("Could_not_find_topic") + t);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, topicViewBundle.getString("Unknown_error_occurred_1"));
        }
    }

    private void editMessage() {
        if (this.queue.size() == 0) {
            return;
        }
        int index = this.tabs.getSelectedIndex();
        String id = (String)this.queue.elementAt(index);
        try {
            if (!UserAccessControl.hasPrivilege((Conference)TopicManager.getTopic(id), 30)) {
                String msg = topicViewBundle.getString("You_must_have_manage_privileges_to");
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, topicViewBundle.getString("Unknown_error_occurred_2"));
        }
        NewsChannel t = TopicManager.getTopic(id);
        Message m = TopicManager.getTopicMessage(id, this.currentMsgId);
        if (m == null) {
            return;
        }
        AddMsg am = new AddMsg(m, t);
    }

    public final void setVisible(boolean b) {
        if (b) {
            super.setVisible(b);
            this._isMoveLocked = iIMPropsUtil.isTopicMoveLocked(CurrentUserManager.getCurrentUserProperties());
            this.setResizable(!iIMPropsUtil.isTopicResizeLocked(CurrentUserManager.getCurrentUserProperties()));
            this.setTabPlacement();
            this.toggleTabs(iIMPropsUtil.isHideTopicTabEnabled(CurrentUserManager.getCurrentUserProperties()));
            this.setToolsVisible(!iIMPropsUtil.isHideTopicToolsEnabled(CurrentUserManager.getCurrentUserProperties()));
            Dimension d = iIMPropsUtil.getTopicWindowDim(CurrentUserManager.getCurrentUserProperties());
            Manager.Out("d.width: " + d.width);
            if (d.width < this.minWidthSoAllButtonsShow) {
                d.width = this.minWidthSoAllButtonsShow;
            }
            this.setSize(new Dimension(500, 320));
            this.invalidate();
            this.validate();
            this.setOnTop(iIMPropsUtil.isTopicOnTopEnabled(CurrentUserManager.getCurrentUserProperties()));
        } else {
            this.refresh();
            super.setVisible(b);
        }
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public final void actionPerformed(ActionEvent event) {
        if (this.getCurrentMessageView().IS_SCROLLING) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object object = event.getSource();
        if (object == this.timer) {
            if (this.isUpdating() || this._isPaused) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (iIMPropsUtil.isRotateTopicEnabled(CurrentUserManager.getCurrentUserProperties())) {
                this.update();
            }
        } else if (object == this.btnLeft) {
            this.gomiPrevious();
        } else if (object == this.btnPause) {
            this.doPause(!this._isPaused);
        } else if (object == this.btnRight) {
            this.goForward();
        } else if (object == this.btnSettings) {
            iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
        } else if (Manager.ALLOW_NEWS_MANAGEMENT && object == this.btnManage) {
            iIM.openTopicManager();
        } else if (object == this.btnClose) {
            this.close(true);
        } else if (object == this.btnHelp || object == this.miHelp) {
            HelpManager.showHelp("viewtopics");
        } else if (object == this.btnSubscribe) {
            iIM.showTopicSubscription();
        } else if (object == this.btnCommunicator) {
            iIM.showBuddyList(false);
        } else if (object == this.btnPost) {
            this.addMsg();
        } else if (object == this.btnDelete) {
            this.deleteMsg();
        } else if (object instanceof JMenuItem) {
            this.doPause(false);
            if (object == this.miNext) {
                this.goForward();
            } else if (object == this.miPrevious) {
                this.gomiPrevious();
            } else if (object == this.miPostNewMsg) {
                this.addMsg();
            } else if (object == this.miHideTools) {
                this.setToolsVisible(!this.pnlButtons.isVisible());
            } else if (object == this.miMarkAsSeen) {
                this.markMessage();
            } else if (object == this.miViewSource) {
                this.viewSource();
            } else if (object == this.miSettings) {
                iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
            } else if (object == this.miManage) {
                iIM.openTopicManager();
            } else if (object == this.miSubscribe) {
                iIM.showTopicSubscription();
            } else if (object == this.miCommunicator) {
                iIM.showBuddyList(false);
            } else if (object == this.miSave) {
                this.saveTopic();
            } else if (Manager.ALLOW_CHAT && object == this.miReply) {
                this.sendReply();
            } else if (Manager.ALLOW_SEND_ALERTS && object == this.miForward) {
                this.forwardMsg();
            } else if (object == this.miProperties) {
                this.showProperties();
            } else if (object == this.miScroll) {
                this.setScroll();
            } else if (object == this.miHideTabs) {
                this.toggleTabs();
            } else if (object == this.miTabNorth) {
                this.setTabPosition(1);
            } else if (object == this.miTabSouth) {
                this.setTabPosition(3);
            } else if (object == this.miTabEast) {
                this.setTabPosition(4);
            } else if (object == this.miTabWest) {
                this.setTabPosition(2);
            } else if (object == this.miEdit) {
                this.editMessage();
            } else if (object == this.miClose) {
                this.close(true);
            } else if (object == this.miPrint) {
                iIMUtility.printDoc(this, this.getTitle(), this.txtMessage);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void updateButtonsforTab() {
        Manager.Out("DEBUG: TopicView.updateButtonsforTab()");
        this.btnPost.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (this.queue.size() == 0) {
            return;
        }
        String q = (String)this.queue.elementAt(this.tabs.getSelectedIndex());
        if (TopicManager.ID_TOPIC_ALERT_ID.equals(q)) {
            return;
        }
        NewsChannel t = TopicManager.getTopic(q);
        if (UserAccessControl.hasPrivilege((Conference)t, 30)) {
            this.btnDelete.setEnabled(true);
            this.btnPost.setEnabled(true);
        }
        this.btnPost.setEnabled(UserAccessControl.hasPrivilege((Conference)t, 4));
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.tabs) {
            this.changeTab();
        }
    }

    public static int getOpenedTopicsCount() {
        return _openedTopics;
    }

    public void addMessage(String id, Message message) {
        Manager.Out("Topic Id: " + id);
        if (!this.queue.contains(id)) {
            return;
        }
        if (!_channelsWithNewMessage.contains(id)) {
            _channelsWithNewMessage.addElement(id);
            if (id != TopicManager.ID_ALERT_ID) {
                Sound.play(6);
                this.flashOnce();
                for (int i = 0; i < _channelsWithNewMessage.size(); ++i) {
                    String tab = (String)_channelsWithNewMessage.elementAt(i);
                    int index = this.queue.indexOf(tab);
                    Manager.Out("TopicView.SubscriptionEventRunnable(): Event is NEWTOPICMESSAGE, trying to blink: " + tab + " at index:" + index);
                    this.tabs.setAlertAt(index, true);
                }
            }
        }
        if (message == null) {
            return;
        }
        ClientMessageFactory.printMessage(message);
        TopicManager.addTopicMessage(id, message, true);
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopicView.this.close(true);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class PopupListener
    extends MouseAdapter
    implements PopupMenuListener {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (TopicView.this.queue.size() == 0) {
                return;
            }
            String tmp = (String)TopicView.this.queue.elementAt(TopicView.this.tabs.getSelectedIndex());
            _channelsWithNewMessage.removeElement(tmp);
            TopicView.this.markRead();
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                TopicView.this.popup.show(e.getComponent(), new Point(e.getX(), e.getY()));
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            TopicView.this.popup.removeAll();
            TopicView.this.popup.revalidate();
            TopicView.this.buildMenus();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            TopicView.this.popup.removeAll();
            TopicView.this.popup.revalidate();
            if (!TopicView.this._isMoveLocked) {
                if (TopicView.this.tabs.isVisible()) {
                    TopicView.this.popup.add(TopicView.this.miTabNorth);
                    TopicView.this.popup.add(TopicView.this.miTabSouth);
                    TopicView.this.popup.add(TopicView.this.miTabEast);
                    TopicView.this.popup.add(TopicView.this.miTabWest);
                }
                TopicView.this.popup.add(TopicView.this.miHideTabs);
            }
            TopicView.this.popup.addSeparator();
            int index = TopicView.this.tabs.getSelectedIndex();
            String id = (String)TopicView.this.queue.elementAt(index);
            Message m = TopicManager.getTopicMessage(id, TopicView.this.currentMsgId);
            if (m != null) {
                if (Manager.ALLOW_CHAT) {
                    TopicView.this.popup.add(TopicView.this.miReply);
                    TopicView.this.popup.addSeparator();
                }
                TopicView.this.popup.add(TopicView.this.miMarkAsSeen);
            }
            if (!TopicView.this._isMoveLocked) {
                TopicView.this.popup.add(TopicView.this.miScroll);
                TopicView.this.popup.addSeparator();
            }
            if (!TopicView.this.tabs.getTitleAt(index).equals(TopicManager.ID_ALERT_ID)) {
                TopicView.this.popup.add(TopicView.this.miPostNewMsg);
            }
            if (!TopicView.this._isMoveLocked) {
                TopicView.this.popup.add(TopicView.this.miHideTools);
                TopicView.this.popup.add(TopicView.this.miProperties);
                if (Manager.ALLOW_SEND_ALERTS) {
                    TopicView.this.popup.add(TopicView.this.miForward);
                }
                TopicView.this.popup.add(TopicView.this.miViewSource);
                if (Manager.ALLOW_SETTINGS_CHANGES) {
                    TopicView.this.popup.add(TopicView.this.miSettings);
                }
            }
            if (!TopicView.this._isMoveLocked && !iIMPropsUtil.isTopicResizeLocked(CurrentUserManager.getCurrentUserProperties())) {
                TopicView.this.popup.add(TopicView.this.miEdit);
            }
            TopicView.this.popup.addSeparator();
            TopicView.this.popup.add(TopicView.this.miSave);
            if (!TopicView.this._isMoveLocked) {
                TopicView.this.popup.add(TopicView.this.miPrint);
            }
        }
    }

    private class SubscriptionEventRunnable
    implements Runnable {
        private SubscriptionEvent evt;

        public SubscriptionEventRunnable(SubscriptionEvent evt) {
            this.evt = evt;
        }

        public void run() {
            Manager.Out("DEBUG TopicView.SubscriptionEventRunnable(): Channel id: " + this.evt.getName() + " - Event type: " + this.evt.getType());
            String id = this.evt.getName();
            if (this.evt.getType() == 0) {
                if (TopicView.this.queue.contains(id)) {
                    return;
                }
                TopicView.this.subscribe(id);
                TopicView.this.createTab(id);
            } else if (this.evt.getType() == 1) {
                _channelsWithNewMessage.removeElement(id);
                TopicView.this.removeTab(id);
            } else if (this.evt.getType() == 2) {
                TopicView.this.addMessage(id, null);
            } else if (this.evt.getType() != 3 && this.evt.getType() != 4 && this.evt.getType() == 5 && this.evt.getName().equals(TopicManager.ID_ALERT_ID)) {
                if (TopicManager.isTopicAlertChannelEnabled()) {
                    if (TopicManager.isTopicSubscribed(TopicManager.ID_TOPIC_ALERT_ID) && !TopicView.this.queue.contains(TopicManager.ID_TOPIC_ALERT_ID)) {
                        TopicView.this.createTab(TopicManager.ID_TOPIC_ALERT_ID, 0);
                    }
                } else {
                    TopicView.this.removeTab(TopicManager.ID_TOPIC_ALERT_ID);
                }
                TopicView.this.refreshTopicMessages();
            }
        }
    }

    class NewsChannelListenerImpl
    implements NewsChannelListener {
        String id;

        NewsChannelListenerImpl(String str) {
            this.id = str;
        }

        public void onMessageModified(String messageId, Message message) {
            TopicManager.removeTopicMessage(this.id, message);
            TopicView.this.addMessage(this.id, message);
        }

        public void onMessageRemoved(String messageId) {
            Message m = TopicManager.getTopicMessage(this.id, messageId);
            TopicManager.removeTopicMessage(this.id, m);
        }

        public void onMessageAdded(Message message) {
            TopicView.this.addMessage(this.id, message);
        }

        public void onEvent(String event) {
            Manager.Out(" onEvent called : " + event);
        }

        public void onError(CollaborationException e) {
            Manager.Out("onError called");
            e.printStackTrace();
        }

        public void onModeratedMessageAdded(Message message) {
        }

        public void onModeratedMessageStatus(Message message, int status, String reason) {
        }
    }
}

