/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.topic;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.NewsChannel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TopicSubscriptionPanel
extends JPanel
implements ActionListener {
    private Vector subscriptions = new Vector(10);
    private iIMListModel subscriptionModel;
    private Vector topicList;
    private SymMouse aSymMouse = new SymMouse();
    private iIMListModel topicModel;
    Vector old_list = new Vector();
    JPanel pnlTopics = new JPanel();
    JLabel lblTopics = new JLabel();
    JScrollPane scrTopics = new JScrollPane();
    JList lstTopics = new JList();
    JPanel pnlButtons = new JPanel();
    JButton btnRemoveTopic = new JButton();
    JButton btnAddTopic = new JButton();
    JPanel pnlSubscribe = new JPanel();
    JLabel lblSubscribe = new JLabel();
    JScrollPane scrSubscribe = new JScrollPane();
    JList lstSubscribed = new JList();
    static SafeResourceBundle topicSubscriptionPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.topic.topic");

    public TopicSubscriptionPanel() {
        this.setToolTipText(topicSubscriptionPanelBundle.getString("TopicSubscriptionPanel_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("TopicSubscriptionPanel_toolTipText") : null);
        this.setLayout(new GridBagLayout());
        this.setSize(384, 344);
        this.pnlTopics.setToolTipText(topicSubscriptionPanelBundle.getString("pnlTopics_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("pnlTopics_toolTipText") : null);
        this.pnlTopics.setLayout(new GridBagLayout());
        this.add((Component)this.pnlTopics, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.lblTopics.setLabelFor(this.lstTopics);
        this.lblTopics.setDisplayedMnemonic(topicSubscriptionPanelBundle.getString("lblTopics_text_M").charAt(0));
        this.lblTopics.setText(topicSubscriptionPanelBundle.getString("lblTopics_text"));
        this.lblTopics.setToolTipText(topicSubscriptionPanelBundle.getString("lblTopics_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("lblTopics_toolTipText") : null);
        this.lblTopics.setLabelFor(this.lstTopics);
        this.pnlTopics.add((Component)this.lblTopics, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.scrTopics.setOpaque(true);
        this.scrTopics.setToolTipText(topicSubscriptionPanelBundle.getString("scrTopics_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("scrTopics_toolTipText") : null);
        this.pnlTopics.add((Component)this.scrTopics, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.lstTopics.setToolTipText(topicSubscriptionPanelBundle.getString("lstTopics_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("lstTopics_toolTipText") : null);
        this.scrTopics.setViewportView(this.lstTopics);
        this.lstTopics.setBounds(0, 0, 118, 310);
        this.pnlButtons.setToolTipText(topicSubscriptionPanelBundle.getString("pnlButtons_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("pnlButtons_toolTipText") : null);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.add((Component)this.pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        SwingUtils.setupButton(this.btnRemoveTopic, topicSubscriptionPanelBundle, "btnRemoveTopic_text", "btnRemoveTopic_text_M", "btnRemoveTopic_actionCommand", "btnRemoveTopic_toolTipText");
        this.pnlButtons.add((Component)this.btnRemoveTopic, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        SwingUtils.setupButton(this.btnAddTopic, topicSubscriptionPanelBundle, "btnAddTopic_text", "btnAddTopic_text_M", "btnAddTopic_actionCommand", "btnAddTopic_toolTipText");
        this.pnlButtons.add((Component)this.btnAddTopic, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.pnlSubscribe.setToolTipText(topicSubscriptionPanelBundle.getString("pnlSubscribe_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("pnlSubscribe_toolTipText") : null);
        this.pnlSubscribe.setLayout(new GridBagLayout());
        this.add((Component)this.pnlSubscribe, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.lblSubscribe.setText(topicSubscriptionPanelBundle.getString("lblSub_text"));
        this.lblSubscribe.setLabelFor(this.lstSubscribed);
        this.lblSubscribe.setDisplayedMnemonic(topicSubscriptionPanelBundle.getString("lblSub_text_M").charAt(0));
        this.lblSubscribe.setToolTipText(topicSubscriptionPanelBundle.getString("lblSub_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("lblSub_toolTipText") : null);
        this.lblSubscribe.setLabelFor(this.lstSubscribed);
        this.pnlSubscribe.add((Component)this.lblSubscribe, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.scrSubscribe.setOpaque(true);
        this.scrSubscribe.setToolTipText(topicSubscriptionPanelBundle.getString("scrSub_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("scrSub_toolTipText") : null);
        this.pnlSubscribe.add((Component)this.scrSubscribe, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.lstSubscribed.setToolTipText(topicSubscriptionPanelBundle.getString("lstSubscribed_toolTipText").length() != 0 ? topicSubscriptionPanelBundle.getString("lstSubscribed_toolTipText") : null);
        this.scrSubscribe.setViewportView(this.lstSubscribed);
        this.lstSubscribed.setBounds(0, 0, 148, 310);
        this.subscriptions = Manager.getVectorFromArray(TopicManager.getSubscribedTopicIDs());
        this.old_list = (Vector)this.subscriptions.clone();
        this.refresh();
        this.subscriptionModel = new iIMListModel(this.lstSubscribed, this.subscriptions);
        this.topicModel = new iIMListModel(this.lstTopics, this.topicList);
        this.lstSubscribed.setModel(this.subscriptionModel);
        this.lstTopics.setModel(this.topicModel);
        this.lstTopics.addMouseListener(this.aSymMouse);
        this.lstSubscribed.addMouseListener(this.aSymMouse);
        this.btnRemoveTopic.addActionListener(this);
        this.btnAddTopic.addActionListener(this);
        Insets ins = new Insets(0, 0, 0, 0);
        this.btnRemoveTopic.setMargin(ins);
        this.btnAddTopic.setMargin(ins);
        this.lstSubscribed.getSelectionModel().setSelectionMode(0);
        this.lstTopics.getSelectionModel().setSelectionMode(0);
        Manager.worker.addRunnable((Runnable)new RefreshTopicsThread());
    }

    public final void refresh() {
        this.lstSubscribed.getSelectionModel().clearSelection();
        this.lstTopics.getSelectionModel().clearSelection();
        Object[] tmp = TopicManager.getTopicIds();
        this.topicList = Manager.getVectorFromArray(tmp);
        for (int n = 0; n < tmp.length; ++n) {
            Object id = tmp[n];
            if (!this.subscriptions.contains(id)) continue;
            this.topicList.removeElement(id);
        }
        if (this.topicModel != null) {
            this.topicModel.changed(this.topicList);
        }
        if (this.subscriptionModel != null) {
            this.subscriptionModel.changed(this.subscriptions);
        }
    }

    private final void addSubscription() {
        if (this.lstTopics.isSelectionEmpty()) {
            return;
        }
        int n = this.lstTopics.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String topicName = (String)this.topicList.elementAt(n);
        if (!this.subscriptions.contains(topicName)) {
            this.subscriptions.addElement(topicName);
            NewsChannel t = TopicManager.getTopic(topicName);
            try {
                TopicManager.addSubscribedTopic(topicName);
                this.subscriptionModel.changed();
                iIM.fireSubscriptionListeners(topicName, 0, null);
            }
            catch (CollaborationException e) {
                System.out.println("Failed to subscribe to topic: " + topicName + " - " + e.getMessage());
                e.printStackTrace();
                this.subscriptions.remove(topicName);
                TopicManager.clearCachedTopic(topicName);
                JOptionPane.showMessageDialog(this, topicSubscriptionPanelBundle.getString("This_topic_has_been_removed"));
            }
            this.refresh();
        }
    }

    private final void removeSubscription() {
        if (this.lstSubscribed.isSelectionEmpty()) {
            return;
        }
        int n = this.lstSubscribed.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String topicID = (String)this.subscriptions.elementAt(n);
        iIM.fireSubscriptionListeners(topicID, 1, null);
        this.subscriptions.removeElementAt(n);
        TopicManager.removeSubscribedTopic(topicID);
        this.refresh();
    }

    public final void close() {
        this.btnRemoveTopic.removeActionListener(this);
        this.btnAddTopic.removeActionListener(this);
        this.lstTopics.removeMouseListener(this.aSymMouse);
        this.lstSubscribed.removeMouseListener(this.aSymMouse);
    }

    public String[] getSubscriptions() {
        Object[] ret = new String[this.subscriptions.size()];
        this.subscriptions.copyInto(ret);
        return ret;
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        if (event.getSource() == this.btnRemoveTopic) {
            this.removeSubscription();
        } else if (event.getSource() == this.btnAddTopic) {
            this.addSubscription();
        }
        this.setCursor(new Cursor(0));
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getSource() == TopicSubscriptionPanel.this.lstSubscribed) {
                if (event.getClickCount() > 1) {
                    TopicSubscriptionPanel.this.removeSubscription();
                } else if (event.getSource() == TopicSubscriptionPanel.this.lstTopics && event.getClickCount() > 1) {
                    TopicSubscriptionPanel.this.addSubscription();
                }
            }
        }
    }

    class RefreshTopicsThread
    implements Runnable {
        RefreshTopicsThread() {
        }

        public void run() {
            TopicManager.getTopicsFromServer(CurrentUserManager.getCurrentUserServer());
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ RefreshTopicsThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    RefreshTopicsThread.access$000(this.this$1).refresh();
                }
            });
        }

        static /* synthetic */ TopicSubscriptionPanel access$000(RefreshTopicsThread x0) {
            return x0.TopicSubscriptionPanel.this;
        }
    }
}

