/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.topic;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.swing.Alert;
import com.iplanet.im.client.swing.InstantMessageBar;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.dialogs.AddDestination;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TopicManagement
extends AutoOrientationJFrame
implements ActionListener {
    static SafeResourceBundle topicManagementBundle = new SafeResourceBundle("com.iplanet.im.client.swing.topic.topic");
    private iIMListModel topicmodel;
    private MsgListModel messagemodel = new MsgListModel();
    private Vector _messages = new Vector(10);
    private JFrame _parentFrame;
    private Vector topicList = new Vector();
    public static final String ID_SELECT_TOPIC_FIRST = topicManagementBundle.getString("Please_select_a_topic_first");
    public static final String ID_SURE_DELETE = topicManagementBundle.getString("Check_delete_news_channel");
    private static boolean _isTopicManagementOpened = false;
    SymWindow aSymWindow = new SymWindow();
    JPanel pnlNewsChannels;
    JLabel lblNewsChannels;
    JScrollPane scrNewsChannels;
    JList lstNewsChannels;
    JPanel pnlChannelMessages;
    JLabel lblChannelMessages;
    JScrollPane scrChannelMessages;
    JList lstChannelMessages;
    JPanel pnlOptions;
    JButton btnAdmin;
    JButton btnAddMsg;
    JButton btnDeleteMsg;
    JButton btnViewMsg;
    DialogButtonsPanel pnlButtons;

    public TopicManagement(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.pnlNewsChannels = new JPanel();
        this.lblNewsChannels = new JLabel();
        this.scrNewsChannels = new JScrollPane();
        this.lstNewsChannels = new JList();
        this.pnlChannelMessages = new JPanel();
        this.lblChannelMessages = new JLabel();
        this.scrChannelMessages = new JScrollPane();
        this.lstChannelMessages = new JList();
        this.pnlOptions = new JPanel();
        this.btnAdmin = new JButton();
        this.btnAddMsg = new JButton();
        this.btnDeleteMsg = new JButton();
        this.btnViewMsg = new JButton();
        this.pnlButtons = new DialogButtonsPanel(this, 3);
        this.pnlButtons.setCancelButtonLabel(4);
        String title = topicManagementBundle.getString("TopicManagement_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlNewsChannels.setToolTipText(topicManagementBundle.getString("pnlNewsChannels_toolTipText").length() != 0 ? topicManagementBundle.getString("pnlNewsChannels_toolTipText") : null);
        this.pnlNewsChannels.setLayout(new GridBagLayout());
        this.lblNewsChannels.setLabelFor(this.lstNewsChannels);
        this.lblNewsChannels.setDisplayedMnemonic(topicManagementBundle.getString("lblNewsChannels_text_M").charAt(0));
        this.lblNewsChannels.setText(topicManagementBundle.getString("lblNewsChannels_text"));
        this.lblNewsChannels.setToolTipText(topicManagementBundle.getString("lblNewsChannels_toolTipText").length() != 0 ? topicManagementBundle.getString("lblNewsChannels_toolTipText") : null);
        this.pnlNewsChannels.add((Component)this.lblNewsChannels, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrNewsChannels.setToolTipText(topicManagementBundle.getString("scrNewsChannels_toolTipText").length() != 0 ? topicManagementBundle.getString("scrNewsChannels_toolTipText") : null);
        this.lstNewsChannels.setToolTipText(topicManagementBundle.getString("lstNewsChannels_toolTipText").length() != 0 ? topicManagementBundle.getString("lstNewsChannels_toolTipText") : null);
        this.scrNewsChannels.setViewportView(this.lstNewsChannels);
        this.pnlNewsChannels.add((Component)this.scrNewsChannels, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlChannelMessages.setToolTipText(topicManagementBundle.getString("pnlChannelMessages_toolTipText").length() != 0 ? topicManagementBundle.getString("pnlChannelMessages_toolTipText") : null);
        this.pnlChannelMessages.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlNewsChannels, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(12, 12, 0, 0), 0, 0));
        this.lblChannelMessages.setDisplayedMnemonic(topicManagementBundle.getString("lblChannelMessages_text_M").charAt(0));
        this.lblChannelMessages.setLabelFor(this.lstChannelMessages);
        this.lblChannelMessages.setText(topicManagementBundle.getString("lblChannelMessages_text"));
        this.lblChannelMessages.setToolTipText(topicManagementBundle.getString("lblChannelMessages_toolTipText").length() != 0 ? topicManagementBundle.getString("lblChannelMessages_toolTipText") : null);
        this.pnlChannelMessages.add((Component)this.lblChannelMessages, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrChannelMessages.setToolTipText(topicManagementBundle.getString("scrChannelMessages_toolTipText").length() != 0 ? topicManagementBundle.getString("scrChannelMessages_toolTipText") : null);
        this.lstChannelMessages.setToolTipText(topicManagementBundle.getString("lstChannelMessages_toolTipText").length() != 0 ? topicManagementBundle.getString("lstChannelMessages_toolTipText") : null);
        this.scrChannelMessages.setViewportView(this.lstChannelMessages);
        this.pnlChannelMessages.add((Component)this.scrChannelMessages, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pnlChannelMessages, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(12, 5, 0, 12), 0, 0));
        this.pnlOptions.setToolTipText(topicManagementBundle.getString("pnlOptions_toolTipText").length() != 0 ? topicManagementBundle.getString("pnlOptions_toolTipText") : null);
        SwingUtils.setupButton(this.btnAddMsg, topicManagementBundle, "btnAddMsg_text", "btnAddMsg_text_M", "btnAddMsg_actionCommand", "btnAddMsg_toolTipText");
        this.pnlNewsChannels.add((Component)this.btnAddMsg, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 0, 0, 0), 0, 0));
        SwingUtils.setupButton(this.btnAdmin, topicManagementBundle, "btnAdmin_text", "btnAdmin_text_M", "btnAdmin_actionCommand", "btnAdmin_toolTipText");
        this.pnlNewsChannels.add((Component)this.btnAdmin, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 5, 0, 0), 0, 0));
        SwingUtils.setupButton(this.btnViewMsg, topicManagementBundle, "btnView_text", "btnView_text_M", "btnView_actionCommand", "btnView_toolTipText");
        this.btnViewMsg.setEnabled(false);
        this.pnlChannelMessages.add((Component)this.btnViewMsg, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 0, 0, 0), 0, 0));
        SwingUtils.setupButton(this.btnDeleteMsg, topicManagementBundle, "btnDelete_text", "btnDelete_text_M", "btnDelete_actionCommand", "btnDelete_toolTipText");
        this.btnDeleteMsg.setEnabled(false);
        this.pnlChannelMessages.add((Component)this.btnDeleteMsg, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 13, 2, new Insets(17, 12, 12, 12), 0, 0));
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
        this.btnDeleteMsg.addActionListener(this);
        this.lstNewsChannels.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TopicManagement.this.btnAddMsg.setEnabled(false);
                if (UserAccessControl.canCreateTopic()) {
                    TopicManagement.this.btnAdmin.setEnabled(true);
                } else {
                    TopicManagement.this.btnAdmin.setEnabled(false);
                }
                if (!TopicManagement.this.lstNewsChannels.isSelectionEmpty()) {
                    if (TopicManagement.this.lstNewsChannels.getSelectedIndices().length == 1) {
                        TopicManagement.this.fillMessageList(false);
                        if (!TopicManagement.this.lstNewsChannels.getSelectedValue().equals(TopicManager.ID_TOPIC_ALERT_ID)) {
                            if (TopicManagement.this.canAccessAllInSelection(TopicManagement.this.lstNewsChannels, 4)) {
                                TopicManagement.this.btnAddMsg.setEnabled(true);
                            }
                            if (TopicManagement.this.canAccessAllInSelection(TopicManagement.this.lstNewsChannels, 30)) {
                                // empty if block
                            }
                        }
                    } else if (Arrays.asList(TopicManagement.this.lstNewsChannels.getSelectedValues()).indexOf(TopicManager.ID_TOPIC_ALERT_ID) == -1) {
                        if (TopicManagement.this.canAccessAllInSelection(TopicManagement.this.lstNewsChannels, 4)) {
                            TopicManagement.this.btnAddMsg.setEnabled(true);
                        }
                        if (TopicManagement.this.canAccessAllInSelection(TopicManagement.this.lstNewsChannels, 30)) {
                            // empty if block
                        }
                    }
                }
                TopicManagement.this.lstChannelMessages.clearSelection();
            }
        });
        this.lstChannelMessages.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TopicManagement.this.btnDeleteMsg.setEnabled(false);
                TopicManagement.this.btnViewMsg.setEnabled(false);
                if (!TopicManagement.this.lstChannelMessages.isSelectionEmpty()) {
                    int num = TopicManagement.this.lstChannelMessages.getSelectedIndices().length;
                    if (num == 1) {
                        TopicManagement.this.enableViewMessageButton();
                    }
                    TopicManagement.this.enableDeleteMessageButton();
                }
            }
        });
        this.btnAddMsg.addActionListener(this);
        this.btnViewMsg.addActionListener(this);
        this.addWindowListener(this.aSymWindow);
        this.btnAdmin.addActionListener(this);
        this.initBorders();
        this.initModels();
        if (TopicManager.getTopicCount() > 0) {
            this.lstNewsChannels.setSelectedIndex(0);
        }
        ApplicationManager.addActiveObject(this);
        _isTopicManagementOpened = true;
    }

    private final void initModels() {
        this.topicList = Manager.getVectorFromArray(TopicManager.getTopicIds());
        this.topicList = StringUtility.sort((Vector)StringUtility.sort((Vector)this.topicList));
        this.topicmodel = new iIMListModel(this.lstNewsChannels, this.topicList);
        this.lstNewsChannels.setModel(this.topicmodel);
        this.lstChannelMessages.setModel(this.messagemodel);
    }

    private final void initBorders() {
        Border lineBorder = BorderFactory.createEtchedBorder();
    }

    private final void refreshMsgList(NewsChannel t) {
        this.refreshMsgList(t.getDestination());
    }

    private final void refreshMsgList(String t) {
        this._messages.removeAllElements();
        this._messages = Manager.getVectorFromArray(TopicManager.getTopicMessages(t));
        if (this._messages == null) {
            this._messages = new Vector(1);
        }
        this.messagemodel.changed();
    }

    private final void fillMessageList(boolean update_topic) {
        String topic;
        Manager.Out("DEBUG: TopicManagement.fillMessageList()");
        if (update_topic && this.topicList.size() > 0) {
            this.lstNewsChannels.setSelectedIndex(0);
        }
        if ((topic = (String)this.topicList.elementAt(this.lstNewsChannels.getSelectedIndex())).equals(TopicManager.ID_TOPIC_ALERT_ID)) {
            this.refreshMsgList(TopicManager.ID_TOPIC_ALERT_ID);
        } else {
            NewsChannel t = TopicManager.getTopic(topic);
            this.refreshMsgList(t);
        }
    }

    public final void refresh(boolean update) {
        this.topicList = Manager.getVectorFromArray(TopicManager.getTopicIds());
        this.topicList = StringUtility.sort((Vector)StringUtility.sort((Vector)this.topicList));
        this.fillMessageList(update);
        this.topicmodel.changed(this.topicList);
    }

    private final void addNewMessage() {
        Vector<NewsChannel> vec = new Vector<NewsChannel>();
        if (this.lstNewsChannels.isSelectionEmpty()) {
            return;
        }
        int[] indices = this.lstNewsChannels.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            vec.addElement(TopicManager.getTopic((String)this.topicList.elementAt(indices[i])));
        }
        Alert.AddMsg(vec, null, 0);
    }

    private final void deleteMessages() {
        if (this.lstChannelMessages.isSelectionEmpty()) {
            return;
        }
        NewsChannel t = TopicManager.getTopic((String)this.lstNewsChannels.getSelectedValue());
        int[] indices = this.lstChannelMessages.getSelectedIndices();
        try {
            for (int i = 0; i < indices.length; ++i) {
                if (t.getDestination().equals(TopicManager.ID_TOPIC_ALERT_ID)) {
                    TopicManager.removeTopicMessage(TopicManager.ID_TOPIC_ALERT_ID, (Message)this._messages.elementAt(indices[i]));
                } else {
                    t.removeMessage(((Message)this._messages.elementAt(indices[i])).getMessageId());
                }
                this.refreshMsgList(t.getDestination());
                this.fillMessageList(false);
            }
        }
        catch (CollaborationException ne) {
            JOptionPane.showMessageDialog(this, ne.getMessage());
        }
    }

    private final void viewMessage() {
        if (this.lstChannelMessages.isSelectionEmpty() || this._messages.size() == 0) {
            return;
        }
        int n = this.lstChannelMessages.getSelectedIndex();
        Message m = (Message)this._messages.elementAt(n);
        new InstantMessageBar(m, 6);
    }

    private void enableDeleteMessageButton() {
        if (!this.lstNewsChannels.isSelectionEmpty() && this.canAccessAllInSelection(this.lstNewsChannels, 30)) {
            this.btnDeleteMsg.setEnabled(true);
        }
    }

    private void enableViewMessageButton() {
        if (!this.lstNewsChannels.isSelectionEmpty() && this.canAccessAllInSelection(this.lstNewsChannels, 2)) {
            this.btnViewMsg.setEnabled(true);
        }
    }

    private final void messageBoxChange() {
        if (this.lstChannelMessages.isSelectionEmpty()) {
            this.btnDeleteMsg.setEnabled(false);
            this.btnViewMsg.setEnabled(false);
            return;
        }
        this.enableDeleteMessageButton();
        this.enableViewMessageButton();
    }

    public void dispose() {
        _isTopicManagementOpened = false;
        ApplicationManager.removeActiveObject(this);
        super.dispose();
    }

    public static boolean isTopicManagementOpened() {
        return _isTopicManagementOpened;
    }

    public void close() {
        this.setVisible(false);
        Manager.saveAllPropertiesToServer(true, false);
        this.btnDeleteMsg.removeActionListener(this);
        this.btnAddMsg.removeActionListener(this);
        this.btnViewMsg.removeActionListener(this);
        this.removeWindowListener(this.aSymWindow);
        this.btnAdmin.removeActionListener(this);
        this.dispose();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.topicmodel.changed(this.topicList);
        }
        super.setVisible(b);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (object == this.btnDeleteMsg) {
            this.btnDelete_actionPerformed(event);
        } else if (object == this.btnAddMsg) {
            this.btnAddMsg_actionPerformed(event);
        } else if (object == this.btnViewMsg) {
            this.btnView_actionPerformed(event);
        } else if (object == this.btnAdmin) {
            this.btnAdmin_actionPerformed(event);
        } else if (actionCommand == "cancel") {
            this.btnClose_actionPerformed(event);
        } else if (actionCommand == "help") {
            HelpManager.showHelp("topicmanagement");
        }
    }

    void btnClose_actionPerformed(ActionEvent event) {
        this.close();
    }

    void btnDelete_actionPerformed(ActionEvent event) {
        this.deleteMessages();
    }

    void btnAddMsg_actionPerformed(ActionEvent event) {
        this.addNewMessage();
    }

    void btnView_actionPerformed(ActionEvent event) {
        this.viewMessage();
    }

    void TopicManagement_windowClosing(WindowEvent event) {
        this.close();
    }

    protected final void addNewDestination() {
        if (!UserAccessControl.canCreateTopic()) {
            JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
            return;
        }
        AddDestination addNewTopicDialog = new AddDestination(this._parentFrame, 0);
        addNewTopicDialog.setModal(true);
        addNewTopicDialog.setVisible(true);
        if (!addNewTopicDialog.hasOkBeenPressed()) {
            return;
        }
        if (addNewTopicDialog.getDestinationName().equals("")) {
            return;
        }
        String s = Manager.getValidDestinationName(addNewTopicDialog.getDestinationName());
        if (!iIM.addTopic(s, addNewTopicDialog.getServer(), addNewTopicDialog.getAccess())) {
            return;
        }
        this.topicmodel.changed();
    }

    void btnCreateTopic_actionPerformed(ActionEvent event) {
        this.addNewDestination();
    }

    boolean havePermissionOnAtLeastOneTopic(int permission) {
        Vector list = (Vector)this.topicList.clone();
        if (list.size() > 0 && UserAccessControl.isAdmin()) {
            return true;
        }
        for (int n = 0; n < list.size(); ++n) {
            String id = (String)list.elementAt(n);
            NewsChannel t = TopicManager.getTopic(id);
            if (!UserAccessControl.hasPrivilege((Conference)t, permission)) continue;
            return true;
        }
        return false;
    }

    boolean canAccessAllInSelection(JList theList, int permission) {
        boolean ok = true;
        int[] ind = theList.getSelectedIndices();
        if (ind.length <= 0) {
            return false;
        }
        if (UserAccessControl.isAdmin()) {
            Manager.Out(" User is admin");
            return true;
        }
        Vector list = (Vector)this.topicList.clone();
        for (int n = 0; n < ind.length; ++n) {
            NewsChannel t;
            String id = (String)list.elementAt(ind[n]);
            if (TopicManager.ID_TOPIC_ALERT_ID.equals(id) || UserAccessControl.hasPrivilege((Conference)(t = TopicManager.getTopic(id)), permission)) continue;
            ok = false;
        }
        return ok;
    }

    void btnDeleteTopic_actionPerformed(ActionEvent event) {
        int[] ind = this.lstNewsChannels.getSelectedIndices();
        if (ind.length <= 0) {
            JOptionPane.showMessageDialog(this, ID_SELECT_TOPIC_FIRST);
            return;
        }
        Vector list = (Vector)this.topicList.clone();
        int tmp = JOptionPane.showConfirmDialog(this._parentFrame, ID_SURE_DELETE, topicManagementBundle.getString("Delete_topic"), 0);
        if (tmp == 0) {
            for (int n = 0; n < ind.length; ++n) {
                String id = (String)list.elementAt(ind[n]);
                NewsChannel t = TopicManager.getTopic(id);
                if (UserAccessControl.hasPrivilege((Conference)t, 30)) {
                    iIM.deleteTopic(t);
                    continue;
                }
                String msg = topicManagementBundle.getString("You_do_not_have_the_privilege_to_delete");
                JOptionPane.showMessageDialog(this, msg);
            }
        }
        this.topicmodel.changed();
    }

    void btnAdmin_actionPerformed(ActionEvent event) {
        iIM.openDestinationAdmin(this._parentFrame, 0);
    }

    void TopicManagement_mouseMoved(MouseEvent event) {
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopicManagement.this.close();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseMoved(MouseEvent event) {
            Object object = event.getSource();
            if (object == TopicManagement.this) {
                TopicManagement.this.TopicManagement_mouseMoved(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TopicManagement.this) {
                TopicManagement.this.TopicManagement_windowClosing(event);
            }
        }
    }

    class MsgListModel
    extends AbstractListModel {
        MsgListModel() {
        }

        public int getSize() {
            return TopicManagement.this._messages.size();
        }

        public Object getElementAt(int index) {
            Message m = (Message)TopicManagement.this._messages.elementAt(index);
            String subj = ClientMessageFactory.getSubject(m);
            if (subj == null || "".equals(subj)) {
                subj = topicManagementBundle.getString("no_subject");
            }
            return subj;
        }

        public void changed() {
            this.fireContentsChanged(TopicManagement.this.lstChannelMessages, 0, 0);
        }
    }
}

