/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.poll;

import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.swing.poll.PollListModel;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.JFixedTextPane;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.StyleUtility;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.PollHelper;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PollUserView
extends iIMFrame {
    private SymMouse aSymMouse;
    private PollListModel answerModel;
    private Vector answerList;
    private Message message;
    private PollHelper helper = null;
    private boolean ALLOW_CUSTOM = false;
    private boolean markedRead = false;
    private JPanel pnlCustom;
    private JButton btnHelp;
    private JButton btnCancel;
    private JFixedTextPane txtQuestion;
    private JPanel pnlButtons;
    private JList lstAnswers;
    private JScrollPane scrollAnswers;
    private JButton btnOk;
    private JScrollPane scrollQuestion;
    private JLabel lblCustom;
    private JLabel lblAnswers;
    private JFixedTextField txtCustom;
    private static SafeResourceBundle pollUserViewBundle = new SafeResourceBundle("com.iplanet.im.client.swing.poll.poll");

    public PollUserView(Point p, Message m) {
        try {
            this.setFrameBlinking(true);
            this.setLocation(p);
            this.message = m;
            MessagePart[] parts = m.getParts();
            this.helper = new PollHelper(parts[0].getContent());
            this.answerList = new Vector();
            int noOfAnswers = this.helper.countAnswers();
            for (int i = 0; i < noOfAnswers; ++i) {
                Manager.Out(i + " " + this.helper.getAnswer(i));
                this.answerList.add(this.helper.getAnswer(i));
            }
            if (this.helper.isCustomAnswerAllowed() || this.answerList.size() == 0) {
                this.ALLOW_CUSTOM = true;
            }
            this.initComponents();
            ClientMessageFactory.markMessage(this.message, 1);
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws CollaborationException {
        this.scrollQuestion = new JScrollPane();
        this.txtQuestion = new JFixedTextPane();
        this.lblAnswers = new JLabel();
        this.scrollAnswers = new JScrollPane();
        this.lstAnswers = new JList();
        this.pnlCustom = new JPanel();
        this.lblCustom = new JLabel();
        this.txtCustom = new JFixedTextField();
        this.pnlButtons = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.btnHelp = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.setTitle(StringUtility.substitute((String)pollUserViewBundle.getString("PollUserView_Poll_from_"), (String)"__MACRO__", (String)UserCache.getDisplayName(this.message.getOriginator())));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PollUserView.this.dispose();
            }
        });
        this.txtQuestion.setEditable(false);
        this.txtQuestion.setLogicalStyle(StyleUtility.getPlainStyle());
        this.txtQuestion.setText(this.helper.getQuestion());
        this.scrollQuestion.setHorizontalScrollBarPolicy(31);
        this.scrollQuestion.setViewportView(this.txtQuestion);
        this.getContentPane().add((Component)this.scrollQuestion, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.lblAnswers.setText(pollUserViewBundle.getString("PollUserView_select"));
        this.lblAnswers.setLabelFor(this.scrollAnswers);
        this.getContentPane().add((Component)this.lblAnswers, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 2, 5), 0, 0));
        this.answerModel = new PollListModel(this.lstAnswers, this.answerList);
        this.lstAnswers.setModel(this.answerModel);
        this.lstAnswers.setSelectionMode(0);
        this.lstAnswers.setSelectedIndex(0);
        this.scrollAnswers.setViewportView(this.lstAnswers);
        this.getContentPane().add((Component)this.scrollAnswers, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 5, 2, 5), 0, 0));
        if (this.ALLOW_CUSTOM) {
            this.pnlCustom.setLayout(new GridBagLayout());
            this.lblCustom.setText(pollUserViewBundle.getString("PollUserView_custom"));
            this.lblCustom.setLabelFor(this.txtCustom);
            this.pnlCustom.add((Component)this.lblCustom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 2, 0), 0, 0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.pnlCustom.add((Component)this.txtCustom, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 0, 2, 0), 0, 0));
            this.getContentPane().add((Component)this.pnlCustom, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 2, 5), 0, 0));
        }
        this.pnlButtons.setLayout(new GridBagLayout());
        SwingUtils.setupButton(this.btnOk, pollUserViewBundle, "btnOk_text", "btnOk_text_M", null, null);
        this.pnlButtons.add((Component)this.btnOk, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 2, 5), 0, 0));
        SwingUtils.setupButton(this.btnCancel, pollUserViewBundle, "btnCancel_text", "btnCancel_text_M", null, null);
        this.pnlButtons.add((Component)this.btnCancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 5), 0, 0));
        SwingUtils.setupButton(this.btnHelp, pollUserViewBundle, "btnHelp_text", "btnHelp_text_M", null, null);
        this.pnlButtons.add((Component)this.btnHelp, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 0), 0, 0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 15, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(385, 230));
        this.setLocation((screenSize.width - 385) / 2, (screenSize.height - 230) / 2);
        this.setResizable(false);
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnHelp.addActionListener(this);
        this.aSymMouse = new SymMouse();
        this.addMouseListener(this.aSymMouse);
        this.setVisible(true);
        this.toFront();
        this.startBlinkThread();
    }

    private final String getAnswer() {
        if (this.ALLOW_CUSTOM && !this.txtCustom.getText().equals("")) {
            return this.txtCustom.getText();
        }
        if (this.lstAnswers.isSelectionEmpty() || this.answerList.size() == 0) {
            return "EMPTY";
        }
        int n = this.lstAnswers.getSelectedIndex();
        return (String)this.answerList.elementAt(n);
    }

    private final void sendReply() {
        try {
            Message reply = Manager._messageSession.createMessage(this.message.getOriginator());
            reply.setContentType("application/x-iim-poll-reply");
            MessagePart part = reply.newPart();
            part.setContent(this.helper.createResponse(this.getAnswer()));
            reply.addPart(part);
            this.message.sendReply(reply);
            this.dispose();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private final void removeListeners() {
        this.removeMouseListener(this.aSymMouse);
        this.btnOk.removeActionListener(this);
        this.btnCancel.removeActionListener(this);
        this.btnHelp.removeActionListener(this);
    }

    public final void dispose() {
        this.removeListeners();
        this.setVisible(false);
        super.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.btnOk) {
            this.sendReply();
        } else if (event.getSource() == this.btnCancel) {
            this.dispose();
        } else if (event.getSource() == this.btnHelp) {
            HelpManager.showHelp("pollfrom");
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseEntered(MouseEvent event) {
            Object object = event.getSource();
            if (object == PollUserView.this) {
                PollUserView.this.setFrameBlinking(false);
                if (!PollUserView.this.markedRead) {
                    ClientMessageFactory.markMessage(PollUserView.this.message, 7);
                    PollUserView.this.markedRead = true;
                }
            }
        }
    }
}

