/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.poll;

import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.MsgStatus;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.dialogs.InviteUsers;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.swing.poll.PollListModel;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Message;
import com.sun.im.service.Poll;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PollUserCreation
extends AutoOrientationJFrame
implements ActionListener {
    private SymKey aSymKey = new SymKey();
    private PollListModel answerListModel;
    private iIMListModel recipientListModel;
    private iIMListRenderer recipientListRenderer;
    private Vector answerList = new Vector(5);
    private Vector answersVector = new Vector(2);
    private Vector userList = null;
    private Vector allList = null;
    private JPanel pnlContent;
    private JButton btnRmvAnswer;
    private JCheckBox chkCustom;
    private JList lstPollAnswers;
    private JScrollPane scrollPollAnswers;
    private JList lstRecipients;
    private JScrollPane scrollRecipients;
    private DialogButtonsPanel pnlButtons;
    private JLabel lblPollAnswers;
    private JButton btnEditRecipients;
    private JLabel lblPollQuestion;
    private JFixedTextField txtPollQuestion;
    private JPanel pnlAnswerActions;
    private JLabel lblRecipients;
    private JButton btnAddAnswer;
    private static SafeResourceBundle pollUserCreationBundle = new SafeResourceBundle("com.iplanet.im.client.swing.poll.poll");

    public PollUserCreation(Vector a, Vector v) {
        this.allList = a == null ? new Vector(20) : a;
        this.userList = v == null ? new Vector(20) : v;
        this.initComponents();
        ApplicationManager.addActiveObject(this);
    }

    private void initComponents() {
        this.answersVector.addElement(new InstallData(pollUserCreationBundle.getString("common_answer_yes"), false));
        this.answersVector.addElement(new InstallData(pollUserCreationBundle.getString("common_answer_no"), false));
        this.lblRecipients = new JLabel();
        this.scrollRecipients = new JScrollPane();
        this.lstRecipients = new JList();
        this.btnEditRecipients = new JButton();
        this.txtPollQuestion = new JFixedTextField();
        this.lblPollAnswers = new JLabel();
        this.scrollPollAnswers = new JScrollPane();
        this.lstPollAnswers = new JList(this.answersVector);
        this.pnlAnswerActions = new JPanel();
        this.btnAddAnswer = new JButton();
        this.btnRmvAnswer = new JButton();
        this.chkCustom = new JCheckBox();
        this.pnlButtons = new DialogButtonsPanel(this);
        this.pnlButtons.setOkButtonLabel(2);
        this.getContentPane().setLayout(new GridBagLayout());
        String title = pollUserCreationBundle.getString("PollUserCreation_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PollUserCreation.this.close();
            }
        });
        this.lblRecipients.setText(pollUserCreationBundle.getString("lblRecipients_text"));
        this.lblRecipients.setLabelFor(this.lstRecipients);
        SwingUtils.setupButton(this.btnEditRecipients, pollUserCreationBundle, "btnEditRecipients_text", "btnEditRecipients_text_M", null, null);
        this.scrollRecipients.setPreferredSize(new Dimension(300, 40));
        this.getContentPane().add((Component)this.btnEditRecipients, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.scrollRecipients.setViewportView(this.lstRecipients);
        this.getContentPane().add((Component)this.scrollRecipients, new GridBagConstraints(-1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 5, 0, 12), 0, 25));
        this.lblPollQuestion = SwingUtils.makeLabelItem(pollUserCreationBundle, "lblPollQuestion_text", "lblPollQuestion_text_M", this.txtPollQuestion);
        this.lblPollQuestion.setToolTipText(pollUserCreationBundle.getString("lblPollQuestion_toolTipText").length() != 0 ? pollUserCreationBundle.getString("lblPollQuestion_toolTipText") : null);
        this.getContentPane().add((Component)this.lblPollQuestion, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 12), 0, 0));
        this.txtPollQuestion.setToolTipText(pollUserCreationBundle.getString("txtPoll_toolTipText").length() != 0 ? pollUserCreationBundle.getString("txtPoll_toolTipText") : null);
        this.getContentPane().add((Component)this.txtPollQuestion, new GridBagConstraints(-1, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 12), 0, 0));
        this.lblPollAnswers.setText(pollUserCreationBundle.getString("lblPollAnswers_text"));
        this.lblPollAnswers.setLabelFor(this.lstPollAnswers);
        this.getContentPane().add((Component)this.lblPollAnswers, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 12), 0, 0));
        this.answerListModel = new PollListModel(this.lstPollAnswers, this.answersVector);
        this.lstPollAnswers.setModel(this.answerListModel);
        this.lstPollAnswers.setSelectionMode(0);
        this.lstPollAnswers.setToolTipText(pollUserCreationBundle.getString("lstAnswers_toolTipText").length() != 0 ? pollUserCreationBundle.getString("lstAnswers_toolTipText") : null);
        this.scrollPollAnswers.setViewportView(this.lstPollAnswers);
        this.getContentPane().add((Component)this.scrollPollAnswers, new GridBagConstraints(-1, 4, 0, 1, 1.0, 1.0, 10, 1, new Insets(5, 12, 0, 12), 0, 0));
        this.pnlAnswerActions.setLayout(new GridLayout(1, 0, 5, 0));
        SwingUtils.setupButton(this.btnAddAnswer, pollUserCreationBundle, "btnAddAnswer_text", "btnAddAnswer_text_M", "btnAddAnswer_actionCommand", "btnAddAnswer_toolTipText");
        this.pnlAnswerActions.add(this.btnAddAnswer);
        SwingUtils.setupButton(this.btnRmvAnswer, pollUserCreationBundle, "btnRmvAnswer_text", "btnRmvAnswer_text_M", "btnRmvAnswer_actionCommand", "btnRmvAnswer_toolTipText");
        this.pnlAnswerActions.add(this.btnRmvAnswer);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlAnswerActions, new GridBagConstraints(-1, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(11, 12, 0, 12), 0, 0));
        this.chkCustom.setActionCommand(pollUserCreationBundle.getString("chkCustom_actionCommand"));
        String chkStr = pollUserCreationBundle.getString("chkCustom_text_M");
        if (chkStr != null && chkStr.length() > 0) {
            this.chkCustom.setMnemonic(chkStr.charAt(0));
        }
        if ((chkStr = pollUserCreationBundle.getString("chkCustom_toolTipText")) != null && chkStr.length() > 0) {
            this.chkCustom.setToolTipText(chkStr);
        }
        if ((chkStr = pollUserCreationBundle.getString("chkCustom_text")) != null && chkStr.length() > 0) {
            this.chkCustom.setText(chkStr);
        }
        this.getContentPane().add((Component)this.chkCustom, new GridBagConstraints(-1, 6, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(-1, 7, 0, 1, 0.0, 0.0, 13, 0, new Insets(17, 12, 12, 12), 0, 0));
        this.pnlButtons.setDefaultButton(4);
        this.setResizable(false);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.setSize(new Dimension(400, 360));
        this.btnAddAnswer.addActionListener(this);
        this.btnRmvAnswer.addActionListener(this);
        this.lstRecipients.addKeyListener(this.aSymKey);
        this.btnEditRecipients.addActionListener(this);
        this.recipientListModel = new iIMListModel(this.lstRecipients, this.userList);
        this.recipientListRenderer = new iIMListRenderer(this.recipientListModel);
        this.lstRecipients.setCellRenderer(this.recipientListRenderer);
        this.lstRecipients.setModel(this.recipientListModel);
        this.recipientListModel.changed(this.userList);
        this.lstPollAnswers.setSelectionInterval(0, 0);
        this.lstPollAnswers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (PollUserCreation.this.lstPollAnswers.getSelectedIndex() < 0) {
                    PollUserCreation.this.btnRmvAnswer.setEnabled(false);
                } else {
                    PollUserCreation.this.btnRmvAnswer.setEnabled(true);
                }
            }
        });
    }

    public void loadAnswers() {
        ListModel model = this.lstPollAnswers.getModel();
        boolean total = false;
        for (int k = 0; k < model.getSize(); ++k) {
            InstallData data = (InstallData)model.getElementAt(k);
        }
    }

    private final void handleAdd() {
        String msg = pollUserCreationBundle.getString("Enter_an_Answer");
        String tmp = JOptionPane.showInputDialog(this, (Object)msg);
        if (tmp == null || tmp.trim().equals("")) {
            return;
        }
        this.answersVector.add(new InstallData(tmp, true));
        this.answerListModel.changed();
        this.btnRmvAnswer.setEnabled(true);
    }

    private final void handleRemove() {
        int selIndx = this.lstPollAnswers.getSelectedIndex();
        this.answersVector.removeElementAt(selIndx);
        int listSize = this.lstPollAnswers.getModel().getSize();
        if (selIndx >= listSize - 1) {
            this.lstPollAnswers.setSelectedIndex(listSize - 1);
        }
        if (listSize == 0) {
            this.btnRmvAnswer.setEnabled(false);
        }
        this.answerListModel.changed();
    }

    private final void handleAddUsers() {
        Manager.Out("viewing Recipients");
        InviteUsers iv = new InviteUsers((Frame)this, this.userList, this.allList, true);
        iv.setTitle(pollUserCreationBundle.getString("titleAddRecipients"));
        iv.setLocationRelativeTo(this);
        iv.setModal(true);
        iv.setVisible(true);
        this.userList = Manager.getVectorFromArray(iv.getUserSelectionList());
        this.recipientListModel.changed(this.userList);
    }

    private final void handleDelete() {
        int[] rem = this.lstRecipients.getSelectedIndices();
        for (int n = 0; n < rem.length; ++n) {
            this.userList.removeElementAt(rem[n] - n);
        }
        this.recipientListModel.changed(this.userList);
    }

    private final boolean sendMsg() {
        try {
            if (this.userList.size() == 0) {
                String msg = pollUserCreationBundle.getString("There_are_no_users_in_the_Recipient_List");
                JOptionPane.showMessageDialog(this, msg);
                return false;
            }
            for (int i = 0; i < this.answersVector.size(); ++i) {
                InstallData answer = (InstallData)this.answersVector.get(i);
                this.answerList.add(answer.toString());
            }
            Manager.Out("question = " + this.txtPollQuestion.getText());
            int mask = iIMPropsUtil.getArchiveOptions(CurrentUserManager.getCurrentUserProperties());
            boolean doArchive = (mask & 8) != 0 && (mask & 1) != 0;
            String access = doArchive ? "participants" : "none";
            Poll helper = new Poll(Long.toString(System.currentTimeMillis()), this.txtPollQuestion.getText(), (List)this.answerList, this.chkCustom.isSelected(), "open", access);
            Message m = Manager._messageSession.createMessage();
            ClientMessageFactory.addPart(m, "application/x-iim-poll", helper.toString());
            for (int i = 0; i < this.userList.size(); ++i) {
                m.addRecipient(((CollaborationPrincipal)this.userList.get(i)).getUID());
            }
            ClientMessageFactory.sendAlertPollMsg(m, new MsgStatus(new Point(10, 10), m, this.userList, this.answerList, helper));
            return true;
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return false;
        }
    }

    private final void removeListeners() {
        this.btnAddAnswer.removeActionListener(this);
        this.btnRmvAnswer.removeActionListener(this);
        this.btnEditRecipients.removeActionListener(this);
        this.lstRecipients.removeKeyListener(this.aSymKey);
    }

    public final void close() {
        ApplicationManager.removeActiveObject(this);
        this.removeListeners();
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (object == this.btnAddAnswer) {
            this.handleAdd();
        } else if (object == this.btnRmvAnswer) {
            this.handleRemove();
        } else if (actionCommand == "ok") {
            if (this.sendMsg()) {
                this.close();
            }
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (actionCommand == "help") {
            HelpManager.showHelp("polluser");
        } else if (object == this.btnEditRecipients) {
            this.handleAddUsers();
        }
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PollUserCreation.this.close();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class InstallData {
        protected String m_name;
        protected boolean m_selected;

        public InstallData(String name, boolean selected) {
            this.m_name = name;
            this.m_selected = selected;
        }

        public String getName() {
            return this.m_name;
        }

        public void setSelected(boolean selected) {
            this.m_selected = selected;
        }

        public void invertSelected() {
            this.m_selected = !this.m_selected;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public String toString() {
            return this.m_name;
        }
    }

    final class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getSource() == PollUserCreation.this.lstRecipients) {
                if (event.getKeyCode() == 127) {
                    PollUserCreation.this.handleDelete();
                }
            }
        }
    }
}

