/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.models;

import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.FileStreaming;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.util.StringUtility;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ToolTipManager;

public class iIMListRenderer
extends DefaultListCellRenderer {
    private iIMListModel _model = null;
    private Color _fontColor = null;
    private int _fontSize = 0;
    static SafeResourceBundle dialogsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");

    public iIMListRenderer(iIMListModel m) {
        this._model = m;
        this.setOpaque(true);
    }

    public void setFontColor(Color color) {
        this._fontColor = color;
    }

    public void setFontSize(int size) {
        this._fontSize = size;
    }

    public void setFontSize(String size) {
        this.setFontSize(Integer.parseInt(size));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this._model != null) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            lbl.setText(this._model.getName(value));
            lbl.setIcon(this._model.getIcon(value));
            ToolTipManager.sharedInstance().registerComponent(list);
            if (value instanceof CollaborationPrincipal) {
                CollaborationPrincipal nu = (CollaborationPrincipal)value;
                if (UserCache.isActiveUser((CollaborationPrincipal)value)) {
                    list.setToolTipText(nu.getDisplayName() + " " + dialogsBundle.getString("Search_used_user_tooltip"));
                } else {
                    list.setToolTipText(nu.getDisplayName() + " " + dialogsBundle.getString("Search_never_used_user_tooltip"));
                }
            } else if (value instanceof Conference) {
                if (RoomManager.getParticipants(((Conference)value).getDestination()) == 0) {
                    list.setToolTipText(dialogsBundle.getString("txt_inactive_conf_tooltip"));
                } else {
                    list.setToolTipText(dialogsBundle.getString("txt_active_conf_tooltip"));
                }
            } else if (value instanceof File) {
                String name = ((File)value).getName();
                String msg = FileStreaming.getInstance().isBadFile(name) ? dialogsBundle.getString("corrupted_file_tooltip_format") : dialogsBundle.getString("file_tooltip_format");
                if ("".equals(msg)) {
                    list.setToolTipText(name);
                } else {
                    list.setToolTipText(StringUtility.substitute((String)msg, (String)"__MACRO__", (String)name));
                }
            }
            if (this._fontColor != null && !isSelected) {
                lbl.setForeground(this._fontColor);
            }
            if (this._fontSize > 0) {
                lbl.setFont(lbl.getFont().deriveFont((float)this._fontSize));
            }
            return this;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }
}

