/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.models;

import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.FileStreaming;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JList;

public class iIMListModel
extends AbstractListModel {
    private JList list;
    protected Vector v;
    static SafeResourceBundle dialogsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    static String searchResultFormat = null;
    static String searchResultGroupFormat = null;
    static String conference_display_format = dialogsBundle.getString("conference_display_format");
    static String corrupted_file_display_format = dialogsBundle.getString("corrupted_file_display_format");
    static String file_display_format = dialogsBundle.getString("file_display_format");

    public iIMListModel(JList list, Vector v) {
        this.v = v;
        this.list = list;
    }

    public final int getSize() {
        return this.v.size();
    }

    public final Object getElementAt(int index) {
        return this.v.elementAt(index);
    }

    public Object getIndexId(int index) {
        return this.getElementAt(index);
    }

    public final void changed() {
        this.fireContentsChanged(this.list, 0, 0);
    }

    public final void changed(Vector v) {
        this.v = v;
        this.fireContentsChanged(this.list, 0, 0);
    }

    public String getName(Object object) {
        Object o = this.v.elementAt(this.v.indexOf(object));
        StringBuffer ret = new StringBuffer();
        if (o instanceof CollaborationPrincipal) {
            CollaborationPrincipal nu = (CollaborationPrincipal)o;
            String displayFormat = UserCache.formatUserGroupDisplay(nu, searchResultFormat, searchResultGroupFormat);
            ret.append(displayFormat);
        } else if (o instanceof Conference) {
            String dest = ((Conference)o).getDestination();
            if ("".equals(conference_display_format)) {
                ret.append(dest);
            } else {
                String str = StringUtility.substitute((String)conference_display_format, (String)"__MACRO__", (String)dest);
                str = StringUtility.substitute((String)str, (String)"__MACRO1__", (String)Integer.toString(RoomManager.getParticipants(dest)));
                ret.append(str);
            }
        } else if (o instanceof PersonalStoreEntry) {
            ret.append(((PersonalStoreEntry)o).getDisplayName());
        } else if (o instanceof File) {
            String name = ((File)o).getName();
            String msg = FileStreaming.getInstance().isBadFile(name) ? corrupted_file_display_format : file_display_format;
            if ("".equals(msg)) {
                ret.append(name);
            } else {
                ret.append(StringUtility.substitute((String)msg, (String)"__MACRO__", (String)name));
            }
        } else {
            String name = null;
            if (o != null) {
                name = o.toString();
                ret.append(name);
            } else {
                return "";
            }
        }
        return ret.toString();
    }

    public final Icon getIcon(Object object) {
        if (object instanceof CollaborationGroup) {
            return SwingImageManager.getIcon("/com/iplanet/im/client/images/groups15.png", (Object)this);
        }
        if (object instanceof CollaborationPrincipal) {
            if (UserCache.isActiveUser((CollaborationPrincipal)object)) {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/sr_active.gif", (Object)this);
            }
            return SwingImageManager.getIcon("/com/iplanet/im/client/images/sr_inactive.gif", (Object)this);
        }
        if (object instanceof Conference) {
            if (RoomManager.getParticipants(((Conference)object).getDestination()) == 0) {
                return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_inactiveconf.png", "/com/sun/im/desktop/default/presenceicons/cl_inactiveconf.png", this);
            }
            return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_activeconf.png", "/com/sun/im/desktop/default/presenceicons/cl_activeconf.png", this);
        }
        if (object instanceof File) {
            return SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_attached.png", (Object)this);
        }
        if (object instanceof String || object instanceof PersonalStoreEntry) {
            return null;
        }
        return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_blank.gif", (Object)this);
    }

    static {
        SafeResourceBundle brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        searchResultFormat = brandBundle.getString("messenger.searchresult.format");
        if (!(searchResultFormat != null && searchResultFormat.length() != 0 || (searchResultFormat = dialogsBundle.getString("searchresults_format")) != null && !"".equals(searchResultFormat))) {
            searchResultFormat = "{displayname} <${attr:uid}@{domainname}>";
        }
        if ((searchResultGroupFormat = brandBundle.getString("messenger.searchresult.group.format")) == null || "".equals(searchResultGroupFormat)) {
            searchResultGroupFormat = "{domainname}/${attr:dn}";
        }
    }
}

