/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.models;

import com.iplanet.im.client.manager.EmoticonsManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class EmoticonTableModel
extends AbstractTableModel {
    static SafeResourceBundle tableBundle = new SafeResourceBundle("com.sun.im.desktop.emoticons.emoticons");
    Object[][] data = null;
    int TABLE_ROWS;
    int TABLE_COLS;
    Object[][] emotiShortcut = null;
    Object[][] emotiTooltip = null;

    public EmoticonTableModel() {
        if (!tableBundle.getString("smile.table.rows").trim().equals(null)) {
            this.TABLE_ROWS = Integer.parseInt(tableBundle.getString("smile.table.rows"));
        }
        if (!tableBundle.getString("smile.table.cols").trim().equals(null)) {
            this.TABLE_COLS = Integer.parseInt(tableBundle.getString("smile.table.cols"));
        }
        this.emotiShortcut = new Object[this.TABLE_ROWS][this.TABLE_COLS];
        this.emotiTooltip = new Object[this.TABLE_ROWS][this.TABLE_COLS];
        this.initilizeIcons();
    }

    private void initilizeIcons() {
        String[] emoticonsShortcuts = EmoticonsManager.getUniqueShortcuts();
        this.data = new Icon[this.TABLE_ROWS][this.TABLE_COLS];
        for (int k = 0; k < emoticonsShortcuts.length; ++k) {
            this.data[k / this.TABLE_COLS][k % this.TABLE_COLS] = EmoticonsManager.getIconForShortcut(emoticonsShortcuts[k]);
            this.emotiShortcut[k / this.TABLE_COLS][k % this.TABLE_COLS] = emoticonsShortcuts[k];
            this.emotiTooltip[k / this.TABLE_COLS][k % this.TABLE_COLS] = EmoticonsManager.getToolTipForShortcut((String)this.emotiShortcut[k / this.TABLE_COLS][k % this.TABLE_COLS]);
        }
    }

    public Class getColumnClass(int column) {
        return Icon.class;
    }

    public int getColumnCount() {
        return this.TABLE_COLS;
    }

    public String getColumnName(int column) {
        return null;
    }

    public int getRowCount() {
        return this.TABLE_ROWS;
    }

    public Object getValueAt(int row, int column) {
        if (this.data.equals(null)) {
            return null;
        }
        return this.data[row][column];
    }

    public Object getShortCutAt(int row, int column) {
        if (this.emotiShortcut == null) {
            return null;
        }
        return this.emotiShortcut[row][column];
    }

    public Object getTooltipAt(int row, int column) {
        if (this.emotiTooltip == null) {
            return null;
        }
        return this.emotiTooltip[row][column];
    }
}

