/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.model;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.swing.communicator.BuddyListTreeNode;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalGroup;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BuddyListTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private CollaborationGroup _cachedServerGroup;
    private CollaborationPrincipal[] _cachedUsersInGroup;

    public BuddyListTreeModel() {
        super(new DefaultMutableTreeNode(""));
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        for (int i = 0; i < buddyListGroups.length; ++i) {
            ((DefaultMutableTreeNode)this.root).add(new BuddyListTreeNode(BuddyListManager.getBuddyListGroups()[i]));
        }
    }

    public Object getChild(Object o, int param) {
        Object returnedObject = null;
        if (o == this.root) {
            returnedObject = super.getChild(o, param);
        } else if (o instanceof BuddyListTreeNode) {
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)o;
            switch (buddyListTreeNode.getNodeType()) {
                case 2: {
                    if (buddyListTreeNode.isExpanded()) {
                        returnedObject = super.getChild(o, param);
                        break;
                    }
                    if (!buddyListTreeNode.getPrincipal().equals(this._cachedServerGroup)) break;
                    returnedObject = new BuddyListTreeNode(buddyListTreeNode, this._cachedUsersInGroup[param]);
                    break;
                }
                default: {
                    returnedObject = super.getChild(o, param);
                }
            }
        }
        return returnedObject;
    }

    public int getChildCount(Object o) {
        int count = 0;
        if (o == this.root) {
            count = super.getChildCount(o);
        } else if (o instanceof BuddyListTreeNode) {
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)o;
            switch (buddyListTreeNode.getNodeType()) {
                case 2: {
                    if (buddyListTreeNode.isExpanded()) {
                        count = super.getChildCount(o);
                        break;
                    }
                    if (buddyListTreeNode.getPrincipal().equals(this._cachedServerGroup)) {
                        int n = count = this._cachedUsersInGroup != null ? this._cachedUsersInGroup.length : 0;
                        if (count != buddyListTreeNode.getChildCount()) break;
                        buddyListTreeNode.setExpanded(true);
                        this._cachedServerGroup = null;
                        this._cachedUsersInGroup = null;
                        break;
                    }
                    count = 1;
                    break;
                }
                default: {
                    count = super.getChildCount(o);
                }
            }
        }
        return count;
    }

    public void reloadRootNode() {
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        ((DefaultMutableTreeNode)this.root).removeAllChildren();
        for (int i = 0; i < buddyListGroups.length; ++i) {
            ((DefaultMutableTreeNode)this.root).add(new BuddyListTreeNode(BuddyListManager.getBuddyListGroups()[i]));
        }
    }

    public void reload(TreeNode node) {
        if (node instanceof BuddyListTreeNode) {
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)node;
            switch (buddyListTreeNode.getNodeType()) {
                case 1: {
                    buddyListTreeNode.removeAllChildren();
                    CollaborationPrincipal[] buddyListGroupContent = BuddyListManager.getBuddyListGroupElements(buddyListTreeNode.getUID());
                    if (buddyListGroupContent == null) break;
                    for (int i = 0; i < buddyListGroupContent.length; ++i) {
                        if (buddyListGroupContent[i] == null) continue;
                        new BuddyListTreeNode(buddyListTreeNode, buddyListGroupContent[i]);
                    }
                    break;
                }
            }
        }
        super.reload(node);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        try {
            BuddyListTreeNode buddyListTreeNode;
            TreePath path = treeExpansionEvent.getPath();
            if (path.getLastPathComponent() instanceof BuddyListTreeNode && (buddyListTreeNode = (BuddyListTreeNode)path.getLastPathComponent()).getNodeType() == 2) {
                Manager.Out("\nBuddyListTreeModel.treeWillExpand(): iIMGroup to expand: " + buddyListTreeNode.toString());
                this._cachedServerGroup = ((PersonalGroup)Manager._personalStoreSession.getEntry("group", buddyListTreeNode.getUID())).getGroup();
                this._cachedUsersInGroup = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(this._cachedServerGroup.getUID());
                this._cachedUsersInGroup = BuddyListManager.sortByElementsStatus(this._cachedUsersInGroup);
            }
        }
        catch (CollaborationException e) {
            Manager.Out((Object)e);
            e.printStackTrace();
        }
    }
}

