/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.login;

import com.iplanet.im.client.swing.login.DefaultLoginDialog;
import com.iplanet.im.client.swing.login.RegisterDialog;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.SecureRegistrationListener;
import com.sun.im.service.util.StringUtility;
import java.awt.Frame;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SelfUserRegistration
implements SecureRegistrationListener {
    static SafeResourceBundle register_server_bundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
    Frame _parent;
    private boolean flag_fillRegistrationInformation = true;
    static SafeResourceBundle selfRegisterBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
    private String[] registrationFields = new String[]{"username", "password", "first", "last", "name", "email"};
    private String _server;

    public SelfUserRegistration(Frame p, String server) {
        this._server = server;
        this._parent = p;
    }

    public boolean fillRegistrationInformation(Map fieldValuePairs, String server) {
        Object fieldName = null;
        Object value = null;
        Set fields = fieldValuePairs.keySet();
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < this.registrationFields.length; ++i) {
            if (!fields.contains(this.registrationFields[i])) continue;
            fieldList.add(this.registrationFields[i]);
        }
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            String field = (String)iter.next();
            if (fieldList.contains(field)) continue;
            fieldList.add(field);
        }
        RegisterDialog rDialog = new RegisterDialog(this._parent, true, fieldList, this._server);
        Map m = rDialog.getValues();
        if (m == null || m.size() == 0) {
            this.flag_fillRegistrationInformation = false;
        } else {
            Iterator i = fieldValuePairs.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                fieldValuePairs.put(name, m.get(name));
            }
        }
        return this.flag_fillRegistrationInformation;
    }

    public void redirected(URL url, String server) {
    }

    public void registered(String server) {
        String msg = StringUtility.substitute((String)register_server_bundle.getString("user_register"), (String)"__MACRO__", (String)server.toString());
        JOptionPane.showMessageDialog(this._parent, msg);
    }

    public void unregistered(String server) {
    }

    public void registrationFailed(String errorCondition, String errorText, String server) {
        if (this.flag_fillRegistrationInformation) {
            final String msg = "service_unavailable".equals(errorCondition) ? register_server_bundle.getString("user_registration_not_available") : ("already_registered".equals(errorCondition) ? register_server_bundle.getString("user_registration_already_registered") : ("not_authorized".equals(errorCondition) ? register_server_bundle.getString("user_registration_not_authorized") : register_server_bundle.getString("user_registration_failed")));
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(SelfUserRegistration.this._parent, msg);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unregistrationFailed(String errorCondition, String errorText, String server) {
    }

    public void registrationUpdated(String server) {
    }

    public void registrationUpdateFailed(String errorCondition, String errorText, String server) {
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return DefaultLoginDialog.showCertificate(chain, this._parent);
    }
}

