/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.login;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.login.DefaultLoginDialog;
import com.iplanet.im.client.swing.login.SelfUserRegistration;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.ImageLabel;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CertificateRejectedException;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionProvider;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public final class LoginDialog
extends DefaultLoginDialog
implements ActionListener,
WindowListener {
    private ImageLabel lblImage = null;
    private DialogButtonsPanel pnlButtons;
    private boolean _autoConnect = false;
    private JLabel lblSplashImage;
    private CollaborationSessionFactory _factory;
    private CollaborationSessionProvider sessionProvider;
    private JPanel pnlImage = new JPanel();
    private JPanel pnlLogin = new JPanel();
    private JPanel pnlMoreDetails = new JPanel();
    private JPanel pnlLessDetails = new JPanel();
    private JPanel pnlOptions = new JPanel();
    private JPanel pnlRegister = new JPanel();
    private JPanel pnlOKCancelHelp = new JPanel();
    private JPanel pnlAutoLogin = new JPanel();
    private JFixedTextField txtUserName = new JFixedTextField();
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private JButton btnDetails = new JButton();
    private JPanel pnlDetails = new JPanel();
    private JLabel lblUserName = new JLabel();
    private JLabel lblPassword = new JLabel();
    private JPasswordField txtPassword = new JPasswordField();
    private JLabel lblServer = new JLabel();
    private JLabel lblResource = new JLabel();
    private JLabel lblPriority = new JLabel();
    private JComboBox cmbPriority = new JComboBox();
    private JLabel lblLogin = new JLabel();
    private JLabel lblLoginLogo = new JLabel();
    private JComboBox cmbResource = new JComboBox();
    private JCheckBox chkAutoLogon = new JCheckBox();
    private JCheckBox chkRegister = new JCheckBox();
    private JButton btnHelp = new JButton();
    private JCheckBox chkSSL = new JCheckBox();
    private JComboBox cmbServers = new JComboBox();
    private JButton btnRegister = new JButton();
    private JPanel regPanel = new JPanel();
    private TitledBorder titledBorder1;
    private Border border1;
    static SafeResourceBundle loginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");

    public LoginDialog(boolean autoConnect) {
        this._autoConnect = autoConnect;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(loginDialogBundle.getString("LoginDialog_title"));
        this.getAccessibleContext().setAccessibleDescription(loginDialogBundle.getString("LoginDialog_title"));
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.centerWindow();
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlImage.setLayout(new GridBagLayout());
        this.pnlImage.setRequestFocusEnabled(false);
        this.lblSplashImage = new JLabel();
        ImageIcon ico = SwingImageManager.getIcon("/com/sun/im/desktop/brand/logo_sun.png", "/com/sun/im/desktop/default/brand/logo_sun.png", this);
        this.lblSplashImage.setIcon(ico);
        this.getContentPane().add((Component)this.lblSplashImage, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this._autoConnect) {
            if (Manager._use_ssl) {
                this.chkSSL.setSelected(true);
            }
            this.initAutoControls();
        } else {
            this.initControls();
        }
        this.addWindowListener(this);
    }

    private void initAutoControls() {
        this.pnlAutoLogin.setLayout(new GridBagLayout());
        this.pnlAutoLogin.setRequestFocusEnabled(false);
        this.lblLogin.setText(loginDialogBundle.getString("LoginDialog_logging_into_server"));
        this.pnlAutoLogin.add((Component)this.lblLogin, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 0, new Insets(5, 2, 5, 2), 0, 0));
        SwingUtils.setupButton(this.btnCancel, loginDialogBundle, "LoginDialog_cancel", "LoginDialog_cancel_M", null, null);
        this.btnCancel.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnCancel);
        this.pnlAutoLogin.add((Component)this.btnCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.getContentPane().add((Component)this.pnlAutoLogin, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.btnCancel.addActionListener(this);
        this.btnRegister.addActionListener(this);
        this.btnDetails.addActionListener(this);
        this.btnCancel.requestFocus();
    }

    public void initControls() {
        this.pnlButtons = new DialogButtonsPanel(this);
        this.border1 = BorderFactory.createEtchedBorder();
        this.pnlLogin.setLayout(new GridBagLayout());
        this.pnlLessDetails.setLayout(new GridBagLayout());
        this.regPanel.setLayout(new GridBagLayout());
        this.pnlMoreDetails.setLayout(new GridBagLayout());
        Insets ins = null;
        Insets ins1 = null;
        if (PlatformUtil.isWin()) {
            ins = new Insets(5, 13, 2, 5);
            ins1 = new Insets(5, 10, 2, 5);
        } else {
            ins = new Insets(5, 20, 2, 5);
            ins1 = new Insets(5, 17, 2, 5);
        }
        this.regPanel.setBorder(this.border1);
        this.getContentPane().add((Component)this.pnlLogin, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 7, 0, 7), 0, 0));
        this.lblUserName.setText(loginDialogBundle.getString("LoginDialog_username"));
        this.lblUserName.setLabelFor(this.txtUserName);
        String mnemonicStr = loginDialogBundle.getString("LoginDialog_username_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.lblUserName.setDisplayedMnemonic(mnemonicStr.charAt(0));
        }
        this.pnlLogin.add((Component)this.btnRegister, new GridBagConstraints(1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 0, 5), 0, 0));
        this.pnlLogin.add((Component)this.lblUserName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 5, 2, 5), 0, 0));
        this.pnlLogin.add((Component)this.txtUserName, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 2, 5), 0, 0));
        this.lblPassword.setText(loginDialogBundle.getString("LoginDialog_password"));
        this.lblPassword.setLabelFor(this.txtPassword);
        this.lblPassword.setDisplayedMnemonic(80);
        mnemonicStr = loginDialogBundle.getString("LoginDialog_password_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.lblPassword.setDisplayedMnemonic(mnemonicStr.charAt(0));
        }
        this.pnlLogin.add((Component)this.lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlLogin.add((Component)this.txtPassword, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 5), 0, 0));
        this.pnlOptions.setLayout(new GridLayout());
        this.chkAutoLogon.setText(loginDialogBundle.getString("LoginDialog_autologon"));
        this.chkAutoLogon.setMnemonic(loginDialogBundle.getString("LoginDialog_autologon_M").charAt(0));
        this.pnlOptions.add(this.chkAutoLogon);
        this.pnlLogin.add((Component)this.chkAutoLogon, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        this.btnRegister.setText(loginDialogBundle.getString("LoginDialog_newuser"));
        this.btnRegister.setMnemonic(loginDialogBundle.getString("LoginDialog_newuser_M").charAt(0));
        this.chkSSL = SwingUtils.checkBoxItem(loginDialogBundle, null, "LoginDialog_use_ssl", "LoginDialog_use_ssl_M", null);
        SwingUtils.setupButton(this.btnDetails, loginDialogBundle, "LoginDialog_moredetails", "LoginDialog_moredetails_M", null, null);
        this.btnDetails.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_more.png", (Object)this));
        this.btnDetails.setHorizontalTextPosition(10);
        this.btnDetails.setVerticalTextPosition(0);
        this.pnlDetails.setLayout(new GridLayout());
        this.pnlDetails.add(this.btnDetails);
        this.pnlLogin.add((Component)this.btnDetails, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 10, 2, 5), 0, 0));
        this.lblServer.setText(loginDialogBundle.getString("LoginDialog_server"));
        this.lblServer.setLabelFor(this.cmbServers);
        this.lblServer.setDisplayedMnemonic(83);
        mnemonicStr = loginDialogBundle.getString("LoginDialog_server_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.lblServer.setDisplayedMnemonic(mnemonicStr.charAt(0));
        }
        this.pnlMoreDetails.add((Component)this.lblServer, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0));
        this.lblServer.setLabelFor(this.cmbServers);
        this.cmbServers.setEditable(true);
        this.cmbServers.setLightWeightPopupEnabled(false);
        this.pnlMoreDetails.add((Component)this.cmbServers, new GridBagConstraints(1, -1, 0, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.lblResource.setText(loginDialogBundle.getString("LoginDialog_resource"));
        mnemonicStr = loginDialogBundle.getString("LoginDialog_resource_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.lblResource.setDisplayedMnemonic(mnemonicStr.charAt(0));
        }
        this.lblResource.setLabelFor(this.cmbResource);
        this.pnlMoreDetails.add((Component)this.lblResource, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlMoreDetails.add((Component)this.cmbResource, new GridBagConstraints(1, -1, 0, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.lblPriority.setText(loginDialogBundle.getString("LoginDialog_priority"));
        mnemonicStr = loginDialogBundle.getString("LoginDialog_priority_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.lblPriority.setDisplayedMnemonic(mnemonicStr.charAt(0));
        }
        this.pnlMoreDetails.add((Component)this.lblPriority, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlMoreDetails.add((Component)this.cmbPriority, new GridBagConstraints(1, -1, 0, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.lblPriority.setLabelFor(this.cmbPriority);
        this.initPriority();
        this.pnlMoreDetails.add((Component)this.chkSSL, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 0, ins1, 0, 0));
        this.cmbResource.setEditable(true);
        this.cmbResource.setLightWeightPopupEnabled(false);
        this.cmbPriority.setLightWeightPopupEnabled(false);
        this.pnlMoreDetails.setVisible(false);
        this.pnlOKCancelHelp.setLayout(new GridBagLayout());
        this.pnlLogin.add((Component)this.pnlButtons, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(17, 12, 10, 5), 0, 0));
        this.lblLoginLogo.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/default/brand/logo_login_footer.png", (Object)this));
        this.pnlLogin.add((Component)this.lblLoginLogo, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 8, 0), 0, 0));
        SwingUtils.setupButton(this.btnOK, loginDialogBundle, "LoginDialog_OK", null, null, null);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.pnlOKCancelHelp.add((Component)this.btnOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        SwingUtils.setupButton(this.btnCancel, loginDialogBundle, "LoginDialog_cancel", null, null, null);
        this.pnlOKCancelHelp.add((Component)this.btnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlButtons.setDefaultButton(4);
        SwingUtils.setupButton(this.btnHelp, loginDialogBundle, "LoginDialog_help", "LoginDialog_help_M", null, null);
        this.pnlOKCancelHelp.add((Component)this.btnHelp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.btnCancel.addActionListener(this);
        this.btnOK.addActionListener(this);
        this.btnHelp.addActionListener(this);
        this.btnRegister.addActionListener(this);
        this.btnDetails.addActionListener(this);
        this.btnRegister.setVisible(false);
        if (Manager._use_ssl) {
            this.chkSSL.setSelected(true);
        }
        if (Manager._register) {
            this.btnRegister.setVisible(true);
        }
        if (Manager._use_ssl_optional) {
            this.chkSSL.setVisible(true);
        }
        JNILink.alwaysOnTop(this, true);
        this.pack();
    }

    private void initPriority() {
        List list = Manager.getPriorityList();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            this.cmbPriority.addItem(itr.next());
        }
        Manager.Out("DEFAULT PRIORITY:  " + Manager.getDefaultPriorityString());
        this.cmbPriority.setSelectedItem(Manager.getDefaultPriorityString());
    }

    public void loadDefaultSettings() {
        if (Manager._is_portal_env) {
            this.chkAutoLogon.setEnabled(false);
        } else {
            this.chkAutoLogon.setEnabled(true);
        }
        super.loadDefaultSettings();
        Toolkit.getDefaultToolkit().beep();
    }

    public String[] getServers() {
        int count = this.cmbServers.getItemCount();
        Vector v = new Vector();
        for (int n = 0; n < count; ++n) {
            v.addElement(this.cmbServers.getItemAt(n));
        }
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        return tmp;
    }

    public String getServer() {
        return this.getAddressString(this.cmbServers.getEditor().getItem());
    }

    public String getResource() {
        return (String)this.cmbResource.getEditor().getItem();
    }

    public String[] getResources() {
        int count = this.cmbResource.getItemCount();
        Vector v = new Vector();
        for (int n = 0; n < count; ++n) {
            v.addElement(this.cmbResource.getItemAt(n));
        }
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        return tmp;
    }

    public String getUID() {
        return this.txtUserName.getText();
    }

    public String getPassword() {
        return new String(this.txtPassword.getPassword());
    }

    public int getPriority() {
        return Manager.getPriorityValue(this.cmbPriority.getSelectedIndex());
    }

    public void requestDefaultFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (LoginDialog.this._autoConnect) {
                    LoginDialog.this.btnCancel.requestFocus();
                } else {
                    LoginDialog.this.txtPassword.requestFocus();
                }
            }
        });
    }

    public void setAllowSSL(boolean b) {
        this.chkSSL.setEnabled(b);
    }

    public void setUseSSL(boolean b) {
        this.chkSSL.setEnabled(b);
        this.chkSSL.setSelected(b);
    }

    public boolean getUseSSL() {
        return this.chkSSL.isSelected();
    }

    public void setServers(String[] server) {
        for (int i = 0; i < server.length; ++i) {
            this.cmbServers.addItem(server[i]);
        }
        if (server.length > 0) {
            this.cmbServers.setSelectedIndex(0);
        }
    }

    public void setResources(String[] resource) {
        for (int i = 0; i < resource.length; ++i) {
            this.cmbResource.addItem(resource[i]);
        }
        if (resource.length > 0) {
            this.cmbResource.setSelectedIndex(0);
        }
    }

    public void setUID(String uid) {
        this.txtUserName.setText(uid);
    }

    public boolean getAutoLogin() {
        return this.chkAutoLogon.isSelected();
    }

    public void setAllowAutoLogin(boolean b) {
        this.chkAutoLogon.setEnabled(b);
    }

    public final void windowClosed(WindowEvent e) {
    }

    public final void windowIconified(WindowEvent e) {
    }

    public final void windowOpened(WindowEvent e) {
    }

    public final void windowDeiconified(WindowEvent e) {
    }

    public final void windowActivated(WindowEvent e) {
    }

    public final void windowDeactivated(WindowEvent e) {
    }

    public final void windowClosing(WindowEvent event) {
        this.close(true);
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private final String getAddressString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return ((InetAddress)o).getHostAddress();
    }

    private final void removeListeners() {
        this.btnCancel.removeActionListener(this);
        this.btnOK.removeActionListener(this);
        this.btnHelp.removeActionListener(this);
        this.btnRegister.removeActionListener(this);
        this.removeWindowListener(this);
        this.btnDetails.removeActionListener(this);
    }

    public void ok() {
        try {
            Thread connectThread = new Thread((Runnable)new ConnectRunnable(this), "iIM-Connect-0");
            String session = this.cmbResource.getSelectedItem().toString().trim();
            if (session == null || session.length() == 0) {
                String msg = loginDialogBundle.getString("session_notnull");
                String title = loginDialogBundle.getString("LoginDialog_title");
                JOptionPane.showMessageDialog(this, msg, title, 2, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
                this.cmbResource.requestFocus();
            } else {
                connectThread.start();
            }
        }
        catch (Exception e) {
            System.out.print("LoginDialog.ok(): Exception thrown at connect phase: " + e);
        }
    }

    private void newUser() {
        String server = this.cmbServers.getSelectedItem().toString().trim();
        SelfUserRegistration selfUserRegistration = new SelfUserRegistration(this, server);
        try {
            Manager.initManager();
            this._factory = Manager.getCollaborationSessionFactory();
            this.sessionProvider = this._factory.getCollaborationSessionProvider();
            this.sessionProvider.register(server, (RegistrationListener)selfUserRegistration);
        }
        catch (CertificateRejectedException e) {
        }
        catch (Exception e) {
            this.sessionProvider = null;
            this._factory = null;
            String msg = StringUtility.substitute((String)loginDialogBundle.getString("register_server_validation"), (String)"__MACRO__", (String)server);
            JOptionPane.showMessageDialog(null, msg);
        }
        this.sessionProvider = null;
        this._factory = null;
    }

    private void moreDetails() {
        if (this.pnlMoreDetails.isVisible()) {
            this.pnlMoreDetails.setVisible(false);
            this.btnDetails.setText(loginDialogBundle.getString("LoginDialog_moredetails"));
            String mnemonicStr = loginDialogBundle.getString("LoginDialog_moredetails_M");
            if (mnemonicStr != null && !"".equals(mnemonicStr)) {
                this.btnDetails.setMnemonic(mnemonicStr.charAt(0));
            }
            this.btnDetails.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_more.png", (Object)this));
            this.pack();
        } else if (!this.pnlMoreDetails.isVisible()) {
            this.pnlMoreDetails.setVisible(true);
            this.pnlLogin.add((Component)this.pnlMoreDetails, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnDetails.setText(loginDialogBundle.getString("LoginDialog_lessdetails"));
            String mnemonicStr = loginDialogBundle.getString("LoginDialog_lessdetails_M");
            if (mnemonicStr != null && !"".equals(mnemonicStr)) {
                this.btnDetails.setMnemonic(mnemonicStr.charAt(0));
            }
            this.btnDetails.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_less.png", (Object)this));
            this.pack();
        }
    }

    private void setControlsEnabled(boolean b) {
        this.txtUserName.setEnabled(b);
        this.txtPassword.setEnabled(b);
        this.pnlButtons.disableButtons(b);
        if (this.chkAutoLogon != null) {
            this.chkAutoLogon.setEnabled(b);
        }
        if (this.chkSSL != null) {
            this.chkSSL.setEnabled(b);
        }
        if (Manager._register) {
            this.btnRegister.setEnabled(b);
        }
        this.btnOK.setEnabled(b);
        this.btnCancel.setEnabled(b);
        this.btnDetails.setEnabled(b);
        this.btnHelp.setEnabled(b);
        this.cmbServers.setEnabled(b);
        this.cmbResource.setEnabled(b);
        this.cmbPriority.setEnabled(b);
    }

    public final void close(boolean exit) {
        this.setVisible(false);
        this.removeListeners();
        SwingImageManager.flushIcon("/com/sun/im/desktop/brand/logo_sun.png");
        this.dispose();
        if (exit) {
            iIM.exit(false);
        }
    }

    public final void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.ok();
        } else if (actionCommand == "cancel") {
            this.close(true);
        } else if (actionCommand == "help") {
            HelpManager.showHelp("logon");
        } else if (object == this.btnRegister) {
            Manager._use_ssl = this.getUseSSL();
            this.newUser();
        } else if (object == this.btnDetails) {
            this.moreDetails();
        }
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginDialog.this.close(true);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private class ConnectRunnable
    implements Runnable {
        private Component _parent = null;

        public ConnectRunnable(JFrame c) {
            this._parent = c;
        }

        public void run() {
            Manager.Out("LoginDialog.ConnectRunnable.run(): Thread " + Thread.currentThread().getName() + " starting");
            Manager._use_ssl = LoginDialog.this.chkSSL.isSelected();
            LoginDialog.this.setControlsEnabled(false);
            String connectResult = LoginDialog.this.connect();
            SwingUtilities.invokeLater(new Runnable(this, connectResult){
                private final /* synthetic */ String val$connectResult;
                private final /* synthetic */ ConnectRunnable this$1;
                {
                    this.this$1 = this$1;
                    this.val$connectResult = val$connectResult;
                }

                public void run() {
                    if (this.val$connectResult == null) {
                        ConnectRunnable.access$500(this.this$1).close(false);
                    } else {
                        JOptionPane.showMessageDialog(ConnectRunnable.access$600(this.this$1), this.val$connectResult);
                        LoginDialog.access$400(ConnectRunnable.access$500(this.this$1), true);
                    }
                }
            });
            Manager.Out("LoginDialog.ConnectRunnable.run(): Thread " + Thread.currentThread().getName() + " terminating");
        }

        static /* synthetic */ LoginDialog access$500(ConnectRunnable x0) {
            return x0.LoginDialog.this;
        }

        static /* synthetic */ Component access$600(ConnectRunnable x0) {
            return x0._parent;
        }
    }
}

