/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.login;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.TimeoutException;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class DefaultLoginDialog
extends AutoOrientationJFrame {
    protected static boolean _exit_on_close = false;
    public static boolean _encode_password = true;
    public static boolean _ssl_connection = false;
    private int authError = 0;
    static SafeResourceBundle defaultLoginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");

    public void loadDefaultSettings() {
        String uid = "unknown";
        String pass = "";
        if (Manager._is_applet) {
            URL u;
            uid = Manager.getParameter("-uid", "");
            String server = Manager.getParameter("server", "");
            if (server.equals("") && (u = Manager._applet.getCodeBase()) != null) {
                server = u.getHost();
                System.out.println("APPLET SERVER IS: " + server);
            }
            Manager.NetLertProperties.put("net.nms", server);
        } else {
            uid = PlatformUtil.getUserName();
        }
        Manager.Out(Manager.NetLertProperties);
        if (Manager._uid != null) {
            this.setUID(Manager._uid);
        } else {
            this.setUID(iIMPropsUtil.getStoredUserName(Manager.NetLertProperties, uid));
        }
        Vector v = iIMPropsUtil.getServerListFromProperty(Manager.NetLertProperties);
        if (Manager._server != null) {
            v.insertElementAt(Manager._server, 0);
        }
        Object[] tmp = new String[v.size()];
        v.copyInto(tmp);
        this.setServers((String[])tmp);
        Vector rsr = iIMPropsUtil.getResourceListFromProperty(Manager.NetLertProperties);
        if (Manager._resource != null) {
            rsr.insertElementAt(Manager._resource, 0);
        }
        Object[] tmpR = new String[rsr.size()];
        rsr.copyInto(tmpR);
        this.setResources((String[])tmpR);
        this.setAllowSSL(PlatformUtil.isJava2());
        this.setAllowAutoLogin(!Manager._disable_auto_logon);
        this.setVisible(true);
        if (!Manager._is_applet && Manager._is_portal_env) {
            this.setAllowSSL(false);
            this.setAllowAutoLogin(false);
        }
    }

    public abstract String getResource();

    public abstract String[] getResources();

    public abstract String getServer();

    public abstract String[] getServers();

    public abstract String getUID();

    public abstract String getPassword();

    public abstract int getPriority();

    public abstract boolean getUseSSL();

    public abstract void setServers(String[] var1);

    public abstract void setResources(String[] var1);

    public abstract void setUID(String var1);

    public abstract boolean getAutoLogin();

    public abstract void setAllowAutoLogin(boolean var1);

    public abstract void setAllowSSL(boolean var1);

    public abstract void setUseSSL(boolean var1);

    protected String connect() {
        int n;
        Manager.Out("   DEBUG: connect()");
        if (this.getServer() == null || this.getServer().equals("")) {
            String msg = "Invalid Server Address";
            return "Invalid Server Address";
        }
        String[] list = this.getServers();
        Manager.NetLertProperties.put("net.nms" + Integer.toString(0), this.getServer());
        for (n = 0; n < list.length; ++n) {
            if (this.getServer().equals(list[n])) continue;
            Manager.NetLertProperties.put("net.nms" + Integer.toString(n + 1), list[n]);
        }
        list = this.getResources();
        Manager.NetLertProperties.put("net.resource" + Integer.toString(0), this.getResource());
        for (n = 0; n < list.length; ++n) {
            if (this.getResource().equals(list[n])) continue;
            Manager.NetLertProperties.put("net.resource" + Integer.toString(n + 1), list[n]);
        }
        Manager.NetLertProperties.put("net.nms", this.getServer());
        Manager.NetLertProperties.put("net.resource", this.getResource());
        iIMPropsUtil.setStoredUsername(Manager.NetLertProperties, this.getUID().trim());
        iIMPropsUtil.setStoredPassword(Manager.NetLertProperties, new String(this.getPassword()));
        Manager.setSessionPriority(this.getPriority());
        Manager.NetLertProperties.put("net.use.ssl", String.valueOf(this.getUseSSL()));
        iIMPropsUtil.saveNetLertProperties(Manager.NetLertProperties, Manager._propFileName, this.getAutoLogin(), _encode_password);
        Manager._auto_logon = this.getAutoLogin();
        return this.connect(Manager.NetLertProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connect(Properties p) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Manager.Out("   DEBUG: START CONNECT() ", true);
        try {
            String ssl;
            if (p == null) {
                p = new Properties();
            }
            Manager._use_ssl = "true".equalsIgnoreCase(ssl = (Manager.NetLertProperties = p).getProperty("net.use.ssl"));
            Manager.initManager();
            SecureListener l = Manager._use_ssl ? new SecureListener(this) : null;
            Manager.login((CollaborationSessionListener)l);
        }
        catch (UnknownHostException uhe) {
            Manager.Out("connect uhe: " + uhe);
            this.authError = 1;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_unknown_host_exception");
            return string;
        }
        catch (AuthenticationException ae) {
            Manager.Out("connect ae: " + (Object)((Object)ae));
            this.authError = 2;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_return_auth_exception");
            return string;
        }
        catch (TimeoutException te) {
            Manager.Out("timeout: " + te.getMessage());
            this.authError = 3;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_return_timeout_exception");
            return string;
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
            Manager.Out("error: " + ce.getMessage());
            this.authError = 3;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_return_protocol_exception");
            return string;
        }
        catch (IOException ioe) {
            Manager.Out("connect ioe: " + ioe);
            this.authError = 4;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_return_connect_exception");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            Manager.Out("connect e: " + e);
            this.authError = 5;
            String string = defaultLoginDialogBundle.getString("DefaultLoginDialog_return_unknown_exception");
            return string;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (Manager._session != null) {
            Manager.Out("ICAPI Login was successful \n");
        }
        try {
            this.loadNetLert(Manager.flavor);
        }
        catch (Exception e) {
            Manager.Out("Failed to load the NetLert Views " + e.toString());
            e.printStackTrace();
        }
        return null;
    }

    public int getAuthError() {
        return this.authError;
    }

    protected void loadNetLert(final int flavor) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                iIM.loadNetLert(flavor);
            }
        });
    }

    public void addNotify() {
        Manager.Out("DEBUG: DefaulLoginDialog.addNotify()");
        super.addNotify();
        Orientation.apply(this);
    }

    public void setVisible(boolean b) {
        Manager.Out("DEBUG: DefaulLoginDialog.setVisible()");
        super.setVisible(b);
    }

    public void validate() {
        Manager.Out("DEBUG: DefaulLoginDialog.validate()");
        super.validate();
    }

    protected void validateTree() {
        Manager.Out("DEBUG: DefaulLoginDialog.validateTree()");
        super.validateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showCertificate(X509Certificate[] chain, Component parent) {
        LinkedList<BigInteger> trustedCerts = new LinkedList<BigInteger>();
        SafeResourceBundle defaultLoginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        boolean trust = false;
        BigInteger sn = null;
        if (chain.length > 0 && trustedCerts.contains(sn = chain[0].getSerialNumber())) {
            return true;
        }
        try {
            StringBuffer chainS = new StringBuffer();
            chainS.append(defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_certificate_alert"));
            chainS.append(StringUtility.lineSeparator);
            chainS.append("-------------" + StringUtility.lineSeparator);
            SimpleDateFormat dfmt = new SimpleDateFormat();
            for (int i = 0; i < chain.length; ++i) {
                chainS.append(StringUtility.substitute((String)defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_issuer_dn"), (String)"__MACRO__", (String)((Object)chain[i].getIssuerDN()).toString()));
                chainS.append(StringUtility.lineSeparator);
                chainS.append(StringUtility.substitute((String)defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_subject_dn"), (String)"__MACRO__", (String)((Object)chain[i].getSubjectDN()).toString()));
                chainS.append(StringUtility.lineSeparator);
                String validity = defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_validity");
                validity = StringUtility.substitute((String)validity, (String)"__BEGIN__", (String)dfmt.format(chain[i].getNotBefore()));
                validity = StringUtility.substitute((String)validity, (String)"__END__", (String)dfmt.format(chain[i].getNotAfter()));
                chainS.append(validity + StringUtility.lineSeparator);
                chainS.append("-------------" + StringUtility.lineSeparator);
            }
            chainS.append(defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_do_you_trust"));
            int choice = 1;
            choice = JOptionPane.showConfirmDialog(parent, chainS.toString(), defaultLoginDialogBundle.getString("SSL_Status"), 2, 0);
            boolean bl = trust = choice == 0;
            if (trust && sn != null) {
                trustedCerts.add(sn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trust;
    }

    static class SecureListener
    implements SecureSessionListener {
        private Component _parent;

        SecureListener(Component parent) {
            this._parent = parent;
        }

        public boolean onX509Certificate(X509Certificate[] chain) {
            return DefaultLoginDialog.showCertificate(chain, this._parent);
        }

        public void onError(CollaborationException e) {
        }
    }
}

