/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.SafeResourceBundle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.SwingUtilities;

public class iIMFrame
extends AutoOrientationJFrame
implements ActionListener,
ItemListener,
WindowListener,
FocusListener {
    private FlashRunnable _frameFlasher;
    protected boolean _isFrameOnTop = false;
    protected boolean _isActive = false;
    protected boolean _hasFocus = false;
    private static final int NOTIFY_BLINK_RATE = 1500;
    protected boolean _isFrameBlinking = false;
    static SafeResourceBundle iIMFrameBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");

    public iIMFrame() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.addWindowListener(this);
        this.addFocusListener(this);
        this.setTitle(iIMFrameBundle.getString("iIMFrame_title"));
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
        this._isActive = true;
    }

    public void windowDeactivated(WindowEvent e) {
        this._isActive = false;
    }

    public void windowClosing(WindowEvent event) {
    }

    public void focusGained(FocusEvent e) {
        this._hasFocus = true;
    }

    public void focusLost(FocusEvent e) {
        this._hasFocus = true;
    }

    public void itemStateChanged(ItemEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void dispose() {
        this._isFrameBlinking = false;
        this.removeFocusListener(this);
        this.removeWindowListener(this);
        ApplicationManager.removeActiveObject(this);
        super.dispose();
    }

    public final void flashOnce() {
        if (this._frameFlasher == null) {
            this._frameFlasher = new FlashRunnable();
        }
        SwingUtilities.invokeLater(this._frameFlasher);
    }

    public final void setOnTop(boolean b) {
        if (b == this._isFrameOnTop || !JNILink.JNI_LOADED) {
            return;
        }
        this._isFrameOnTop = b;
        Manager.Out("   DEBUG NLFrame: setOnTop() " + this._isFrameOnTop);
        JNILink.alwaysOnTop(this, this._isFrameOnTop);
        if (!b) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iIMFrame.this.toFront();
                }
            });
        }
    }

    public void toFront() {
        this.toFront(true);
    }

    public void toFront(boolean stealFocus) {
        if (this.getState() == 1) {
            this.setState(0);
        }
        if (!stealFocus && JNILink.USE_WIN_JNI) {
            JNILink.toFront(this);
        } else {
            super.toFront();
        }
    }

    public void setVisible(boolean b) {
        if (b && !this.isVisible()) {
            ApplicationManager.addActiveObject(this);
        }
        super.setVisible(b);
    }

    public void setSize(int w, int h) {
        Dimension d = Manager.getValidSize(this, w, h);
        super.setSize(d.width, d.height);
    }

    public void setLocation(int x, int y) {
        Point p = Manager.getValidPoint(this, new Point(x, y));
        super.setLocation(p.x, p.y);
    }

    public void setLocation(Point p) {
        super.setLocation(Manager.getValidPoint(this, p));
    }

    public void setFrameBlinking(boolean b) {
        if (b) {
            this.startBlinkThread();
        } else {
            this._isFrameBlinking = false;
        }
    }

    public final void startBlinkThread() {
        if (this._isFrameBlinking) {
            return;
        }
        this._isFrameBlinking = true;
        if (!JNILink.USE_WIN_JNI) {
            this.toFront();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iIMFrame.this.toFront();
                }
            });
            return;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                Manager.Out("DEBUG: Frame blinker thread starting");
                while (iIMFrame.this._isFrameBlinking) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    if (!iIMFrame.this._isFrameBlinking) continue;
                    iIMFrame.this.flashOnce();
                }
                Manager.Out("DEBUG: Frame blinker thread terminating");
            }
        });
        t.start();
    }

    private final class FlashRunnable
    implements Runnable {
        private FlashRunnable() {
        }

        public void run() {
            JNILink.flashWindow(iIMFrame.this);
        }
    }
}

