/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.PersonalStoreEntry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class WatcherStatusDialog
extends JDialog
implements ActionListener {
    static SafeResourceBundle watchersBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private JList statusList = new JList();
    private Vector watchers = null;
    private JButton btnAdd = new JButton();
    private JButton btnDeny = new JButton();
    private iIMListModel model;
    private iIMListRenderer renderer;

    public WatcherStatusDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.InitComponents(modal);
        this.pack();
    }

    private void InitComponents(boolean modal) {
        this.setModal(modal);
        JPanel btnPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridLayout gridLayout = new GridLayout(1, 0, 5, 0);
        btnPanel.setLayout(gridLayout);
        SwingUtils.setupButton(this.btnAdd, watchersBundle, "Add_To_Contact_List", "Add_To_Contact_List_M", null, null);
        SwingUtils.setupButton(this.btnDeny, watchersBundle, "Deny_User_Access", "Deny_User_Access_M", null, null);
        this.btnAdd.addActionListener(this);
        this.btnDeny.addActionListener(this);
        btnPanel.add(this.btnAdd);
        btnPanel.add(this.btnDeny);
        DialogButtonsPanel pnlButtons = new DialogButtonsPanel(this);
        JScrollPane statusScrollPane = new JScrollPane();
        JLabel lblHeader = new JLabel();
        String lblHeaderTxt = "<html>" + watchersBundle.getString("view_others_header") + "</html>";
        lblHeader.setText(lblHeaderTxt);
        this.watchers = BuddyListManager.getWatchers();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)lblHeader, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)statusScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)btnPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(17, 12, 12, 12);
        this.getContentPane().add((Component)pnlButtons, gridBagConstraints);
        this.model = new iIMListModel(this.statusList, this.watchers);
        this.renderer = new iIMListRenderer(this.model);
        this.statusList.setModel(this.model);
        this.statusList.setCellRenderer(this.renderer);
        this.statusList.setSelectionMode(0);
        statusScrollPane.getViewport().setView(this.statusList);
        pnlButtons.setDefaultButton(4);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.OK();
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (actionCommand == "help") {
            this.help();
        } else if (object == this.btnAdd) {
            this.addToContactList();
        } else if (object == this.btnDeny) {
            this.denyUsers();
        }
    }

    private void OK() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void help() {
        HelpManager.showHelp("watchers");
    }

    private void addToContactList() {
        if (this.statusList.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, watchersBundle.getString("Please_select_a_watcher"));
        } else {
            PersonalStoreEntry pse = (PersonalStoreEntry)this.statusList.getSelectedValue();
            if (pse == null) {
                return;
            }
            Manager.debug("uid = " + pse.getEntryId());
            try {
                Manager._presenceSession.subscribe(pse.getEntryId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.watchers.remove(pse);
            this.model.changed();
            iIM.getBuddyList().update(false);
        }
    }

    private void denyUsers() {
        if (this.statusList.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, watchersBundle.getString("Please_select_a_watcher"));
        } else {
            PersonalStoreEntry pse = (PersonalStoreEntry)this.statusList.getSelectedValue();
            this.watchers.remove(pse);
            this.model.changed();
            BuddyListManager.removeWatcher(pse.getEntryId());
        }
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatcherStatusDialog.this.close();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }
}

